/* main.h
 *
 * Main Game
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <string>
#include <iostream>
#include <stdlib.h>
#include <time.h>

#include "minigame.h"
#include "minigames.h"
#include "minigamemanager.h"
#include "init.h"
#include "misc.h"
#include "train.h"

#include "mgmenu.h"

using MiniGameManagement::MiniGameManager;

#define TIMER_FREQ 100

volatile bool TimerActive = false;
volatile int GameTime = 0, CurFPS = 0, FPS = 0, SecTrack = 0, SElapsed = 0;
void GameTimer()
{
	++GameTime;
	++SecTrack;
	
	if(SecTrack >= TIMER_FREQ)
	{
		FPS = CurFPS;
		CurFPS = 0;
		SecTrack -= TIMER_FREQ;
		if(TimerActive)
			++SElapsed;
	}
}

const char *Track = "~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^"; // Should be enough, I hope!

int main()
{
	//InitGame(std::string WindowTitle, int GraphicsMode1, int GraphicsMode2, int GfxW, int GfxH, void(*TimerFunc)(), int TimerFreq)
	if(!GameInit::InitGame("Train Stopper", GFX_AUTODETECT_WINDOWED, GFX_AUTODETECT, 800, 600, GameTimer, BPS_TO_TIMER(TIMER_FREQ)))
		return -1;
	
	BITMAP *buffer = create_bitmap(SCREEN_W, SCREEN_H);
	
	MiniGameManager *MGM = new MiniGameManager();
	REGISTER_ALL_GAMES(MGM);
	
	MGM->NewMiniGame();
	
	bool endgame = false;
	volatile int TrackAnimIndex = 0;
	
	int TotalTime = 366;
	
	TrainSys::Train Train;
	TimerActive = true;
	bool GameActive = false;
	bool WonGame = false;
	
	while(!endgame)
	{
		while(GameTime > 0)
		{
			poll_keyboard();
			
			if(GameActive)
			{
				TimerActive = !MGM->HelpShow;
				MGM->Tick(TotalTime - SElapsed);
				
				if(!MGM->ActivePlay)
				{
					if(MGM->WonLastGame)
					{
						Train.Speed -= MGM->LastWonPoints / 2;
						MGM->EndMiniGame();
						TimerActive = true;
						GameActive = false;
					}
				}
			}
			
			if(key[KEY_ESC])
				endgame = true;
			
			if(++TrackAnimIndex > 40)
				TrackAnimIndex -= 40;
			
			Train.Tick();
			
			if(key[KEY_UP] && (key_shifts & KB_CTRL_FLAG) && Train.Speed < 100)
				++Train.Speed;
			if(key[KEY_DOWN] && (key_shifts & KB_CTRL_FLAG) && Train.Speed > 0)
				--Train.Speed;
			
			if(key[KEY_HOME] && !GameActive)
			{
				GameActive = true;
				MGM->NewMiniGame();
			}
			if(key[KEY_TAB] && !GameActive)
			{
				GameActive = true;
				TimerActive = false;
				MGM->NewMiniGame((MiniGameManagement::MGMenu(MGM->MiniGames)).GetChoice((int *)&GameTime));
				TimerActive = true;
			}
			if(key[KEY_END] && GameActive)
			{
				GameActive = false;
				TimerActive = true;
				MGM->EndMiniGame();
				SElapsed += 30;
			}
			
			if(TotalTime - SElapsed <= 0)
			{
				endgame = true;
				WonGame = false;
			}
			if(Train.Speed <= 0)
			{
				endgame = true;
				WonGame = true;
			}
			
			--GameTime;
		}
		
		clear_bitmap(buffer);
		
		if(GameActive)
			MGM->Draw(buffer);
		else
			Train.Draw(buffer, 0, 50, SCREEN_W);
		
		textprintf_right_ex(buffer, font, SCREEN_W, 0, makecol(255, 255, 255), makecol(0, 0, 0), "FPS: %d", FPS);
		textprintf_right_ex(buffer, font, SCREEN_W, text_height(font), makecol(255, 255, 255), makecol(0, 0, 0), "Time Left: %d:%02d", (TotalTime - SElapsed) / 60, (TotalTime - SElapsed) % 60);
		textprintf_right_ex(buffer, font, SCREEN_W, text_height(font) * 2, makecol(255, 255, 255), makecol(0, 0, 0), "Speed: %d MPH", Train.Speed * 2);
		
		blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		++CurFPS;
	}
	
	Misc::Obscure(buffer);
	
	int blah = text_length(font, "Congratulations! You have stopped the train! You win!");
	rectfill(buffer, (SCREEN_W / 2) - (blah / 2), SCREEN_H / 2 - (text_height(font) * 2), (SCREEN_W / 2) + (blah / 2), SCREEN_H / 2 + (text_height(font) * 2), makecol(47, 158, 249));
	
	if(WonGame)
		textprintf_centre_ex(buffer, font, SCREEN_W / 2, SCREEN_H / 2 - text_height(font), makecol(255, 255, 255), -1, "Congratulations! You have stopped the train! You win!");
	else
		textprintf_centre_ex(buffer, font, SCREEN_W / 2, SCREEN_H / 2 - text_height(font), makecol(255, 255, 255), -1, "Aww! You did not stop the train! You lose!");
	textprintf_centre_ex(buffer, font, SCREEN_W / 2, SCREEN_H / 2 + text_height(font), makecol(255, 255, 255), -1, "Press any key to exit.");
	
	blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	
	rest(200);
	clear_keybuf();
	readkey();
	
	destroy_bitmap(buffer);
}
END_OF_MAIN()
