/* init.cpp
 *
 * Game Initialization
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <string>

#include "init.h"

bool GameInit::InitGame(std::string WindowTitle, int GraphicsMode1, int GraphicsMode2, int GfxW, int GfxH, void(*TimerFunc)(), int TimerFreq)
{
	if(allegro_init() != 0)
		return false;
	
	if(install_keyboard() != 0)
		return false;
	if(install_timer() != 0)
		return false;
	/*if(install_mouse() != 0)
		return false;*/
	
	set_color_depth(16);
	
	if(set_gfx_mode(GraphicsMode1, GfxW, GfxH, 0, 0) != 0)
	{
		if(set_gfx_mode(GraphicsMode2, GfxW, GfxH, 0, 0) != 0)
			return false;
	}
	
	set_window_title(WindowTitle.c_str());
	
	if(install_int_ex(TimerFunc, TimerFreq) != 0)
		return false;
	
	return true;
}
