/* quickmath.h
 *
 * Quick math mini-game
 *  Answer the math questions quickly!
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#ifndef _MG_QUICKMATH_H
#define _MG_QUICKMATH_H

#include <string>

#include "minigame.h"

namespace MiniGames
{
	struct QuickMath_Problem
	{
		std::string Problem;
    int Answer;
    
    QuickMath_Problem(std::string Problem, int Answer) : Problem(Problem), Answer(Answer) { }
    ~QuickMath_Problem() { }
	};
	
	class QuickMath : public MiniGames::MiniGame
	{
		private:
			int ProbNum, nBuffer;
			QuickMath_Problem *Cur;
		
		private:
			QuickMath_Problem *RandProb();
		
		public:
			QuickMath();
			~QuickMath();
			
			IMPLEMENT_MINIGAME(QuickMath);
			
			void Tick(int TimeLeft);
			void Draw(BITMAP *Buffer);
			
			MiniGames::MiniGameInfo *GetInfo();
	};
}

#endif
