/* arrows.cpp
 *
 * Arrow mini-game
 *  Push the specified arrows!
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>

#include "minigame.h"
#include "arrows.h"

void MiniGames::Arrows::NewArrow()
{
	int NA = rand() % 4;
	
	switch(NA)
	{
		case 0:
			CurArrow = KEY_LEFT;
			break;
		case 1:
			CurArrow = KEY_RIGHT;
			break;
		case 2:
			CurArrow = KEY_UP;
			break;
		case 3:
			CurArrow = KEY_DOWN;
			break;
	}
}

char *MiniGames::Arrows::ArrowName(int A)
{
	switch(A)
	{
		case KEY_LEFT:
			return "Left";
		case KEY_RIGHT:
			return "Right";
		case KEY_UP:
			return "Up";
		case KEY_DOWN:
			return "Down";
	}
	return "Weird - this is a bug!";
}


MiniGames::Arrows::Arrows() : Idx(0), CurArrow(0)
{
	Playing = true;
	WonGame = false;
	
	NewArrow();
}

MiniGames::Arrows::~Arrows()
{
}


void MiniGames::Arrows::Tick(int TimeLeft)
{
	if(TimeLeft <= 0)
		Playing = false;
	
	if(!Playing)
		return;
	
	if(keypressed())
	{
		if(key[CurArrow])
		{
			++Idx;
			NewArrow();
		}
	}
	
	if(Idx == 20)
	{
		Playing = false;
		WonGame = true;
	}
}

void MiniGames::Arrows::Draw(BITMAP *Buffer)
{
	if(!Playing)
		return;
	
	textprintf_ex(Buffer, font, 15, 15, makecol(255, 255, 255), -1, "Arrow %d: %s", Idx, ArrowName(CurArrow));
}

MiniGames::MiniGameInfo *MiniGames::Arrows::GetInfo()
{
	return new MiniGames::MiniGameInfo("Arrows - Worth 10 MPH", "Push the 20 given arrows as fast as you can. The faster you do this, the quicker you get back to your game!", 10);
}
