/* alphabet.cpp
 *
 * Alphabet mini-game
 *  Type the alphabet quickly!
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>

#include "minigame.h"
#include "alphabet.h"

MiniGames::Alphabet::Alphabet() : CurLtr('a')
{
	Playing = true;
	WonGame = false;
}

MiniGames::Alphabet::~Alphabet()
{
}


void MiniGames::Alphabet::Tick(int TimeLeft)
{
	if(TimeLeft <= 0)
		Playing = false;
	
	if(!Playing)
		return;
	
	if(keypressed())
	{
		int key = readkey() & 0xff;
		
		if(key == CurLtr || (key + 32) == CurLtr)
			++CurLtr;
	}
	
	if(CurLtr == 'z' + 1)
	{
		Playing = false;
		WonGame = true;
	}
}

void MiniGames::Alphabet::Draw(BITMAP *Buffer)
{
	if(!Playing)
		return;
	
	textprintf_ex(Buffer, font, 15, 15, makecol(255, 255, 255), -1, "Current Letter: %c", CurLtr);
}

MiniGames::MiniGameInfo *MiniGames::Alphabet::GetInfo()
{
	return new MiniGames::MiniGameInfo("Alphabet - Worth 10 MPH", "Type the alphabet as fast as you can - the longer you take, the less time you will have for other activities and stopping the train.", 10);
}
