/* Train.cpp
 *
 * Train animation and such
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <string>

#include "train.h"
#include "misc.h"

using TrainSys::Train;
using std::string;

//const char *TrackA = "~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^~~~^"; // Should be enough, I hope!
//const char *TrackA = "---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+";
const char *TrackA = " - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - + - - +";
const char *TrainA[15] = { "                                     (@@@)     (@@@@@)", "                               (@@)     (@@@@@@@)        (@@@@@@@)", "                         (@@@@@@@)   (@@@@@)       (@@@@@@@@@@@)", "                    (@@@)     (@@@@@@@)   (@@@@@@)             (@@@)", "               (@@@@@@)    (@@@@@@)                (@)", "           (@@@)  (@@@@)           (@@)", "        (@@)              (@@@)", "       .-.               ", "       ] [    .-.      _    .-----.", "     .\"   \"\"\"\"   \"\"\"\"\"\" \"\"\"\"| .--`", "    (:--:--:--:--:--:--:--:-| [___    .------------------------.", "     |C&O  :  :  :  :  :  : [_9_] |'='|.----------------------.|", "    /|.___________________________|___|'--.___.--.___.--.___.-'| ", "   / ||_.--.______.--.______.--._ |---\\'--\\-.-/==\\-.-/==\\-.-/-'/--", "  /__;^=(==)======(==)======(==)=^~^^^ ^^^^(-)^^^^(-)^^^^(-)^^^ jgs" };
const char *LogoA[6] = {"     _____              _          __  _                                   ", "    /__   \\ _ __  __ _ (_) _ __   / _\\| |_  ___   _ __   _ __    ___  _ __ ", "      / /\\/| '__|/ _` || || '_ \\  \\ \\ | __|/ _ \\ | '_ \\ | '_ \\  / _ \\| '__|", "     / /   | |  | (_| || || | | | _\\ \\| |_ |(_)| | |_) || |_) ||  __/| |   ", "     \\/    |_|   \\__,_||_||_| |_| \\__/ \\__|\\___/ | .__/ | .__/  \\___||_|   ", "    http://www.bafsoft.com/games/trainstop       |_|    |_| (c) BAF 2006   " };

const char *InfoTextC[6] = {
	"ALERT! An elderly lady has FALLEN on your train. You have 6 minutes and 6 seconds to stop the train,",
	"before she falls out and dies. Play through the random mini-games to slow the train down until it",
	"slows to a stop. If you can stop the train in time, you save her and win! Good luck!",
	"  You slow down for each mini-game won. To play a game hit Home. To exit the game, hit End. You are",
	"  penalized for each game you end without finishing. You can choose a mini-game by hitting Tab.",
	"To get help in a game press F1. The timer is stopped while you read the help screens."
};

Train::Train() : Speed(75), TrainB(NULL), ShowHelp(false)
{
	TrainB = create_bitmap(550, text_height(font) * 15);
	clear_to_color(TrainB, makecol(255, 0, 255));
	
	int x = 0, y = 0;
	
	/*textprintf_ex(TrainB, font, x, y + (0 * text_height(font)), makecol(255, 255, 255), makecol(255, 0, 255), "%s", TrainA[0]);
	textprintf_ex(TrainB, font, x, y + (1 * text_height(font)), makecol(255, 255, 255), makecol(255, 0, 255), "%s", TrainA[1]);
	textprintf_ex(TrainB, font, x, y + (2 * text_height(font)), makecol(255, 255, 255), makecol(255, 0, 255), "%s", TrainA[2]);
	textprintf_ex(TrainB, font, x, y + (3 * text_height(font)), makecol(255, 255, 255), makecol(255, 0, 255), "%s", TrainA[3]);
	textprintf_ex(TrainB, font, x, y + (4 * text_height(font)), makecol(255, 255, 255), makecol(255, 0, 255), "%s", TrainA[4]);
	textprintf_ex(TrainB, font, x, y + (5 * text_height(font)), makecol(255, 255, 255), makecol(255, 0, 255), "%s", TrainA[5]);
	textprintf_ex(TrainB, font, x, y + (6 * text_height(font)), makecol(255, 255, 255), makecol(255, 0, 255), "%s", TrainA[6]);*/
	textprintf_ex(TrainB, font, x, y + (7 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[7]);
	textprintf_ex(TrainB, font, x, y + (8 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[8]);
	textprintf_ex(TrainB, font, x, y + (9 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[9]);
	textprintf_ex(TrainB, font, x, y + (10 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[10]);
	textprintf_ex(TrainB, font, x, y + (11 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[11]);
	textprintf_ex(TrainB, font, x, y + (12 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[12]);
	textprintf_ex(TrainB, font, x, y + (13 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[13]);
	textprintf_ex(TrainB, font, x, y + (14 * text_height(font)), makecol(128, 128, 128), makecol(255, 0, 255), "%s", TrainA[14]);
}

Train::~Train()
{
	destroy_bitmap(TrainB);
}


void Train::Tick()
{
	AnimIndex += Speed;
	if(AnimIndex > 400)
		AnimIndex -= 400;
}

void Train::Draw(BITMAP *Buffer, int x, int y, int w)
{
	// 15 lines
	int TrainHeight = text_height(font) * 15;
	int TrackHeight = text_height(font);
	
	masked_blit(TrainB, Buffer, 0, 0, SCREEN_W - 550, y, 550, TrainHeight);
	textprintf_ex(Buffer, font, x, y + TrainHeight, makecol(128, 64, 0), makecol(0, 0, 0), "%s", TrackA + (4 - (AnimIndex / 100)) % 4);
	
	textprintf_ex(Buffer, font, x, y + text_height(font) * 20, makecol(255, 255, 255), makecol(0, 0, 0), "%s", LogoA[0]);
	textprintf_ex(Buffer, font, x, y + text_height(font) * 21, makecol(255, 255, 255), makecol(0, 0, 0), "%s", LogoA[1]);
	textprintf_ex(Buffer, font, x, y + text_height(font) * 22, makecol(255, 255, 255), makecol(0, 0, 0), "%s", LogoA[2]);
	textprintf_ex(Buffer, font, x, y + text_height(font) * 23, makecol(255, 255, 255), makecol(0, 0, 0), "%s", LogoA[3]);
	textprintf_ex(Buffer, font, x, y + text_height(font) * 24, makecol(255, 255, 255), makecol(0, 0, 0), "%s", LogoA[4]);
	textprintf_ex(Buffer, font, x, y + text_height(font) * 25, makecol(255, 255, 255), makecol(0, 0, 0), "%s", LogoA[5]);
	
	textprintf_ex(Buffer, font, x, (y + 60) + text_height(font) * 20, makecol(255, 255, 255), makecol(0, 0, 0), "%s", InfoTextC[0]);
	textprintf_ex(Buffer, font, x, (y + 60) + text_height(font) * 21, makecol(255, 255, 255), makecol(0, 0, 0), "%s", InfoTextC[1]);
	textprintf_ex(Buffer, font, x, (y + 60) + text_height(font) * 22, makecol(255, 255, 255), makecol(0, 0, 0), "%s", InfoTextC[2]);
	textprintf_ex(Buffer, font, x, (y + 60) + text_height(font) * 23, makecol(255, 255, 0), makecol(0, 0, 0), "%s", InfoTextC[3]);
	textprintf_ex(Buffer, font, x, (y + 60) + text_height(font) * 24, makecol(255, 255, 0), makecol(0, 0, 0), "%s", InfoTextC[4]);
	textprintf_ex(Buffer, font, x, (y + 60) + text_height(font) * 27, makecol(255, 255, 255), makecol(0, 0, 0), "%s", InfoTextC[5]);
}
