/* misc.h
 *
 * Misc Stuff
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/
 
#include <allegro.h>
#include <string>
#include <string.h>
#include <stdlib.h>

#include "misc.h"
 
int Misc::MGMtextoutWordWrap(BITMAP* dst, FONT* font, int x, int y, int w, int h, int col, int bgcol, char* text)
{
	int height = text_height(font);
	
	char *start = NULL;
	char *end = NULL;
	
	static char delim[] = " ";
	char *token = NULL;
	int curX = x;
	int curY = y;
	int space = text_length(font, " ");
	int len = 0;
	int maxX = x + w;
	int maxY = y + h;
	int getToken = TRUE;
	char oneChar[] = "X";
	
	start= text;
	end = strchr(start, '\n');
	while (end != NULL)
	{
		*end='\0';
		
		token = strtok(start, delim);
		while (token != NULL)
		{
			len = text_length(font , token);
			
			getToken = TRUE;
			if (curX + len > maxX)
			{
				if (len > w)
				{
					// the token does not fit into a single line
					getToken = FALSE;
					
					while (curX < maxX && *token)
					{
						// there's no char_out function, so we'll use a two char string
						*oneChar = *token;
						if(*oneChar == '')
							*oneChar = ' ';
						len = text_length(font, oneChar);
						if (curX + len < maxX)
						{
							token++;
							textout_ex(dst, font, oneChar, curX, curY, col, bgcol);
						}
						curX += len;
					}
						rectfill(dst, curX, curY, maxX, curY + text_height(font), bgcol);
					curY += height;
					curX = x;
				}
				else
				{
					curX = x;
					curY += height;
					
					std::string replacement = token;
					std::string::size_type pos = replacement.find("", 0);
					while(pos != std::string::npos)
					{
						replacement[pos] = ' ';
						pos = replacement.find("", pos);
					}
					textout_ex(dst, font, replacement.c_str(), curX, curY, col, bgcol);
					//textout_ex(dst, font, token, curX, curY, col, bgcol);
					
					curX += len + space;
				}
			}
			else
			{
				std::string replacement = token;
				std::string::size_type pos = replacement.find("", 0);
				while(pos != std::string::npos)
				{
					replacement[pos] = ' ';
					pos = replacement.find("", pos);
				}
				textout_ex(dst, font, replacement.c_str(), curX, curY, col, bgcol);
				//textout_ex(dst, font, token, curX, curY, col, bgcol);
				curX += len + space;
			}
			
			if (getToken)
			{
				token = strtok(NULL, delim);
			}
		}
		
		start = end+1;
		end = strchr(start, '\n');
		rectfill(dst, curX, curY, maxX, curY + text_height(font), bgcol);
		curY += height;
		curX = x;
	}
	
	return curY;
}

void Misc::GaussBlur(BITMAP *Bmp)
{
	BITMAP *tmp1 = create_bitmap(Bmp->w, Bmp->h);
	BITMAP *tmp2 = create_bitmap(Bmp->w, Bmp->h);
	
	int GaussWidth = 11;
	int GaussFact[11] = { 1, 10, 45, 120, 210, 252, 210, 120, 45, 10, 1 };
	
	int SumR = 0, SumG = 0, SumB = 0;
	int GaussSum = 1024;
	int Col = 0, R, G, B;
	
	for(int i = 1; i < tmp1->w - 1; ++i)
	{
		for(int j = 1; j < tmp1->h - 1; ++j)
		{
			SumR = SumG = SumB = 0;
			for(int k = 0; k < GaussWidth; ++k)
			{
				Col = _getpixel16(Bmp, i - ((GaussWidth - 1) >> 1) + k, j);
				R = getr16(Col);
				G = getg16(Col);
				B = getb16(Col);
				
				SumR += R * GaussFact[k];
				SumG += G * GaussFact[k];
				SumB += B * GaussFact[k];
			}
			putpixel(tmp1, i, j, makecol(SumR / GaussSum, SumG / GaussSum, SumB / GaussSum));
		}
	}
	
	/*for(int i = 1; i < Bmp->w - 1; ++i)
	{
		for(int j = 1; j < Bmp->h - 1; ++j)
		{
			SumR = SumG = SumB = 0;
			for(int k = 0; k < GaussWidth; ++k)
			{
				Col = getpixel(tmp1, i, j - ((GaussWidth - 1) >> 1) + k);
				R = getr(Col);
				G = getg(Col);
				B = getb(Col);
				
				SumR += R * GaussFact[k];
				SumG += G * GaussFact[k];
				SumB += B * GaussFact[k];
			}
			
			SumR /= GaussSum;
			SumG /= GaussSum;
			SumB /= GaussSum;
			
			putpixel(tmp2, i, j, makecol(SumR, SumG, SumB));
		}
	}*/
	
	blit(tmp1, Bmp, 0, 0, 0, 0, Bmp->w, Bmp->h);
	destroy_bitmap(tmp1);
	destroy_bitmap(tmp2);
}

void Misc::Obscure(BITMAP *B)
{
	BITMAP *tmp = create_bitmap(B->w / 3, B->h / 3);
	
	stretch_blit(B, tmp, 0, 0, B->w, B->h, 0, 0, tmp->w, tmp->h);
	stretch_blit(tmp, B, 0, 0, tmp->w, tmp->h, 0, 0, B->w, B->h);
	
	destroy_bitmap(tmp);
}
