/* quickmath.cpp
 *
 * Quick math mini-game
 *  Answer the math questions quickly!
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <string>
#include <sstream>
#include <iostream>
#include <stdlib.h>
#include <time.h>

#include "minigame.h"
#include "quickmath.h"

MiniGames::QuickMath_Problem *MiniGames::QuickMath::RandProb()
{
	int N1, N2, Op, Ans;
	std::stringstream Problem;
	
	Op = rand() % 3;
	switch(Op)
	{
		case 0: // add
		case 1: // subtract
			do
			{
				N1 = (rand() % 400) + 1;
				N2 = (rand() % 200) + 1;
			} while (N2 > N1);
			
			Problem << N1;
			if(Op == 0)
			{
				Ans = N1 + N2;
				Problem << " + ";
			}
			else
			{
				Ans = N1 - N2;
				Problem << " - ";
			}
			Problem << N2;
			
			break;
		
		case 2: // multiply
			N1 = (rand() % 10) + 1;
			N2 = (rand() % 10) + 1;
			Ans = N1 * N2;
			Problem << N1 << " * " << N2;
			
			break;
		
		case 3: // divide
			// disabled - we should never get a divide
			
			break;
	}
	
	return new MiniGames::QuickMath_Problem(Problem.str(), Ans);
}



MiniGames::QuickMath::QuickMath() : ProbNum(0), nBuffer(0), Cur(NULL)
{
	Playing = true;
	WonGame = false;
	
	//srand(time(NULL));
}

MiniGames::QuickMath::~QuickMath()
{
}


void MiniGames::QuickMath::Tick(int TimeLeft)
{
	if(TimeLeft <= 0)
		Playing = false;
	
	if(!Playing)
		return;
	
	if(!Cur)
		Cur = RandProb();
	
	if(keypressed())
	{
		int key = readkey();
		
		if((key >> 8) == KEY_ENTER || (key >> 8) == KEY_ENTER_PAD)
		{
			if(nBuffer == Cur->Answer)
			{
				if(++ProbNum > 10)
				{
					Playing = false;
					WonGame = true;
				}
				
				delete Cur;
				Cur = NULL;
			}
			
			nBuffer = 0;
		}
		else if((key >> 8) == KEY_BACKSPACE)
		{
			/*nBuffer -= (nBuffer - (nBuffer % 10));
			nBuffer /= 10;*/
			nBuffer = 0;
		}
		else
		{
			int num = key & 0xff;
			num -= 48;
			
			if(num >= 0 && num <= 9)
			{
				nBuffer *= 10;
				nBuffer += num;
			}
		}
	}
}

void MiniGames::QuickMath::Draw(BITMAP *Buffer)
{
	if(!Playing)
		return;
	
	if(!Cur)
		return;
	
	textprintf_ex(Buffer, font, 15, 15, makecol(255, 255, 255), -1, "Current Problem: %s = %d", Cur->Problem.c_str(), nBuffer);
}

MiniGames::MiniGameInfo *MiniGames::QuickMath::GetInfo()
{
	return new MiniGames::MiniGameInfo("Quick Math - Worth 25 MPH", "Answer the 10 simple math questions as quicky as you can - the longer you take, the less time you will have for other activities and stopping the train.", 25);
}
