/* numberloop.cpp
 *
 * Number Loop mini-game
 *  Solve the Puzzle!
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <iostream>
#include <stdlib.h>
#include <time.h>

#include "minigame.h"
#include "numberloop.h"

/*
           0
           |
           |
           X
           |
           |
 1 2 3 4 5 6 7  8  9  10
11                      12
 13 14 15 16 17 18 19 20
 */

MiniGames::NumberLoop::NumberLoop() : Pos(0), Num(0)
{
	Playing = true;
	WonGame = false;
	
//	srand(time(NULL));
	for(int i = 0; i < 20; ++i)
	{
		Board[i] = i + 1;
	}
	// shuffle it
	for(int i = 0; i < 20; ++i)
	{
		int idx = rand() % 20;
		int tmp = Board[i];
		Board[i] = Board[idx];
		Board[idx] = tmp;
	}
}

MiniGames::NumberLoop::~NumberLoop()
{
}


void MiniGames::NumberLoop::Tick(int TimeLeft)
{
	if(TimeLeft <= 0)
		Playing = false;
	
	if(!Playing)
		return;
	
	if(keypressed())
	{
		int key = readkey() >> 8;
		
		if(key == KEY_LEFT)
		{
			if(++Pos == 20)
				Pos = 0;
		}
		if(key == KEY_RIGHT)
		{
			if(--Pos == -1)
				Pos = 19;
		}
		
		if(key == KEY_SPACE)
		{
			int tmp;
			tmp = Board[(Pos + 5) % 20];
			Board[(Pos + 5) % 20] = Num;
			Num = tmp;
			//Board[Pos] = Board[(Pos + 5) % 20];
			//Board[(Pos + 5) % 20] = tmp;
		}
		
		if(key == KEY_Z)
		{
			std::cout << "if(Num == 0 ";
			for(int i = 0; i < 20; ++i)
			{
				std::cout << "&& Board[(Pos + " << i << ") % 20] == " << Board[i] << " ";
			}
			std::cout << ")";
		}
	}
	
	bool Complete = false;
	for(int i = 0; i < 20; ++i)
	{
//		if(!(Num == 0 && Board[(i + 0) % 20] == 6 && Board[(i + 1) % 20] == 7 && Board[(i+ 2) % 20] == 8 && Board[(i + 3) % 20] == 9 && Board[(i + 4) % 20] == 11 &&Board[(i + 5) % 20] == 20 && Board[(i + 6) % 20] == 19 && Board[(i + 7) %20] == 18 && Board[(i + 8) % 20] == 17 && Board[(i + 9) % 20] == 16 && Board[(i + 10) % 20] == 15 && Board[(i + 11) % 20] == 14 && Board[(i + 12) % 20] == 13 && Board[(i + 13) % 20] == 12 && Board[(i + 14) % 20] == 10 && Board[(i + 15) % 20] == 1 && Board[(i + 16) % 20] == 2 && Board[(i + 17) % 20]== 3 && Board[(i + 18) % 20] == 4 && Board[(i + 19) % 20] == 5))
		if(Num == 0 && Board[(i + 0) % 20] == 1 && Board[(i + 1) % 20] == 2 && Board[(i + 2) % 20] == 3 && Board[(i + 3) % 20] == 4 && Board[(i + 4) % 20] ==5 && Board[(i + 5) % 20] == 6 && Board[(i + 6) % 20] == 7 && Board[(i + 7) % 20] == 8 && Board[(i + 8) % 20] == 9 && Board[(i + 9) % 20] == 11 && Board[(i + 10) % 20] == 20 && Board[(i + 11) % 20] == 19 && Board[(i + 12) % 20] == 18 && Board[(i + 13) % 20] == 17 && Board[(i + 14) % 20] == 16 && Board[(i + 15) % 20] == 15 && Board[(i + 16) % 20] == 14 && Board[(i + 17) % 20] == 13 && Board[(i + 18) % 20] == 12 && Board[(i + 19) % 20] == 10 )
		{
			Complete = true;
			break;
		}
	}
	
	if(Complete)
	{
		Playing = false;
		WonGame = true;
	}
}

void MiniGames::NumberLoop::Draw(BITMAP *Buffer)
{
	if(!Playing)
		return;
	
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (0 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "           %02d           ", Num);
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (1 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "           |           ");
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (2 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "           |           ");
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (3 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "           X           ");
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (4 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "           |           ");
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (5 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "           |           ");
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (6 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), " %02d %02d %02d %02d %02d %02d %02d %02d %02d", Board[(Pos + 1) % 20], Board[(Pos + 2) % 20], Board[(Pos + 3) % 20], Board[(Pos + 4) % 20], Board[(Pos + 5) % 20], Board[(Pos + 6) % 20], Board[(Pos + 7) % 20], Board[(Pos + 8) % 20], Board[(Pos + 9) % 20]);
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (7 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "%02d                         %02d", Board[(Pos + 20) % 20], Board[(Pos + 10) % 20]);
	textprintf_centre_ex(Buffer, font, Buffer->w / 2, 20 + (8 * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), " %02d %02d %02d %02d %02d %02d %02d %02d %02d", Board[(Pos + 19) % 20], Board[(Pos + 18) % 20], Board[(Pos + 17) % 20], Board[(Pos + 16) % 20], Board[(Pos + 15) % 20], Board[(Pos + 14) % 20], Board[(Pos + 13) % 20], Board[(Pos + 12) % 20], Board[(Pos + 11) % 20]);
}

MiniGames::MiniGameInfo *MiniGames::NumberLoop::GetInfo()
{
	return new MiniGames::MiniGameInfo("Number Loop - Worth 80 MPH", "Theideaistoorganizethenumbersintheloop.Theleftandrightarrowsrotatetheloop.Pressingspaceswapsthevalueabovethelineandunderit.Theideaistogetthelooptolooklikethefollowing:\n0\n|\n|\nX\n|\n|\n010203040506070809\n1011\n121314151617181920\n\nThequickeryouaccomplishthis,thequickeryoucangetbacktostoppingthetrain!", 80);
}
