/* cowbull.h
 *
 * Cow/Bull Mini-game
 *  A Simple implementation of Cows and Bulls
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#ifndef _MG_COWBULL_H
#define _MG_COWBULL_H

#include <vector>

#include "minigame.h"

namespace MiniGames
{
	struct CowBull_Guess
	{
		int Guess, Cows, Bulls;
		
		CowBull_Guess(int Guess, int Cows, int Bulls) : Guess(Guess), Cows(Cows), Bulls(Bulls) { }
		~CowBull_Guess() { }
	};
	
	class CowBull : public MiniGames::MiniGame
	{
		private:
			int Number[4], Digits[4], DPos;
			std::vector<CowBull_Guess> GuessList;
		
		public:
			CowBull();
			~CowBull();
			
			IMPLEMENT_MINIGAME(CowBull);
			
			void Tick(int TimeLeft);
			void Draw(BITMAP *Buffer);
			
			MiniGames::MiniGameInfo *GetInfo();
	};
}

#endif
