/* cowbull.cpp
 *
 * Cow/Bull Mini-game
 *  A Simple implementation of Cows and Bulls
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#include <allegro.h>
#include <stdlib.h>
#include <time.h>

#include "minigame.h"
#include "cowbull.h"

MiniGames::CowBull::CowBull() : DPos(0)
{
	Playing = true;
	WonGame = false;
	
	Digits[0] = Digits[1] = Digits[2] = Digits[3] = 0;
	
//	srand(time(NULL));
	Number[0] = rand() % 10;
	Number[1] = rand() % 10;
	Number[2] = rand() % 10;
	Number[3] = rand() % 10;
}

MiniGames::CowBull::~CowBull()
{
	for(std::vector<CowBull_Guess>::iterator i = GuessList.begin(); i != GuessList.end(); ++i)
	{
		//delete &(*i);
	}
}


void MiniGames::CowBull::Tick(int TimeLeft)
{
	if(TimeLeft <= 0)
		Playing = false;
	
	if(!Playing)
		return;
	
	if(keypressed())
	{
		int key = readkey() & 0xff;
		int num = key - 48;
		
		if(num > -1 && num < 10)
			Digits[DPos++] = num;
	}
	
	if(DPos == 4)
	{
		// Check the answer
		int Cows = 0, Bulls = 0;
		bool Counted[4];
		Counted[0] = Counted[1] = Counted[2] = Counted[3] = false;
		
		for(int i = 0; i < 4; ++i)
		{
			if(Digits[i] == Number[i] && !Counted[i])
			{
				Counted[i] = true;
				++Bulls;
			}
			else
			{
				for(int j = 0; j < 4; ++j)
				{
					if(Digits[i] == Number[j] && !Counted[j])
					{
						Counted[j] = true;
						++Cows;
						break;
					}
				}
			}
		}
		GuessList.push_back(CowBull_Guess((Digits[0] * 1000) + (Digits[1] * 100) + (Digits[2] * 10) + Digits[3], Cows, Bulls));
		
		if(Bulls == 4)
		{
			Playing = false;
			WonGame = true;
		}
		
		// Clear the stuff
		DPos = Digits[0] = Digits[1] = Digits[2] = Digits[3] = 0;
	}
}

void MiniGames::CowBull::Draw(BITMAP *Buffer)
{
	if(!Playing)
		return;
	
	textprintf_ex(Buffer, font, 50, 50, makecol(255, 255, 255), makecol(0, 0, 0), "Guess:  %d %d %d %d", Digits[0], Digits[1], Digits[2], Digits[3]);
	textprintf_ex(Buffer, font, 50, 50, makecol(255, 255, 255), -1, "        %c %c %c %c", (DPos == 0 ? '_' : ' '), (DPos == 1 ? '_' : ' '), (DPos == 2 ? '_' : ' '), (DPos == 3 ? '_' : ' '));
	
	textprintf_ex(Buffer, font, 25, 75, makecol(255, 255, 255), makecol(0, 0, 0), "Previous Guesses:");
	int num_guesses = (SCREEN_H - 100) / text_height(font);
	num_guesses = (num_guesses < GuessList.size()) ? num_guesses : GuessList.size();
	if(num_guesses > 0)
	{
		for(int i = num_guesses - 1; i >= 0; --i)
		{
			int j = GuessList.size() - i - 1;
			textprintf_ex(Buffer, font, 40, 90 + (i * text_height(font)), makecol(255, 255, 255), makecol(0, 0, 0), "Guess %d: %04d   Cows: %d  Bulls: %d", j + 1, GuessList[j].Guess, GuessList[j].Cows, GuessList[j].Bulls);
		}
	}
}

MiniGames::MiniGameInfo *MiniGames::CowBull::GetInfo()
{
	return new MiniGames::MiniGameInfo("Cows and Bulls - Worth 55 MPH", "This is a simple version of Cows and Bulls. The computer will pick a 4 digit number at random. Your job is to guess this number. When you guess, you are given Cows and Bulls to say how you are doing. A bull means one of your digits is correct and in the correct position. A cow means one of your digits is correct but not in the correct position. Keep guessing until you get the number. The quicker you finish, the sooner you can get back to stopping the train.", 55);
}
