/* minigame.h
 *
 * Mini-game template
 *
 * by BAF (c) 2006 Robert A. Ferris III
 *  made for TINS 2006
 */

/*
  Train Stopper, version 1.0, March 05, 2006

  Copyright (C) 2006 Robert Ferris

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Robert Ferris baf@bafsoft.com
	*/

#ifndef _MINIGAME_H
#define _MINIGAME_H

#include <allegro.h>
#include <string>

#define IMPLEMENT_MINIGAME(mg) public: static MiniGames::MiniGame *Factory() { return new mg(); }

namespace MiniGames
{
  struct MiniGameInfo
  {
    std::string GameName;
    std::string Directions;
    int Points;
    
    MiniGameInfo(std::string GameName, std::string Directions, int Points) : GameName(GameName), Directions(Directions), Points(Points) { }
    ~MiniGameInfo() { }
  };
  
  class MiniGame
  {
    public:
      bool Playing;
      bool WonGame;
    
    public:
      MiniGame() { };
      ~MiniGame() { };
      
      virtual void Tick(int TimeLeft) = 0;
      virtual void Draw(BITMAP *Buffer) = 0;
      
      virtual MiniGameInfo *GetInfo() = 0;
  };
}

#endif
