#include "sparksystem.h" // class's header file
/*
int SmokeSystem::create(CVector3 _pos, CVector3 _direction, int _number_of_particles, SmokeAtts _atts)
{
    ParticleSystem::create(_pos,_direction,_number_of_particles);
    atts = _atts;
}*/

void SparksSystem::startSystem(void)
{
    killAllParticles();     //kill all of the particles in the system
    running=true;
    for(int n=0 ; n<atts.start_density && n<number_of_particles ; n++)
    {
        setupParticle(&particles[n]);
    }
}



void SparksSystem::setupParticle(Particle *part)
{
    CVector3 particle_pos = pos;
    CVector3 posr = makeVector3( atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius,
                                 atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius,
                                 atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius ); 
    
    CVector3 particle_vel = direction;
    float particle_size = atts.particle_size * ((float)(rand()%50)+50)/100 * 1.5;
    //particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
    //particle_vel = particle_vel.rotateAboutY( ((float)(rand()%100))/100 * 2*M_PI);
    
    float temp = ((float)(rand()%100))/100 * atts.sprayArc - atts.sprayArc/2;
    if(temp<0)
        temp+=2*M_PI;
    else if(temp>2*M_PI)
        temp-=2*M_PI;
    particle_vel = particle_vel.rotateAboutZ(  /*((float)(rand()%100))/100 * atts.sprayArc - atts.sprayArc/2*/temp);
    
    
    particle_pos += posr;
    part->setup(particle_pos/*makeVector3(0,0,-5)*/,particle_vel,atts.colour,atts.particle_lifespan,particle_size,atts.base_opacity);
}

void SparksSystem::makeExplosion(void)
{
    CVector3 particle_pos;
    CVector3 posr;     
    CVector3 particle_vel;
    int n;
    float velRand;
    float particle_size;
    
    atts.radius=2;

    for(n=0 ; n<20 ; n++)
    {
        particle_pos = pos;
        velRand = (float)(rand()%100);
        particle_vel = makeVector3(.2-(velRand/500),0,0);
    
        posr= makeVector3( atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius,
                                 atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius,
                                 atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius ); 
    
        atts.particle_size=6;
        atts.particle_lifespan=100 - (int)(velRand/4);
        atts.colour=makeColour(1-(rand()%100)/500 , .7-(rand()%100)/500 , 0 );
    
        particle_size = atts.particle_size * ((float)(rand()%50)+50)/100 * 1.5;
        //particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        
        particle_vel = particle_vel.rotateAboutZ( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutY( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        

        particle_pos += posr;
        particles[n].setup(particle_pos,particle_vel,atts.colour,atts.particle_lifespan,particle_size,/*atts.base_opacity*/.5);
    }
    
    
    
    for(; n<55 ; n++)
    {
        particle_pos = pos;
        velRand = (float)(rand()%100);
        particle_vel = makeVector3(1.2-(velRand/500),0,0);

        posr= makeVector3( atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius,
                                 atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius,
                                 atts.radius * 2 * ((float)(rand()%100))/100 - atts.radius ); 


        atts.particle_size=3;
        atts.particle_lifespan=100 - (int)(velRand/4);
        atts.colour=makeColour(.8-(rand()%100)/500 , .4-(rand()%100)/500 , 0 );
    
        particle_size = ((float)(rand()%100))/50 + atts.particle_size;
        //particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        
        particle_vel = particle_vel.rotateAboutZ( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutY( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        //

        particle_pos += posr;
        particles[n].setup(particle_pos,particle_vel,atts.colour,atts.particle_lifespan,particle_size,/*atts.base_opacity*/.6);
    }
    
    float ang=0;
    float degStep=0.1047;  //60 particles, 360 degrees in circle
    float r=2;
    CVector3 temp;
    float ang2=(float)(rand()%100)/100 * M_PI;
    
    for(; n<115 ; n++)
    {
        float px=r*cos(ang),
            py=0,
            pz=r*sin(ang);
         
         atts.colour=makeColour(1-(rand()%100)/500 , 0 ,.4-(rand()%100)/500 );
        /*float px=pos.x;
        float py=pos.y;
        float pz=pos.z;*/
           
           temp = makeVector3(px,py,pz);
           temp = temp.rotateAboutX(ang2);
           particle_pos = makeVector3(pos.x+temp.x,pos.y+temp.y,pos.z+temp.z);
           
        //article_pos = makeVector3(px,py,pz);
        

        particle_vel = makeVector3(particle_pos.x-pos.x,particle_pos.y-pos.y,particle_pos.z-pos.z);
        particle_vel=particle_vel/(1.5 - ((float)(rand()%100))/1000 );
        //particle_vel = particle_vel.rotateAboutX(  M_PI/4 );
                
                
        
        atts.particle_lifespan=150;
        
        atts.particle_size=4;
        particle_size = atts.particle_size * ((float)(rand()%50)+50)/100 * 1.5;
        
        particles[n].setup(particle_pos,particle_vel,atts.colour,atts.particle_lifespan,particle_size,atts.base_opacity);
        ang+=degStep;
    }
    
    
}

void SparksSystem::draw(void)
{
    ParticleSystem::draw();
    
    glEnable(GL_BLEND);		// Turn Blending On
    glDepthMask(false);
    glDisable(GL_LIGHTING);
    
    if(atts.blendMode==BM_FIRE)
        glBlendFunc(GL_SRC_ALPHA,GL_ONE);
    else if(atts.blendMode==BM_SMOKE)
        glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
    //glBlendFunc(GL_SRC_COLOR, GL_ONE);
    //glBlendFunc(GL_SRC_COLOR,GL_ZERO);

    if(texture!=-1)
    {
        glEnable(GL_TEXTURE_2D);
        glBindTexture(GL_TEXTURE_2D,texture);
        //glColor3f(1,0,0);
        
   //     float temp[4]={1,0,0,1};
   //     glMaterialfv( GL_FRONT, GL_DIFFUSE, temp );
    }
    else
        glDisable(GL_TEXTURE_2D);

    for(int n=0 ; n<number_of_particles ; n++)
    {
        if(particles[n].isAlive()==true)
        {

            float x,y,z,s;
            x=particles[n].retPosition().x /** particles[n].retPosition().mag*/;
            y=particles[n].retPosition().y /** particles[n].retPosition().mag*/;
            z=particles[n].retPosition().z /** particles[n].retPosition().mag*/;
            s=particles[n].retSize()/2;
                      
            glPushMatrix();
            
            glTranslatef(x,y,z+1);            
            glRotatef(particles[n].retVel().retXAng()*RAD2DEG+90/*90*/,0,0,1);

                
            glBegin(GL_TRIANGLES);
            
                particles[n].setColour();

                /*glTexCoord2f(1,0);  glVertex3f(0,0,0);             
                glTexCoord2f(1,1);  glVertex3f(2,0,0);                
                glTexCoord2f(0,1);  glVertex3f(1,1,0);*/

                /*glTexCoord2f(1,0);  glVertex3f(2*s,-s,0);             
                glTexCoord2f(1,1);  glVertex3f(2*s,s,0);                
                glTexCoord2f(0,1);  glVertex3f(-2*s,s,0);
                
                glTexCoord2f(0,1);  glVertex3f(-2*s,s,0);                
                glTexCoord2f(0,0);  glVertex3f(-2*s,-s,0);                
                glTexCoord2f(1,0);  glVertex3f(2*s,-s,0);*/
                glTexCoord2f(1,0);  glVertex3f(s*atts.shape[0].x,s*atts.shape[0].y,s*atts.shape[0].z);             
                glTexCoord2f(1,1);  glVertex3f(s*atts.shape[1].x,s*atts.shape[1].y,s*atts.shape[1].z);               
                glTexCoord2f(0,1);  glVertex3f(s*atts.shape[2].x,s*atts.shape[2].y,s*atts.shape[2].z);
                
                glTexCoord2f(0,1);  glVertex3f(s*atts.shape[2].x,s*atts.shape[2].y,s*atts.shape[2].z);                
                glTexCoord2f(0,0);  glVertex3f(s*atts.shape[3].x,s*atts.shape[3].y,s*atts.shape[3].z);                
                glTexCoord2f(1,0);  glVertex3f(s*atts.shape[0].x,s*atts.shape[0].y,s*atts.shape[0].z);


                /*glTexCoord2f(1,0);  glVertex3f(s,-s*2,0);             
                glTexCoord2f(1,1);  glVertex3f(s,s*2,0);                
                glTexCoord2f(0,1);  glVertex3f(-s,s*2,0);
                
                glTexCoord2f(0,1);  glVertex3f(-s,s*2,0);                
                glTexCoord2f(0,0);  glVertex3f(-s,-s*2,0);                
                glTexCoord2f(1,0);  glVertex3f(s,-s*2,0);*/
            
            glEnd();
            
            glPopMatrix();
        }
    }
    
    glDisable(GL_BLEND);		// Turn Blending off
    glEnable(GL_LIGHTING);
    glDepthMask(true);
}

void SparksSystem::move(void)
{
    int partsLeftToCreate=0;
    if(running==true)
    {
        partsLeftToCreate = atts.density;
    }
    
    for(int n=0 ; n<number_of_particles ; n++)
    {
        //if there are more particles to create this cycle, and the current
        //particle is not alive, then re-create this one
        if(particles[n].isAlive()==false && partsLeftToCreate>0)
        {
            setupParticle(&particles[n]);
            partsLeftToCreate--;
        }
    
        //if the current particle is alive, move it and decrease its life
        if(particles[n].isAlive()==true)
        {
            particles[n].clearForces();
            particles[n].applyForce(atts.wind);
            //particles[n].applyForce(atts.direction);
            particles[n].energyDown();
            particles[n].move();
        }
    }
}



void SparksSystem::init(void)
{
    ParticleSystem::init();
}

// class constructor
SparksSystem::SparksSystem()
{
    init();
}

// class destructor
SparksSystem::~SparksSystem()
{
}

