/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef PARTICLESYSTEM_H
#define PARTICLESYSTEM_H

#include <list>

#include "particle.h"
#include "CVector2.h"
#include "CVector3.h"



#define BM_SMOKE    1
#define BM_FIRE     2


#define MAX_PARTICLES   2000

class ParticleSystem
{
protected:
    Particle particle[MAX_PARTICLES];
    int nParticles;

//    float vArray[MAX_PARTICLES*4*3];

    
    bool running;

    //private functions
    void init(void);
    
public:
    void killAllParticles(void);        //kills all of the particles in the system
    void clearForces(void);             //clears all of the forces on all of the particles
    void applyForce(CVector3 &force);   //applies a force to all of the living particles in the system
    void energyDown(void);              //decrease the energy of all particles in the system    
    
    virtual int create();
    virtual void destroy(void);
    
    virtual void draw(void);
    virtual void move(void);
    virtual void startSystem(void);

    void setupVArray(int n);
    
    Particle* retParticles(void) {return particle;}
    
    void addTextParticle(CVector3 pos, char *string);

    int retNParticles(void) {return nParticles;}
    void incNParticles(void) {if(nParticles<MAX_PARTICLES-1) nParticles++;}

    ParticleSystem();
    ~ParticleSystem();
};

#endif // PARTICLESYSTEM_H

