/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "particlesystem.h" // class's header file

extern FONT* allFonts[20];

int ParticleSystem::create()
{
    /*pos = _pos;
    direction = _direction;
    number_of_particles = _number_of_particles;
    particles = new Particle[number_of_particles];
    if(!particles)
    {
        return -1;  //error
    }
    for(int n=0 ; n<number_of_particles ; n++)
        particles[n].init();
    
    thruster = _thruster;*/
    
    return 0;
}

void ParticleSystem::destroy(void)
{
}

/*void ParticleSystem::setPosition(CVector3 _pos)
{ 
    pos = _pos;
}

void ParticleSystem::setDirection(CVector3 _direction) 
{ 
    direction=_direction;
}*/

void ParticleSystem::startSystem(void)
{
    running=true;
}

/*void ParticleSystem::pauseSystem(void)
{
    running=false;
}

void ParticleSystem::unpauseSystem(void)
{
    running=true;
}*/




/*void ParticleSystem::setTexture(char *filename)
{
    texture = loadTexture(filename);
}*/

void ParticleSystem::draw(void)
{
    PartAtts atts;
    int t=-1;
    


    //glVertexPointer(3,GL_FLOAT,0,vArray);
    //glTexCoordPointer(2,GL_FLOAT,0,meshArrays[n].tcArray);      
    //glDrawArrays(GL_QUADS,0,nParticles*4);

    //particles.sort();

    for(int n=0 ; n<nParticles ; n++)
    //for(pos = particles.begin(); pos != particles.end(); pos++)
    {
        glEnable(GL_BLEND);		// Turn Blending On
        glDepthMask(false);
        glDisable(GL_LIGHTING);
        glEnable(GL_TEXTURE_2D);
        
        if(particle[n].isAlive()==true)
        {
            float x,y,z,s;
            atts = particle[n].retAtts();
            
            //if(strlen(particle[n].getString())==0) //if it does not have a string

            
            if(atts.blendMode==BM_FIRE)
                glBlendFunc(GL_SRC_ALPHA,GL_ONE);
            else if(atts.blendMode==BM_SMOKE)
                glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);


            x=particle[n].retPosition().x;
            y=particle[n].retPosition().y;
            z=particle[n].retPosition().z;
            s=particle[n].retSize()/2;
                      
            //glPushMatrix();
            
            //glTranslatef(x,y,0);            
            //glRotatef(particle[n].retVel().retXAng()*RAD2DEG+90,0,0,1);

            //CVector2 pos(x,y);
            
            if(strlen(particle[n].getString())>0) //if it has a string
            {
                writeText_3D(x, y, z , makecol((int)(particle[n].retAtts().colour.r*255),
                                               (int)(particle[n].retAtts().colour.g*255),
                                               (int)(particle[n].retAtts().colour.b*255)) , 
                               allFonts[2],
                               particle[n].getString());
               t=-1;
            } 
            else
            {
                if(t!=atts.texture)
                {
                    t=atts.texture;
                    glBindTexture(GL_TEXTURE_2D,t);   
                }
                
                CVector2 s0,s1,s2,s3;
                float ang = 2*M_PI - particle[n].retVel().retXAng()+M_PI/2;
                
    
                s0 = makeVector2(atts.shape[0].x*s,atts.shape[0].y*s,true);
                s1 = makeVector2(atts.shape[1].x*s,atts.shape[1].y*s,true);
                s2 = makeVector2(atts.shape[2].x*s,atts.shape[2].y*s,true);
                s3 = makeVector2(atts.shape[3].x*s,atts.shape[3].y*s,true);
                
                s0=s0.rotate(ang);
                s1=s1.rotate(ang);  
                s2=s2.rotate(ang);
                s3=s3.rotate(ang);
                            
                            
                //glVertexPointer(3,GL_FLOAT,sizeof(Particle),&particle[0].pos.x);
                //glTexCoordPointer(2,GL_FLOAT,0,meshArrays[n].tcArray);
                
                //glDrawArrays(GL_TRIANGLES,0,meshes[n].iNumFaces*3);
                
                glBegin(GL_TRIANGLES);
                
                    particle[n].setColour();
    
                    glTexCoord2f(1,0);  glVertex3f(s0.retX()+x,s0.retY()+y,z);             
                    glTexCoord2f(1,1);  glVertex3f(s1.retX()+x,s1.retY()+y,z);               
                    glTexCoord2f(0,1);  glVertex3f(s2.retX()+x,s2.retY()+y,z);
                    
                    glTexCoord2f(0,1);  glVertex3f(s2.retX()+x,s2.retY()+y,z);                
                    glTexCoord2f(0,0);  glVertex3f(s3.retX()+x,s3.retY()+y,z);                
                    glTexCoord2f(1,0);  glVertex3f(s0.retX()+x,s0.retY()+y,z);
    
                glEnd();
            }       
            
            //glPopMatrix();
        }
    }
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_BLEND);		// Turn Blending off
    glEnable(GL_LIGHTING);
    glDepthMask(true);
}

void ParticleSystem::move(void)
{
    PartAtts atts;
    for(int n=0 ; n<nParticles ; n++)
    {
        //if there are more particles to create this cycle, and the current
        //particle is not alive, then re-create this one
    
        //if the current particle is alive, move it and decrease its life
        if(particle[n].isAlive()==true)
        {
            atts=particle[n].retAtts();
            particle[n].clearForces();
            particle[n].applyForce(atts.wind);
            particle[n].energyDown();
            particle[n].move();
            
            
            //setupVArray(n);
        }
    }
}

void ParticleSystem::setupVArray(int n)
{
    CVector2 s0,s1,s2,s3;
    float x,y,z,s;
    float ang;
    
    PartAtts atts=particle[n].retAtts();
    
    x=particle[n].retPosition().x;
    y=particle[n].retPosition().y;
    z=particle[n].retPosition().z;
    s=particle[n].retSize()/2;
    
    ang = 2*M_PI - particle[n].retVel().retXAng()+M_PI/2 /*M_PI/4*/;
        
    s0 = makeVector2(atts.shape[0].x*s,atts.shape[0].y*s,true);
    s1 = makeVector2(atts.shape[1].x*s,atts.shape[1].y*s,true);
    s2 = makeVector2(atts.shape[2].x*s,atts.shape[2].y*s,true);
    s3 = makeVector2(atts.shape[3].x*s,atts.shape[3].y*s,true);
    
    s0=s0.rotate(ang);
    s1=s1.rotate(ang);  
    s2=s2.rotate(ang);
    s3=s3.rotate(ang);
    
    /*vArray[n*4*3 + 0 + 0] = s0.retX()+x;
    vArray[n*4*3 + 0 + 1] = s0.retY()+y;
    vArray[n*4*3 + 0 + 2] = z;
    
    vArray[n*4*3 + 3 + 0] = s1.retX()+x;
    vArray[n*4*3 + 3 + 1] = s1.retY()+y;
    vArray[n*4*3 + 3 + 2] = z;

    vArray[n*4*3 + 6 + 0] = s2.retX()+x;
    vArray[n*4*3 + 6 + 1] = s2.retY()+y;
    vArray[n*4*3 + 6 + 2] = z;

    vArray[n*4*3 + 9 + 0] = s3.retX()+x;
    vArray[n*4*3 + 9 + 1] = s3.retY()+y;
    vArray[n*4*3 + 9 + 2] = z;*/
}

void ParticleSystem::energyDown(void)
{
    for(int n=0 ; n<nParticles ; n++)
    //for(pos = particles.begin(); pos != particles.end(); pos++)
    {
        if(particle[n].isAlive()==true)
        {
            particle[n].energyDown();
        }
    }
}

void ParticleSystem::clearForces(void)
{
    for(int n=0 ; n<nParticles ; n++)
    //for(pos = particles.begin(); pos != particles.end(); pos++)
    {
        if(particle[n].isAlive()==true)
        {
            particle[n].clearForces();
        }
    }
}

void ParticleSystem::applyForce(CVector3 &force)
{
    for(int n=0 ; n<nParticles ; n++)
    //for(pos = particles.begin(); pos != particles.end(); pos++)
    {
        if(particle[n].isAlive()==true)
            particle[n].applyForce(force);
    }
}

void ParticleSystem::killAllParticles(void)
{
    for(int n=0 ; n<nParticles ; n++)
        particle[n].kill();
    //running=false;
}

void ParticleSystem::addTextParticle(CVector3 pos, char *string)
{
    Particle *part = &particle[nParticles];
    incNParticles();
    
    CVector3 posr = makeVector3( pos.x,
                                 pos.y,
                                 pos.z ); 
    
    CVector3 particle_vel = makeVector3(0,-.1,0);
    float particle_size = 2;
    //particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
    //particle_vel = particle_vel.rotateAboutY( ((float)(rand()%100))/100 * 2*M_PI);
    
    float temp = ((float)(rand()%100))/100 * M_PI/12;
    if(temp<0)
        temp+=2*M_PI;
    else if(temp>2*M_PI)
        temp-=2*M_PI;
    particle_vel = particle_vel.rotateAboutZ(temp);
    
        //particle_vel = particle_vel * .1;
    

    PartAtts atts;
    atts.colour.r=1;
    atts.colour.g=0;
    atts.colour.b=0;  
    atts.particle_lifespan=40;
    atts.base_opacity=.8;
    atts.blendMode=BM_SMOKE;  
    atts.texture=-1;
    

    part->setup(posr,particle_vel,atts,atts.colour,atts.particle_lifespan,particle_size,atts.base_opacity);
    part->setString(string);
}

void ParticleSystem::init(void)
{
    running=false;
    nParticles=0;
}

// class constructor
ParticleSystem::ParticleSystem()
{
    init();
}

// class destructor
ParticleSystem::~ParticleSystem()
{
}




