/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef PARTICLEGENERATOR_H
#define PARTICLEGENERATOR_H

#include <list>

#include "Particle.h"
#include "ParticleSystem.h"
 
typedef struct
{
    bool thruster;  //whether or not the system is attached to a thruster
    bool collision; //whether or not the system is based on a collision
    bool respawn;   //whether or not the system is triggered by a respawn
    bool constant;
    bool shieldDie;
    bool onDeath;
    
    //-1 means no damageThreshold, otherwise it is the % health that the Ship
    //attached to the generator must be below for the generator to be on
    float damageThreshold;  
    
    float vel;  
}GenAtts; 
 
 
class ParticleGenerator
{
private:
    PartAtts pAtts;
    GenAtts gAtts;

    CVector3 pos;
    CVector3 direction;
    
    bool running;

    ParticleSystem* partSys;  //pointer to array of particles

public:
    void init(void);
    void create(PartAtts _pAtts, GenAtts _gAtts);
    
    void setupParticle(Particle *part);
    
    void setTexture(char *filename);
    void setParticles(ParticleSystem* ps){ partSys=ps;}

    
    
    void update(void);
    void start(void);
    void pause(void);

    void setPosition(CVector3 _pos) {pos=_pos;}
    void setDirection(CVector3 _direction) {direction = _direction;}

    void makeExplosion(void);
    void makeSparks(void);
    void makePartRing(void);
    
    void makeSmallExplosion(void);

    GenAtts retGenAtts(void) {return gAtts;}

	// class constructor
	ParticleGenerator();
	// class destructor
	~ParticleGenerator();
};

#endif // PARTICLEGENERATOR_H

