/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "particlegenerator.h" // class's header file

void init(void)
{

}

void ParticleGenerator::setTexture(char *filename)
{
    pAtts.texture = loadTexture(filename);
}

void ParticleGenerator::create(PartAtts _pAtts, GenAtts _gAtts)
{
    pAtts = _pAtts;
    gAtts = _gAtts;
    
    pos = makeVector3(0,0,0);
    direction = makeVector3(0,.2,0);
}


// class constructor
ParticleGenerator::ParticleGenerator()
{
	init();
}

// class destructor
ParticleGenerator::~ParticleGenerator()
{
	// insert your code here
}

void ParticleGenerator::init(void)
{
    partSys=0;
}

void ParticleGenerator::update(void)
{
    int partsLeftToCreate=0;
    if(running==true)
    {
        partsLeftToCreate = pAtts.density;
    
    /*for(int n=0 ; n<partsLeftToCreate && n<particles->retNParticles() ; n++)
    {
        //Particle p;
        if(particle
        setupParticle(particles->retParticles()[n]);
        //(*particles).push_back(p);
    }*/
    Particle *particles = partSys->retParticles();
    int n;
    //while(partsLeftToCreate>0)
    //{
    for(n=0 ; n<MAX_PARTICLES ; n++)
    {
        if(particles[n].isAlive()==false)
        {
            setupParticle(&particles[n]);
            partsLeftToCreate--;
            
            if(n>partSys->retNParticles())
                partSys->incNParticles();
        }
        if(partsLeftToCreate<=0)
            break;
    }
     //   if(n>=partSys->retNParticles()-1)
    //        break;
    //}
    }
}

void ParticleGenerator::start(void)
{
    running=true;
}

void ParticleGenerator::pause(void)
{
    running=false;
}

void ParticleGenerator::setupParticle(Particle *part)
{
    CVector3 particle_pos = pos;
    CVector3 posr = makeVector3( pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius,
                                 pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius,
                                 pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius ); 
    
    CVector3 particle_vel = direction;
    float particle_size = pAtts.particle_size * ((float)(rand()%50)+50)/100 * 1.5;
    //particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
    //particle_vel = particle_vel.rotateAboutY( ((float)(rand()%100))/100 * 2*M_PI);
    
    float temp = ((float)(rand()%100))/100 * pAtts.sprayArc - pAtts.sprayArc/2;
    if(temp<0)
        temp+=2*M_PI;
    else if(temp>2*M_PI)
        temp-=2*M_PI;
    particle_vel = particle_vel.rotateAboutZ(temp);
    
    if(gAtts.constant==true)
        particle_vel = particle_vel*gAtts.vel;
    
    
    particle_pos += posr;
    part->setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,pAtts.base_opacity);

}

/*void newParticleCVector3 _pos, CVector3 _vel, PartAtts _atts, Colour _colour, int _energy, float _size, float _base_opacity)
{
    

}*/    


void ParticleGenerator::makeExplosion(void)
{
    CVector3 particle_pos;
    CVector3 posr;     
    CVector3 particle_vel;
    int n;
    float velRand;
    float particle_size;
    
    Particle *particles = partSys->retParticles();
    int partsLeftToCreate;
    
    pAtts.radius=2;

    partsLeftToCreate=20;
    for(n=0 ; n<MAX_PARTICLES ; n++)
    {
        particle_pos = pos;
        velRand = (float)(rand()%100);
        particle_vel = makeVector3(.2-(velRand/500),0,0);
    
        posr= makeVector3( pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius,
                                 pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius,
                                 pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius ); 
    
        pAtts.particle_size=6;
        pAtts.particle_lifespan=100 - (int)(velRand/4);
        pAtts.colour=makeColour(1-(rand()%100)/500 , .7-(rand()%100)/500 , 0 );
    
        particle_size = pAtts.particle_size * ((float)(rand()%50)+50)/100 * 1.5;
        //particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        
        particle_vel = particle_vel.rotateAboutZ( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutY( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        

        particle_pos += posr;
        
        if(particles[n].isAlive()==false)
        {
            particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,/*pAtts.base_opacity*/.5);
            if(n>partSys->retNParticles())
                partSys->incNParticles();
            partsLeftToCreate--;
        }
        if(partsLeftToCreate<=0)
            break;
    }
    
    
    partsLeftToCreate=35;
    for(n=0 ; n<MAX_PARTICLES ; n++)
    {
        particle_pos = pos;
        velRand = (float)(rand()%100);
        particle_vel = makeVector3(1.2-(velRand/500),0,0);

        posr= makeVector3( pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius,
                                 pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius,
                                 pAtts.radius * 2 * ((float)(rand()%100))/100 - pAtts.radius ); 


        pAtts.particle_size=3;
        pAtts.particle_lifespan=100 - (int)(velRand/4);
        pAtts.colour=makeColour(.8-(rand()%100)/500 , .4-(rand()%100)/500 , 0 );
    
        particle_size = ((float)(rand()%100))/50 + pAtts.particle_size;
        //particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        
        particle_vel = particle_vel.rotateAboutZ( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutY( ((float)(rand()%100))/100 * 2*M_PI);
        particle_vel = particle_vel.rotateAboutX( ((float)(rand()%100))/100 * 2*M_PI);
        //

        particle_pos += posr;
        
        //particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,/*pAtts.base_opacity*/.6);
        if(particles[n].isAlive()==false)
        {
            particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,/*pAtts.base_opacity*/.6);
            if(n>partSys->retNParticles())
                partSys->incNParticles();
            
            partsLeftToCreate--;
        }
        if(partsLeftToCreate<=0)
            break;
    
    }
    
    float ang=0;
    float degStep=0.1047;  //60 particles, 360 degrees in circle
    float r=2;
    CVector3 temp;
    float ang2=(float)(rand()%100)/100 * M_PI;
    
    partsLeftToCreate=60;
    for(n=0 ; n<MAX_PARTICLES ; n++)
    {
        float px=r*cos(ang),
            py=0,
            pz=r*sin(ang);
         
         pAtts.colour=makeColour(1-(rand()%100)/500 , 0 ,.4-(rand()%100)/500 );
        /*float px=pos.x;
        float py=pos.y;
        float pz=pos.z;*/
           
           temp = makeVector3(px,py,pz);
           temp = temp.rotateAboutX(ang2);
           particle_pos = makeVector3(pos.x+temp.x,pos.y+temp.y,pos.z+temp.z);
           
        //article_pos = makeVector3(px,py,pz);
        

        particle_vel = makeVector3(particle_pos.x-pos.x,particle_pos.y-pos.y,particle_pos.z-pos.z);
        particle_vel=particle_vel/(1.3 - ((float)(rand()%100))/1000 );
        //particle_vel = particle_vel.rotateAboutX(  M_PI/4 );
                
                
        
        pAtts.particle_lifespan=150;
        
        pAtts.particle_size=4;
        particle_size = pAtts.particle_size * ((float)(rand()%50)+50)/100 * 1.5;
        

        
        //particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,pAtts.base_opacity);
        if(particles[n].isAlive()==false)
        {
            particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,pAtts.base_opacity);
            if(n>partSys->retNParticles())
                partSys->incNParticles();            
            
            ang+=degStep;
            partsLeftToCreate--;
        }
        if(partsLeftToCreate<=0)
            break;
    }
}

void ParticleGenerator::makeSparks(void)
{
    //pos.setVector(0,0,0);
    //makeExplosion();
    int partsLeftToCreate;
    
    partsLeftToCreate=pAtts.start_density;
    Particle *particles = partSys->retParticles();
    for(int n=0 ; n<MAX_PARTICLES ; n++)
    {
        if(particles[n].isAlive()==false)
        {
            //particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,pAtts.base_opacity);
            setupParticle(&particles[n]);

            if(n>partSys->retNParticles())
                partSys->incNParticles();   
            partsLeftToCreate--;
        }
        if(partsLeftToCreate<=0)
            break;
    }
}

void ParticleGenerator::makePartRing(void)
{
    float ang=0;
    float degStep=/*0.1047*/2*M_PI/(float)pAtts.start_density;  //60 particles, 360 degrees in circle
    float r=2;
    CVector3 temp;
    float ang2=(float)(rand()%100)/100 * M_PI;
    
    CVector3 particle_pos;
    CVector3 posr;     
    CVector3 particle_vel;
    int n;
    float velRand;
    float particle_size;
    
    Particle *particles = partSys->retParticles();
    int partsLeftToCreate;
    
    partsLeftToCreate=pAtts.start_density;
    for(n=0 ; n<MAX_PARTICLES ; n++)
    {
        float px=r*cos(ang),
            py=0,
            pz=r*sin(ang);
         
         //pAtts.colour=makeColour(0, 1-(rand()%100)/500  ,.8-(rand()%100)/500 );
        /*float px=pos.x;
        float py=pos.y;
        float pz=pos.z;*/
           
           temp = makeVector3(px,py,pz);
           temp = temp.rotateAboutX(M_PI/4);
           particle_pos = makeVector3(pos.x+temp.x,pos.y+temp.y,pos.z+temp.z);
           
        //article_pos = makeVector3(px,py,pz);
        

        particle_vel = makeVector3(particle_pos.x-pos.x,particle_pos.y-pos.y,particle_pos.z-pos.z);
        particle_vel=particle_vel/4;
        //particle_vel = particle_vel.rotateAboutX(  M_PI/4 );
                
        particle_size = pAtts.particle_size * ((float)(rand()%50)+50)/100 * 1.5;
        
        
        //particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,pAtts.base_opacity);
        if(particles[n].isAlive()==false)
        {
            particles[n].setup(particle_pos,particle_vel,pAtts,pAtts.colour,pAtts.particle_lifespan,particle_size,pAtts.base_opacity);
            if(n>partSys->retNParticles())
                partSys->incNParticles();            
            
            ang+=degStep;
            partsLeftToCreate--;
        }
        if(partsLeftToCreate<=0)
            break;
    }
}

void ParticleGenerator::makeSmallExplosion(void)
{
    
}

