/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef PARTICLE_H
#define PARTICLE_H

#include "CVector3.h"

#define     PART_POINT  0
#define     PART_BLOB   1
#define     PART_LINE   2

typedef struct
{
    float r,g,b;
}Colour;
Colour makeColour(float r, float g, float b);

typedef struct
{
    CVector3 wind;
    Colour colour;
    float radius;       //inital radius of the system
    int start_density;   //number of particles to start the system with
    int density;    //density of the smoke (ie particles generated per cycle
    int particle_lifespan;
    float particle_size;
    
    CVector3 shape[4];
    
    float base_opacity;
    
    int blendMode;  
    float sprayArc;     //the spray arc for the parts in radians
    
    int texture;
}PartAtts;


class Particle
{
private:
    //variables used by all particle types
    CVector3 pos,vel,accel;
    CVector3 old_pos;
    Colour colour;
    int energy;         //0 means it is not alive
    int max_energy;
            
    //variables used by blob particles
    float size;
    
    float base_opacity;
    
    //variables used by line particles
    Particle *sister;
    
    PartAtts atts;
    
    char string[5];

public:
    Particle();
    ~Particle();
    void init(void);
    
    bool isAlive(void);
    void energyDown(void);
    void setup(CVector3 _pos, CVector3 _vel, PartAtts _atts, Colour _colour, int _energy, float _size, float _base_opacity);
    void setString(char *s);
    void clearForces(void) { accel.zero(); }
    void applyForce(CVector3 &force);   //sets acceleration
    void kill(void) {energy=0;}
    void setColour(void);
    
    CVector3 retPosition(void) {return pos;}
    CVector3 retVel(void) {return vel;}
    PartAtts retAtts(void) {return atts;}
    float retSize(void) {return size;}
    char* getString(void) {return string;}
    
    friend bool operator < (const Particle & lhs, const Particle & rhs);
    
    int move(void);
};




#endif // PARTICLE_H

