/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "particle.h" // class's header file

void Particle::init(void)
{
    //variables used by all particle types
    pos.zero();
    vel.zero();
    accel.zero();
    colour = makeColour(1,1,1);
    energy=0;
    
    //variables used by blob particles
    size=0;
    
    //variables used by line particles
    sister=NULL;
    
}

bool Particle::isAlive(void)
{
    if(energy>0)
        return true;
    else
        return false;
}

bool operator <  (const Particle & lhs, const Particle & rhs)
{
    if(lhs.atts.texture<rhs.atts.texture)
        return true;
    else
        return false;
}

void Particle::setColour(void)
{
    if(energy>0)
    {
        if(pos.z>5)
        {
           //energy--;
        }
        
        glColor4f(colour.r,colour.g,colour.b,( (float)energy/(float)max_energy ) * base_opacity /*+ pos.z/300*/);
    
        /*float c[4] = {colour.r,colour.g,colour.b,( (float)energy/(float)max_energy ) * base_opacity};
        glMaterialfv( GL_FRONT, GL_DIFFUSE, c );
        glMaterialfv( GL_FRONT, GL_AMBIENT, c );
        glMaterialfv( GL_FRONT, GL_SPECULAR, c );
        glMaterialfv( GL_FRONT, GL_EMISSION, c );*/
    }
}

void Particle::setString(char *s)
{
    strncpy(string,s,5);   
}    

void Particle::setup(CVector3 _pos, CVector3 _vel, PartAtts _atts, Colour _colour, int _energy, float _size, float _base_opacity)
{
    init();
    pos = _pos;
    vel = _vel;
    atts=_atts;
    colour = _colour;
    energy = _energy;
    max_energy = _energy;
    size = _size;
    base_opacity = _base_opacity;
    strcpy(string,"");
}

int Particle::move(void)
{
    if(energy>0)    //only move it if it is alive
    {
        vel+=accel;
        pos+=vel;
    
    }
}

void Particle::energyDown(void)
{ 
    if(energy>0) 
        energy--; 
}

void Particle::applyForce(CVector3 &force)
{
    accel += force;
}

// class constructor
Particle::Particle()
{
    init();
}

// class destructor
Particle::~Particle()
{
}


Colour makeColour(float r, float g, float b)
{
    Colour ret = {r,g,b};
    return ret;
}

