/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
//#include <winalleg.h>
#include <alleggl.h>
//include datafile header
#include "Standards.h"
#include "aldumb.h"

//#include "CNetwork.h"
//#include "CPacket.h"

#include "CVector2.h"
#include "CVector3.h"
#include "CCamera.h"

#include "Particle.h"
#include "ParticleSystem.h"
//#include "SmokeSystem.h"
//#include "SparkSystem.h"
#include "ParticleGenerator.h"

#include "Controller.h"
#include "SfxSingleton.h"
#include "ScoreKeeper.h"

#include "Starfield.h"
#include "BRect.h"
#include "Widget.h"
#include "Model.h"
#include "Weapon.h"
#include "Animation.h"
#include "SObject.h"
#include "Arena.h"
#include "PObject.h"
#include "Asteroid.h"
#include "Ship.h"
#include "ShipArray.h"
#include "Proj.h"
#include "Powerup.h"
#include "Part.h"

#include "Player.h"
#include "AIPlayer.h"
#include "Turret.h"

//#include "Menu.h"
#include "Widget.h"
#include "Button.h"
#include "CheckBox.h"
#include "ShipSelector.h"
#include "NewMenu.h"

#include "Game.h"

#include "GameMode.h"
#include "AsteroidsGameMode.h"
#include "MissileAvoid.h"
#include "MissileAvoid2p.h"
#include "AsteroidsGameMode2p.h"

//#include "Server.h"
//#include "Client.h"
#include <vector>

using namespace std;

#define DEPTH      16
#define S_W        640
#define S_H        480
#define TARGET_FPS 30


#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define Rad2AllegroDeg  40.74366543153
#define MAX_MODELS  30

void allegro_startup(void);
void move_all(void);
void draw_all(void);
//void calc_fps(void);
void reset_game(void);
void init_game(void);   //only to be called once at the start
int initAllegroGL(void);
void end_game(void);    //only to be called once at the end (frees memory etc)
void load_ship_atts(TShipAtts *atts);
//void setup_network(void);
void lobby(void);
void login(void);
void chooseShip(void);
void startGame(int gameMode, NewMenu *menu);
void getKeys(void);

void connect(void);
void createShip(Ship *s, int n);
void runMenu(void);
void drawMenu(void);
void initMenus(void);
void loadShipDefs(char *filename);
void skipMenu(void);

void loadModels(char *sModels);
void initParticleSystems(Game *g);

void displaySplashScreen(void);

void startAsteroidsGame(int level);

volatile int sec=0;
int iGraphicsLoops=0;
int iLogicLoops=0;
bool bQuitGame=false;

int cycles=0;
float fps;

void go_sec(void);
void go_sec()
	{
    sec++;
	}
END_OF_FUNCTION(go_sec);

DATAFILE *data,*fonts;

CCamera camera;
FONT *agl_font;
//CVector2 pos1(0,0,true), vel1(0,0,false), accel1(0,0,false); 
//CNetworkConnection connection;
//Client client;
//Server server;
int host=-1;


Starfield starfield;
float fStarfieldSpeed=1;
bool bStarfieldSpeedup=false;
float fNextMenuZoom=0;
int iShakeCount=0;


bool in_choose_ship=true;
bool in_login=false;
bool in_lobby=false;

int iMenuNum=1; //-1 for asteroids

NewMenu menu;


TShipAtts ship_atts[MAX_SHIP_ATTS];
vector<TWeaponsSet> weapons_set;

char name[30];

GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };     //creates the ambient light
GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };     //creates a bright diffuse light
GLfloat LightSpecular[] = {1.0f, 1.0f, 1.0f, 1.0f};

GLfloat LightPosition[]= { 0.0f, 0.0f, 2.0f, 1.0f };    //location of the light (3 params same as translate)


ShipArray shipDefs;
Model allModels[MAX_MODELS];
int iNumModels=0;

Game game;

int iIsHost=-1;
TPlayerAtts player1Atts,player2Atts;
bool bHotSeat=true;   
int iPlayer1Num=-1, iPlayer2Num=-1;   //the numbers in the player array for each player (-1 means not playing)

int iSecArray[20];
int iSecArraySize=0;
float averageSecPerCycle=0;


FONT* allFonts[20];
int iNumFonts=0;


BRect pict;

BRect title;
float titleAlpha=.5, targetTitleAlpha=1;

//SmokeSystem smokeSys[MAX_PLAYERS];
//ParticleSystem partSys[MAX_PS];
/*SmokeSystem smokeSys[MAX_SS];
SparksSystem sparksSys[MAX_SPS];*/
ParticleSystem partSys;
ParticleGenerator   *partGen;

int nSmokeSys=0,nSparksSys=0,nPartGen=0;

int oldFrameCounter=0,frameCounter=0;




int frameInterval=0;
int oldTime=0, currentTime=0;
int lastFPSCalcTime=0;
int timeOfLastUpdate=0;

vector<GameMode*> gameModeList;


/*************FOR THE MUSIC PLAYING*************/
void play_song(char *filename);
void stop_song(void);
void update_music_state(void);
void update_music_volume(void);

DUH *current_song;
AL_DUH_PLAYER *mod_player;

float current_volume=.7f;
float target_volume=.7f;
char next_song[200]="none";
bool song_on=false;
bool fading_out=false;
int cur_song_num=rand()%3;
/**********************************************/


int main(int argc, const char **argv) 
{    
    remove(LOGFILE);     
    
    initAllegroGL();    
    
    /**MAKE SURE WE ARE IN THE SAME DIR AS THE EXE**/
    char buffer[256];
    int len=255;
    get_executable_name(buffer, len); 
    (get_filename(buffer))[0] = 0;
    outtext(LOGFILE,buffer);
    chdir(buffer);




   
 //      camera.setPosition(makeVector3(0,0,-40));
   displaySplashScreen();

   
    init_game();
    reset_game();

   
   // setup_network();
   
    sec=0; cycles=0;
    
    if(iMenuNum==-1)
        skipMenu();
    
    
//    LARGE_INTEGER time1,time2;
//    QueryPerformanceCounter(&time1);
    play_song("music/BlackIce1.XM");
    
    while(/*! key[KEY_ESC] &&*/ !bQuitGame)
    {

        update_music_state();
        al_poll_duh(mod_player);
        if(iMenuNum!=-1)
        {

            if(/*iLogicLoops / ((float)sec/1000) >= TARGET_FPS*/1==1)
            {
                
                iGraphicsLoops++;
                
                allegro_gl_begin(); 
                
                    glMatrixMode (GL_PROJECTION);
                    glLoadIdentity ();
                    gluPerspective(45.0f,(GLfloat)800/(GLfloat)600, 1.5f, 4000.0f);
                    glMatrixMode (GL_MODELVIEW);
                    glLoadIdentity();
                    
                    
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
                    
                    starfield.draw();
                
                    glPushMatrix();    
                        glTranslatef(0,0,-40);
                        
                        drawMenu();
                    
                        char temp[50];
                        sprintf(temp,"logic:%f  FPS:%f",iLogicLoops / ((float)sec/1000)  ,  iGraphicsLoops / ((float)sec/1000));
                        //writeText(10,14,0,makecol(255,0,0),allFonts[1],temp);
                
                    glPopMatrix();
                
                    glFlush();
                    allegro_gl_flip();   
                allegro_gl_end();
            }
            
            if(/*iLogicLoops / ((float)sec/1000) < TARGET_FPS*/(currentTime - timeOfLastUpdate) >= 30)
            {
                update_music_volume();
                timeOfLastUpdate=currentTime;
                iLogicLoops++;
                starfield.update(fStarfieldSpeed);
                runMenu();
            }
            currentTime = sec;   
            
        }
        /*else if(in_choose_ship==true)
        {
            chooseShip();
        }
        else if(in_login==true)
        {
            login();
        }
        else if(in_lobby==true)
        {
            lobby();
        }*/
        else
        {

/*
            if(iSecArraySize<20)
            {
                iSecArray[iSecArraySize]=sec;
                iSecArraySize++;
            }
            else
            {
                for(int n=0 ; n<18 ; n++)
                {
                    iSecArray[n] = iSecArray[n+1];
                    //averageSecPerCycle+=iSecArray[n];
                }
                iSecArray[19]=sec;
                
                //averageSecPerCycle/=19;
            }
            
            
            averageSecPerCycle=0;
            for(int n=0 ; n<iSecArraySize ; n++)
            {
                averageSecPerCycle+=(float)iSecArray[n];
            }
            averageSecPerCycle -= iSecArray[0]*iSecArraySize;
            if(iSecArraySize>0)
                averageSecPerCycle/=iSecArraySize;
*/
            
            
            //while(iLogicLoops / ((float)sec/1000) >= TARGET_FPS)
            {
                iGraphicsLoops++;
                allegro_gl_begin();    
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
                    camera.applyCamera();
                        draw_all();
                    glFlush();
                    allegro_gl_flip();   
                allegro_gl_end();
            }
            
            //if(iLogicLoops / ((float)sec/1000) < TARGET_FPS)
            
            if((currentTime - timeOfLastUpdate) >= 30)
            {
                update_music_volume();
                camera.moveCamera();
                move_all();
                timeOfLastUpdate=currentTime;
            }
            currentTime = sec;
            frameInterval = currentTime - oldTime;
            oldTime = currentTime; 
            frameCounter++;

            if(/*(sec%1000)<10*/currentTime - lastFPSCalcTime >= 1000) 
            {
                lastFPSCalcTime = currentTime;
                oldFrameCounter = frameCounter;
                frameCounter=0;
            }
            
            if(key[KEY_ESC] || (game.retGameEnded()==true && key[KEY_ENTER]) )
            {
                //server.closeServer();   //close the network connections
                //client.close();
                reset_game();
                //initMenus();
                iMenuNum=0;
                menu.reset();
                play_song("music/BlackIce1.XM");
                outtext(LOGFILE,"RETURNING TO MENU\n");
            }    
        }
        rest(0);
    }
    end_game();
    outtext(LOGFILE,"\nDONE\n");
    return 0;
}     
END_OF_MAIN();



void move_all(void)
{
    static float zpos=-85;
    
    
  //  if(fps <= target_fps)
    {
        //cycles++;     
        iLogicLoops++;


        //if(iIsHost==1)
        game.update();      
            
 
        //client.getKeys();
        getKeys();


                
        
        /*static bool pressed=false;
        if(key[KEY_E] && pressed==false)
        {
            partGen[nPartGen-1].makeExplosion();
//            sparksSys[2].makeExplosion();
            pressed=true;
        }
        if(!key[KEY_E])
            pressed=false;*/
        
//        sparksSys[2].move();
        
        partSys.move();
        
        //client.update();
/*            
        CVector2 pos,accel,vel;
        CVector3 p,d;
        
        for(int n=0 ; n<game.retNumPlayers() ; n++)
        {
            pos=((game.retPlayer(n))->retShip())->retPos();
            accel=((game.retPlayer(n))->retShip())->retAccel();
            vel=((game.retPlayer(n))->retShip())->retVel();
        
            //CVector3 d;
            p.setVector(pos.retX(),pos.retY(),0);
            d.setVector(-accel.retX()/2,accel.retY()/2,0);  
        
            //ss.setDensity((int)( vel.retMag()*10 ));
            smokeSys[n].setPosition(p);  
            smokeSys[n].setDirection(d);
            
            if(accel.retMag()==0)
                smokeSys[n].pauseSystem();
            else
                smokeSys[n].unpauseSystem();
                
            smokeSys[n].move();
        }
*/                

              
              
              
        starfield.update(fStarfieldSpeed);
        
/*
        if(key[KEY_X])
            zpos+=.5;
        else if(key[KEY_C])
            zpos-=.5;    
 */           
        camera.setPosition(makeVector3(0,0,zpos));
    }       
}

void draw_all(void)
{    
    float secs_passed = (float)sec/1000;
    float frames_drawn = cycles;
    
    //client.drawAllPlayers();

    
//    sparksSys[2].draw();

  
        starfield.draw();
        partSys.draw(); 
        game.draw();


		char buf[60];
		sprintf(buf,"logic:%f  FPS:%f",iLogicLoops / ((float)sec/1000)  ,  /*iGraphicsLoops / ((float)sec/1000)*/(float)oldFrameCounter);
//		writeText_3D(10,16,40,makecol(255,255,255),allFonts[1],buf);
              
        
        CVector2 pos=((game.retPlayer(0))->retShip())->retPos();
        CVector2 vel=((game.retPlayer(0))->retShip())->retVel();
        
        (vel.retX()*vel.retX() + vel.retY()*vel.retY());

        sprintf(buf,"%f %f %f   %d",pos.retX(),pos.retY(),(vel.retMag())*10,partSys.retNParticles() );
        //writeText(0,0,40,makecol(255,255,255),allFonts[1],buf);               

        
    
    fps = frames_drawn / secs_passed;
}

/*
void calc_fps(void)
{
    float actual_seconds = (float)sec2/1000;

    fps = (float)cycles2 / actual_seconds;
    
    if(cycles2%300 == 0)
    {
        cycles2=0;
        sec2=0;
    }
    
}*/

void reset_game(void)
{
    outtext(LOGFILE,"\nEntering function reset_game\n");
    //reset the camera to the correct position
    outtext(LOGFILE,"Setting up camera\n");
    camera.init();
    camera.setPosition(makeVector3(0,0,-30));
    
    game.reset();           //reset the game
    iMenuNum=1;
    iIsHost=-1;
    
    iPlayer1Num=-1;
    iPlayer2Num=-1;
    /*server.init();          //re-init the client and server
    client.init();
    client.setGame(&game);
    server.setGame(&game);*/

}

void init_game(void)
{
    char temp[100];
    
    outtext(LOGFILE,"\nINIT GAME\n");
    
    outtext(LOGFILE,"Loading DUMB\n\n");
    atexit(&dumb_exit);
    dumb_register_stdfiles();
    
    outtext(LOGFILE,"Loading title image\n\n");
    title.setPict(800,600,"images/title.bmp",false);
    
    load_ship_atts(ship_atts);
    shipDefs.init();
    loadModels("models.d3");

    outtext(LOGFILE,"Models Loaded\n\n");

    TShipDef def;
    
    outtext(LOGFILE,"Loading fonts\n");
    fonts = load_datafile("fonts.dat");
    if(fonts)
        outtext(LOGFILE,"Fonts Loaded\n\n");
    else
        outtext(LOGFILE,"Error loading fonts\n\n");
    
    int n;
    
    outtext(LOGFILE,"Creating fonts\n");
    allegro_gl_set_texture_format (GL_ALPHA8);
    for(n=0 ; fonts[n].type != DAT_END ; n++)
    {
        char buf[25];
        sprintf(buf,"  creating font: %d\n",n);
        outtext(LOGFILE,buf);
        if(!fonts[n].dat)
            break;
        allFonts[n] = allegro_gl_convert_allegro_font((FONT*)fonts[n].dat, AGL_FONT_TYPE_TEXTURED, 16.0/*,GL_ALPHA8*/);  
    }    
    int iNumFonts=n;
    allegro_gl_set_texture_format(GL_RGBA8);
    outtext(LOGFILE,"Fonts created\n\n");

    partGen = new ParticleGenerator[MAX_PG];

    loadShipDefs("Ships.d3");

    game.init();
    player1Atts.iColour=0;
    player1Atts.iShipNum=0;
    strcpy(player1Atts.sName,"Player1");
    
    player2Atts.iColour=0;
    player2Atts.iShipNum=0;
    strcpy(player2Atts.sName,"Player2");
    
    outtext(LOGFILE,"Loading sounds\n\n");
    SfxSingleton::instance()->setData("sounds.dat");
    
    
    

    game.setModels(allModels);

    game.setupWeapons("weapons.d3",&partGen);
    game.setupPowerupTypes(&partGen);
    
    
    //    server.init();
    //client.init();

    //outtext(LOGFILE,"\nRESET_GAME\n");
    outtext(LOGFILE,"\nAdding Game Modes\n");
    
    gameModeList.push_back(new GameMode(&menu));
    outtext(LOGFILE,"  adding asteroids\n");
    gameModeList.push_back(new AsteroidsGameMode(&menu));
    outtext(LOGFILE,"  adding missile avoid\n");
    gameModeList.push_back(new MissileAvoid(&menu));
    outtext(LOGFILE,"  adding 2p missile avoid\n");
    gameModeList.push_back(new MissileAvoid2p(&menu));
    outtext(LOGFILE,"  adding 2p asteroids\n");
    gameModeList.push_back(new AsteroidsGameMode2p(&menu));
       
    outtext(LOGFILE,"\nInit Menus\n"); 
    initMenus();
    
    //client.setGame(&game);
    //server.setGame(&game);
}

void loadShipDefs(char *filename)
{
    /*def.fCircRadius=1.8;
    strcpy(def.sModelFilename,"Ship1.ms3d");
    def.atts = ship_atts[1];
    shipDefs.addShipDef(def);*/
    outtext(LOGFILE,"\nLoading Ship defs\n");
    
    FILE *fp;
    fp = fopen(filename,"rt");
    int iFilePos=0;
    int iFileLength=0;    

    //gets the length of the file
    while(!feof(fp))
    {
        fgetc(fp);
        iFileLength++;
    }
    rewind(fp); //and then goes back to the start
    
    //read the file into the char array file
    char* file = (char*)malloc(iFileLength+1);
    for(int n=0 ; n<iFileLength ; n++)
        file[n] = fgetc(fp);
    
    fclose(fp);
    outtext(LOGFILE,"  Ship defs file loaded\n");
    
    int n=0;
    while(n<iFileLength)
    {    

        TShipDef def;
        char sTemp[50]=""; int iLength=0;

        //read in the ship's model number
        int modelNum=0;
        sscanf(&file[n],"%d",&modelNum);
        def.iModelNum=modelNum;
        for(; file[n]!='|' ; n++); n++;
        
        
        //read in the ship name
        iLength=0;
        for(; file[n]!='|' ; n++)
        {
            sTemp[iLength] = file[n];
            iLength++;
        }
        sTemp[iLength]=0; n++;
        strcpy(def.sShipName,sTemp);
        
        //read in the ship's radius
        sscanf(&file[n],"%f",&def.fCircRadius);
        for(; file[n]!='|' ; n++); n++;
        
        //read in the pilot's filename
        iLength=0;
        for(; file[n]!='|' ; n++)
        {
            sTemp[iLength] = file[n];
            iLength++;
        }
        sTemp[iLength]=0; n++;
        strcpy(def.sPilotFilename,sTemp);
        
        //read in the ship's atts number
        int attsNum=0;
        sscanf(&file[n],"%d",&attsNum);
        def.atts = ship_atts[attsNum];
        for(; file[n]!='|' ; n++); n++;
        
        
        //read in the pilot's nation
        iLength=0;
        for(; file[n]!='|' ; n++)
        {
            sTemp[iLength] = file[n];
            iLength++;
        }
        sTemp[iLength]=0; n++;
        strcpy(def.sPilotNation,sTemp);
    
    
        //read in the pilot's rank
        iLength=0;
        for(; file[n]!='|' ; n++)
        {
            sTemp[iLength] = file[n];
            iLength++;
        }
        sTemp[iLength]=0; n++;
        strcpy(def.sPilotRank,sTemp);
        
        //read in the pilot's name
        iLength=0;
        for(; file[n]!='|' ; n++)
        {
            sTemp[iLength] = file[n];
            iLength++;
        }
        sTemp[iLength]=0; n++;
        strcpy(def.sPilotName,sTemp);
        
        
        //def.atts = ship_atts[1];
        shipDefs.addShipDef(def);
        
        n++;
    }
    
    free(file);
    
    outtext(LOGFILE,"\n");
}


int initAllegroGL(void)
{
    outtext(LOGFILE,"INIT ALLEGROGL\n");
    allegro_init();
	install_allegro_gl();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

    outtext(LOGFILE,"Setting up window\n");
    allegro_gl_clear_settings();
	allegro_gl_set (AGL_COLOR_DEPTH, 32);
	allegro_gl_set (AGL_Z_DEPTH, 16);
	allegro_gl_set (AGL_FULLSCREEN, TRUE);
	allegro_gl_set (AGL_DOUBLEBUFFER, 1);
	allegro_gl_set (AGL_RENDERMETHOD, 1);
	allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH | AGL_DOUBLEBUFFER
			| AGL_FULLSCREEN | AGL_RENDERMETHOD);
    request_refresh_rate(60);

    outtext(LOGFILE,"Setting gfx mode\n");
	set_color_depth (32);
	if (set_gfx_mode(GFX_OPENGL_FULLSCREEN/*WINDOWED*//*FULLSCREEN*/, 800, 600, 0, 0) < 0) {
        outtext(LOGFILE,"!!Error setting gfx mode!!\n");
		allegro_message ("Error setting graphics mode:\n%s\n", allegro_error);
		return -1;
	}

    outtext(LOGFILE,"Installing keyboard and mouse\n");
	install_keyboard();
	install_mouse();

    allegro_gl_use_mipmapping(TRUE);
    allegro_gl_set_texture_format(GL_RGBA8);
    
    
    outtext(LOGFILE,"Converting font\n");
    //allegro_gl_set_texture_format (GL_ALPHA8);
	agl_font = allegro_gl_convert_allegro_font(font, AGL_FONT_TYPE_TEXTURED, 16.0);


    
    
    outtext(LOGFILE,"Configuring opengl settings\n");
    allegro_gl_begin();
/*        
        glClearColor (0, 0, 0, 0);
    	glClearDepth(1.0f);	
        //glShadeModel (GL_FLAT);
        glShadeModel(GL_SMOOTH);
        glPolygonMode (GL_FRONT_AND_BACK,GL_FILL);
      
    //	  
        glEnable (GL_DEPTH_TEST);
        glDepthFunc(GL_LEQUAL);	
    	
     //   glEnable(GL_BLEND);
        

        //glCullFace (GL_BACK);
        //glEnable (GL_CULL_FACE);
*/

	glEnable(GL_TEXTURE_2D);										// Enable Texture Mapping ( NEW )
	glShadeModel(GL_SMOOTH);										// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);							// Black Background
	glClearDepth(1.0f);												// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);										// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);											// The Type Of Depth Testing To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);				// Really Nice Perspective Calculations

    glCullFace (GL_BACK);
    glEnable (GL_CULL_FACE);

    glLightfv(GL_LIGHT1, GL_AMBIENT, LightAmbient);				// Setup The Ambient Light
    glLightfv(GL_LIGHT1, GL_DIFFUSE, LightDiffuse);				// Setup The Diffuse Light
    glLightfv(GL_LIGHT1, GL_SPECULAR, LightSpecular);
    glLightfv(GL_LIGHT1, GL_POSITION,LightPosition);			// Position The Light
    glEnable(GL_LIGHT1);							// Enable Light One
    
    glEnable(GL_LIGHTING);

	glHint(GL_FOG_HINT, GL_DONT_CARE);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);

	glShadeModel(GL_SMOOTH);
	glPolygonMode(GL_FRONT, GL_FILL);
    //glEnable(GL_COLOR_MATERIAL);

    //glDisable(GL_COLOR_MATERIAL);

	allegro_gl_end();
	
    outtext(LOGFILE,"Installing timer\n");
    LOCK_VARIABLE(sec);
    LOCK_FUNCTION(go_sec);
	install_int_ex(go_sec, BPS_TO_TIMER(1000)); //increments sec 1000 times a second
}

void end_game(void)
{        
/*    for(int n=0 ; n<nSmokeSys ; n++)
        smokeSys[n].destroy();
    for(int n=0 ; n<nSparksSys ; n++)
        sparksSys[n].destroy();
*/
    partSys.destroy();

    delete []partGen;

    outtext(LOGFILE,"\nEND_GAME\n");
    

    if(data)
    {
        outtext(LOGFILE,"unloading datafile\n");
        unload_datafile(data);
    }
    
    for(int n=0 ; n<gameModeList.size() ; n++)
        delete gameModeList[n];
    gameModeList.clear();
    
    al_stop_duh(mod_player);
    if(current_song)
        unload_duh(current_song);
}

void load_ship_atts(TShipAtts *atts)
{
    
    outtext(LOGFILE,"\nLOAD_SHIP_ATTS\n");
    int iNumAtts;
    FILE *fp;
    
    outtext(LOGFILE,"\nLoading weapons set\n");
    fp=fopen("WeaponsSet.d3","rt");
    int numWeaponsSets;
    if(fp)
    {
        fscanf(fp,"%d",&numWeaponsSets);
        for(int n=0 ; n<numWeaponsSets ; n++)
        {
            TWeaponsSet set;
            for(int i=0 ; i<MAX_WEAPONS ; i++)
            {
                fscanf(fp,"%d ", &set.maxAmmo[i]);
            }    
            weapons_set.push_back(set);
        }    
     
        fclose(fp);   
    }   
    else
        outtext(LOGFILE,"Error Loading weapons set\n");
    
    
    outtext(LOGFILE,"\nLoading ship atts\n");
    fp=fopen("ShipAtts.d3","rt");
    if(fp)
    {
        fscanf(fp,"%d",&iNumAtts);
    
        for(int n=0 ; n<iNumAtts ; n++)
        {
            fscanf(fp,"%f %f %f %f %f %f %f %f %f %d %d %d",
                    &atts[n].fAccel,
                    &atts[n].fMaxVel,
                    &atts[n].fRevAccel,
                    &atts[n].fMaxRevVel,
                    &atts[n].fAngAccel,
                    &atts[n].fMaxAngVel,
                    &atts[n].fDampening,
                    &atts[n].fAngDampening,
                    &atts[n].fMass,
                    &atts[n].armor,
                    &atts[n].shield,
                    &atts[n].weaponsSet);
                    
            for(int j=0 ; j<MAX_WEAPONS; j++){
                atts[n].maxAmmo[j] = weapons_set[atts[n].weaponsSet].maxAmmo[j];
            }
        }
    
        fclose(fp);
    }

    //MINE
/*    atts[0].fAccel=.008;
    atts[0].fMaxVel=.45;
    atts[0].fAngAccel=.01;
    atts[0].fMaxAngVel=.15;
    atts[0].fDampening=.98;
    atts[0].fAngDampening=.92;
    atts[0].fMass=3;
    
    atts[1].fAccel=.009;
    atts[1].fMaxVel=.4;
    atts[1].fAngAccel=.015;
    atts[1].fMaxAngVel=.17;
    atts[1].fDampening=.97;
    atts[1].fAngDampening=.92;
    atts[1].fMass=2;*/
    
    //ANDY'S
    /*atts[0].fAccel=.008;
    atts[0].fMaxVel=.4;
    atts[0].fAngAccel=.01;
    atts[0].fMaxAngVel=.15;
    atts[0].fDampening=.99;
    atts[0].fAngDampening=.92;*/
    
    
    //DUEL2
   /* atts[0].fAccel=.006;
    atts[0].fMaxVel=1000;
    atts[0].fAngAccel=.02;
    atts[0].fMaxAngVel=1000;
    atts[0].fDampening=.985;
    atts[0].fAngDampening=.9;*/
}
/*
void setup_network(void)
{
    allegro_gl_begin();    
        camera.applyCamera();
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        glFlush();
        allegro_gl_flip();   
    allegro_gl_end(); 
        
    connection.create();
}
*/
void lobby(void)
{/*
    static int iShipNum=-1;
    if(iIsHost==-1)    //has not choosen to host or join
    {
        connect();
    }
    else
    {
        client.runLobby(player1Atts,player2Atts);
        if(iIsHost==1)  //the player is the host too
            server.runLobby();
    
        if(key[KEY_LCONTROL] || key[KEY_RCONTROL])
        {
            in_lobby=false;
            sec=0; cycles=0;
            
            //client.retPlayer1Num(void);
            
            
            for(int n=0 ; n<MAX_PLAYERS ; n++)
            {
                Player *p = game.retPlayer(n);
                if(p->retExist()==true)
                {
                    TPlayerAtts atts = p->retPlayerAtts();
                    Ship *s = game.retShip(n);        
                
                    createShip(s,(int)atts.iShipNum);
                
                    if(iIsHost==1)  //the player is the host too
                        server.runLobby();
                    

                }
            }

            startGame();
        }
    }*/
}


void connect(void)
{
    allegro_gl_begin();    
        camera.applyCamera();
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
        
        glEnable(GL_TEXTURE_2D);
            allegro_gl_printf(agl_font, 0, 3, 0, makecol(0, 255, 255), "Press H to host a game, or J to join one");
        glDisable(GL_TEXTURE_2D); 
 /*       
         if(key[KEY_H])
        {
            clear_keybuf();
            
            server.create(connection);        
            client.setAsLocal(&server,bHotSeat);    //tell the client created that there is a local host
            server.setLocalClient(&client,bHotSeat);    //tell the host created that there is a local client
            iIsHost=1;
                    
        }
        else if(key[KEY_J])
        {  
            client.create(connection,"192.168.2.100");
            
            iIsHost=0;
        }
    */    
        glFlush();
        allegro_gl_flip();   
    allegro_gl_end();
}

void login(void)
{
    allegro_gl_begin();    
        camera.applyCamera();
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
        doText(name);
        //writeText(0,5,0,makecol(0,255,255),allFonts[1],name);
        
        /*glEnable(GL_TEXTURE_2D);
            allegro_gl_printf(agl_font, 0, 5, 0, makecol(0, 255, 255), "Please enter your name: %s",name);
        glDisable(GL_TEXTURE_2D);

        glEnable(GL_TEXTURE_2D);
            allegro_gl_printf(agl_font, 0, 5, 0, makecol(0, 255, 255), "Please enter your name: %s",name);
        glDisable(GL_TEXTURE_2D);*/

        glFlush();
        allegro_gl_flip();   
    allegro_gl_end();
}

void createShip(Ship *s, int n, CVector2 pos)
{
    outtext(LOGFILE,"\nCreating Ship\n");
    //s->init();
    CVector2 vel(0,0,false);
/*    
    if(n==0)
    {
        s->setBCirc(2.1,pos,vel);
        s->setModel("s7.ms3d");
        s->setAtts(ship_atts[0]);
    }
    else if(n==1)
    {
        s->setBCirc(1.8,pos,vel);
        s->setModel("s5.ms3d");
        s->setAtts(ship_atts[1]);
    }*/
    
    TShipDef def;
    def = shipDefs.retShipDef(n);
    
    outtext(LOGFILE,"setting ship size\n");
    s->setBCirc(def.fCircRadius,pos,vel);
    
    //s->setModel(def.sModelFilename);
    outtext(LOGFILE,"setting ship model\n");
    s->setModel(&allModels[def.iModelNum]);
    
    outtext(LOGFILE,"setting ship's shield model\n");
    s->setShieldModel(&allModels[9]);
    
    outtext(LOGFILE,"setting ship atts\n");
    s->setAtts(def.atts);
    
    s->setName(def.sShipName);
   // s->reset();
}

void chooseShip()
{
    allegro_gl_begin();    
        camera.applyCamera();
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); 
            
                          
            glEnable(GL_TEXTURE_2D);
                allegro_gl_printf(agl_font, 0, 5, 0, makecol(0, 255, 255), "Choose a ship num 0-1 then, hit enter");
            glDisable(GL_TEXTURE_2D);
            
                  
            if(key[KEY_0])
                player1Atts.iShipNum=0;
            else if(key[KEY_1])
                player2Atts.iShipNum=1;     
                
            if(key[KEY_2])
                player2Atts.iShipNum=0;
            if(key[KEY_3])
                player2Atts.iShipNum=1;
                       
                                                
            if(key[KEY_ENTER])
            {
                in_choose_ship=false;
                in_login=true;
                while(key[KEY_ENTER]) {}
            }
            
        glFlush();
        allegro_gl_flip();   
    allegro_gl_end();   
}

void startGame(int gameMode,NewMenu *menu)
{
    outtext(LOGFILE,"entering function startGame\n");
    
    switch( cur_song_num ){
    case 0: play_song("music/BlackIce4.XM"); break;
    case 1: play_song("music/BlackIce3.XM"); break;
    case 2: play_song("music/BlackIce2.XM"); break;
    }    
    cur_song_num++;
    cur_song_num%=3;
    //reset_game();
    //setHost();
    in_lobby=false;
    sec=0; cycles=0;
    
    game.resetProjs();
    game.setupWeapons("weapons.d3",&partGen);
    game.setupPowerupTypes(&partGen);
    game.bHotSeat=bHotSeat;
    
    
    GameMode *gm=0;
    if(gameMode>=0 && gameMode<gameModeList.size())   //there are game modes in the list
    {
        gm = gameModeList[gameMode];
        game.setGameMode(gm);
    }
    if(!gm)
    {
        iMenuNum=1;
        return;
    }    
    
    iPlayer1Num = game.addPlayer(new Player());
    
    if(bHotSeat==true)  //a multiplayer game
        iPlayer2Num = game.addPlayer(new Player());
     
    gm->setUpGame(&game);     
                       
    for(int n=0 ; n<MAX_PLAYERS ; n++)  //add the player's ships
    {
        Player *p = game.retPlayer(n);
        if(p && p->retExist()==true)
        {
            outtext(LOGFILE,"here\n");
            TPlayerAtts atts = p->retPlayerAtts();
            Ship *s = game.retShip(n);        
            
            int gmShipNum = gm->getPlayerShipNum(n);
            if(gmShipNum==DONT_CARE)
                createShip(s,(int)atts.iShipNum,gm->getPlayerStartPos(n));
            else
                createShip(s,gmShipNum,gm->getPlayerStartPos(n));
            
            s->setupAmmo(&weapons_set,gm->getWeaponsSet(n));
            s->reset();
        }
    }

    
        

    initParticleSystems(&game);

    game.clearObjectList();
    game.constructObjectList();   


    /*CVector2
        tl_offset(-1.4,-2.3),
        br_offset(+1.4,+2.7),
        tl_offset2(-.97,-.47),
        br_offset2(+.97,+.56),
        pos(0,0,true), pos2(4,0,true),
        vel(0,0,false);
        
    CVector2 arena_top(-49,-38), arena_bot(49,38),
            p1(-42,-32) , p2(-40,30) , p3(40,34) , p4(39,-33),
            
            p5(0,0) , p6(10,10);
    
    
    tempArena.setBRect(arena_top,arena_bot,pos,vel);
    
    //comment the 4 lines below for the asteroids game
    tempArena.addWall(p1,p2);
    tempArena.addWall(p2,p3);
    tempArena.addWall(p3,p4);
    tempArena.addWall(p4,p1);
    
    //tempArena.addWall(p5,p6);
    
    game.setArena(tempArena);*/
    
   

    
    //game.startAsteroids(4);
    //game.startAsteroidsGame();      //uncomment this line to play asteroids
    
    
    
    sec=0;
    timeOfLastUpdate=0;
    iGraphicsLoops=0;
    iLogicLoops=0;
}

void initMenus(void)
{
    TButtonAtts b1Atts;
    
    b1Atts.drawOutline=false;
    b1Atts.outlineColour[0]=0;  b1Atts.outlineColour[1]=0;  b1Atts.outlineColour[2]=.5;
    b1Atts.outlineColourHighlighted[0]=0;  b1Atts.outlineColourHighlighted[1]=.3;  b1Atts.outlineColourHighlighted[2]=1;
    b1Atts.outlineColourDown[0]=0;  b1Atts.outlineColourDown[1]=.3;  b1Atts.outlineColourDown[2]=1;
    b1Atts.captionColour[0]=0;  b1Atts.captionColour[1]=75; b1Atts.captionColour[2]=200;
    b1Atts.captionColourHighlighted[0]=0;  b1Atts.captionColourHighlighted[1]=150; b1Atts.captionColourHighlighted[2]=250;
    b1Atts.captionColourDown[0]=0;  b1Atts.captionColourDown[1]=250; b1Atts.captionColourDown[2]=250;

    
        // menu.setModels(allModels);
    //menu.setShipDefs(&shipDefs);
       
    TMenuPage titlePage;    //this will be page 0
    
    titlePage.nWidgets=2;
    titlePage.widgets = new Widget* [2];
    titlePage.widgetTransitions = new int[2];
    
    titlePage.widgets[0] = new Button(0,makeVector2(0,-7,true),4.5,1.8,allFonts[2],"Play",b1Atts);
    titlePage.widgetTransitions[0] = 1;
    
//    titlePage.widgets[1] = new Button(1,makeVector2(0,-9.5,true),9.5,1.8,allFonts[2],"Hi Scores",b1Atts);
//    titlePage.widgetTransitions[1] = NO_TRANSITION;
    
    titlePage.widgets[1] = new Button(1,makeVector2(0,-12,true),4.5,1.8,allFonts[2],"Quit",b1Atts);
    titlePage.widgetTransitions[1] = QUIT_GAME;

    //titlePage.widgets[3] = new CheckBox(3,makeVector2(10,-6,true),1,1,allFonts[1],"Check1",b1Atts);
    //titlePage.widgetTransitions[3] = NO_TRANSITION;

    TMenuPage selectGame;   //this will be page 1

    selectGame.nWidgets=3;
    selectGame.widgets = new Widget* [3];
    selectGame.widgetTransitions = new int[3];    
    
    selectGame.widgets[0] = new Button(0,makeVector2(0,1.5,true),15,1.8,allFonts[2],"1 Player Games",b1Atts);
    selectGame.widgetTransitions[0] = 2;
    
    selectGame.widgets[1] = new Button(1,makeVector2(0,-1,true),15.5,1.8,allFonts[2],"2 Player Games",b1Atts);
    selectGame.widgetTransitions[1] = 3;    
    
//    selectGame.widgets[2] = new Button(2,makeVector2(0,-3.5,true),14,1.8,allFonts[2],"Custom Games",b1Atts);
//    selectGame.widgetTransitions[2] = NO_TRANSITION;
    
    selectGame.widgets[2] = new Button(2,makeVector2(0,-6,true),5,1.8,allFonts[2],"Back",b1Atts);
    selectGame.widgetTransitions[2] = 0;
    
    TMenuPage   onePlayerGames; //this will be page 2
    
    onePlayerGames.nWidgets=3;
    onePlayerGames.widgets = new Widget* [3];
    onePlayerGames.widgetTransitions = new int[3];
    
    onePlayerGames.widgets[0] = new Button(0,makeVector2(0,1.5,true),10,2.45,allFonts[2],"Asteroids",b1Atts);
    onePlayerGames.widgetTransitions[0] = 5;

    onePlayerGames.widgets[1] = new Button(1,makeVector2(0,-1,true),12.5,2.45,allFonts[2],"Missile Avoid",b1Atts);
    onePlayerGames.widgetTransitions[1] = 6;

    onePlayerGames.widgets[2] = new Button(2,makeVector2(0,-6,true),5,1.8,allFonts[2],"Back",b1Atts);
    onePlayerGames.widgetTransitions[2] = 1;
    
    TMenuPage   twoPlayerGames; //this will be page 3
    
    twoPlayerGames.nWidgets=4;
    twoPlayerGames.widgets = new Widget* [4];
    twoPlayerGames.widgetTransitions = new int[4];
    
    twoPlayerGames.widgets[0] = new Button(0,makeVector2(0,1.0,true),5.5,2.45,allFonts[2],"Duel",b1Atts);
    twoPlayerGames.widgetTransitions[0] = 4;

    twoPlayerGames.widgets[2] = new Button(2,makeVector2(0,-1.0,true),12.5,1.8,allFonts[2],"Missile Avoid",b1Atts);
    twoPlayerGames.widgetTransitions[2] = 7;    
 
    twoPlayerGames.widgets[3] = new Button(3,makeVector2(0,-3.3,true),10,1.8,allFonts[2],"Asteroids",b1Atts);
    twoPlayerGames.widgetTransitions[3] = 8;   

    twoPlayerGames.widgets[1] = new Button(1,makeVector2(0,-6,true),5,2.45,allFonts[2],"Back",b1Atts);
    twoPlayerGames.widgetTransitions[1] = 1;    
    

    
    //page 4 will be for two player Duel
    //page 5 will be for the one player asteroids 
    
    menu.init();
    menu.create();
    menu.reset();
    menu.setModels(allModels);
    menu.setShipDefs(&shipDefs);
    
    menu.addPage(titlePage);        //page 0
    menu.addPage(selectGame);       //page 1
    menu.addPage(onePlayerGames);   //page 2
    menu.addPage(twoPlayerGames);   //page 3
    menu.addPage(gameModeList[0]->createMenuPage(allFonts,b1Atts,3,allModels,&shipDefs,&game));    //page 4 (duel)
    menu.addPage(gameModeList[1]->createMenuPage(allFonts,b1Atts,2,allModels,&shipDefs,&game));    //page 5 (asteroids)
    menu.addPage(gameModeList[2]->createMenuPage(allFonts,b1Atts,2,allModels,&shipDefs,&game));    //page 6 (missile avoid)
    menu.addPage(gameModeList[3]->createMenuPage(allFonts,b1Atts,2,allModels,&shipDefs,&game));    //page 7 (2p missile avoid)
    menu.addPage(gameModeList[4]->createMenuPage(allFonts,b1Atts,2,allModels,&shipDefs,&game));    //page 8 (2p asteroids)
    menu.setupPage();
}


void runMenu(void)
{
    bQuitGame = menu.retQuitGame();
    
    if(titleAlpha < targetTitleAlpha-.025)
        titleAlpha+=.025;
    else if(titleAlpha > targetTitleAlpha+.025)
        titleAlpha-=.025;    
    
    if(menu.update()==true) //means the menu is done
    {
        
        
       // iMenuNum = menu.retNextMenu();
        
        
        //bStarfieldSpeedup=true;
        //fStarfieldSpeed=4;
        //fNextMenuZoom=-1500;
            
        //menu.reset();
        
        /*player1Atts.iShipNum=menu.retP1Ship();
        player2Atts.iShipNum=menu.retP2Ship();
        strcpy(player1Atts.sName,menu.retName());*/
            
        /*if(menu.retGameType()==ONE_PLAYER)
        {
            bHotSeat=false;
            setHost();
        }
        else if(menu.retGameType()==TWO_PLAYER)
        {
            bHotSeat=true;
            setHost();
        }
        else if(menu.retGameType()==INTERNET_HOST)
        {
            bHotSeat=false;
            setHost();
        }
        else if(menu.retGameType()==INTERNET_JOIN)
        {
            bHotSeat=false;
            setJoin(menu.retAddress());
        }*/
        int result;   
        result = menu.getGameModeResult();    
        if(result == GM_DUEL || result == GM_MISSILE_AVOID2 || result == GM_ASTEROIDS2)
        {
            bHotSeat=true;  //means 2 players
            iMenuNum=-1;
        }
        else if(result == GM_ASTEROIDS || result == GM_MISSILE_AVOID)
        {
            bHotSeat=false; //means 1 player
            iMenuNum=-1;
        }          
                  
        if(iMenuNum==-1)
        { 
            in_choose_ship=false;
            in_lobby=false;
        
            if(result == GM_DUEL)
                startGame(0,&menu);
            else if(result == GM_ASTEROIDS)
                startGame(1,&menu);
            else if(result == GM_MISSILE_AVOID)
                startGame(2,&menu);
            else if(result == GM_MISSILE_AVOID2)
                startGame(3,&menu);
            else if(result == GM_ASTEROIDS2)
                startGame(4,&menu);
        }
    }
    
}

void drawMenu(void)
{
    ortho_begin(SCREEN_W, SCREEN_H);

    if(menu.retCurPage()==0) //not on the first page
        targetTitleAlpha=1;
    else 
        targetTitleAlpha=.4;
    title.drawPict(makeVector2(400,300,true),titleAlpha);
    ortho_end();
    
    menu.draw();
    //pict.drawPict(makeVector2(0,0,true)); 


}


void loadModels(char *sModels)
{
    FILE *fp;
    fp = fopen(sModels,"rt");
    int iFilePos=0;
    int iFileLength=0;    
   
    outtext(LOGFILE,"\nLoading models\n");
    
    char modelName[70];
    int iNumModels=0;
    fscanf(fp,"%d",&iNumModels);
    for(int n=0 ; n<iNumModels ; n++)
    {
        fscanf(fp,"%s",modelName); 
        allModels[n].loadModel(modelName);
        allModels[n].loadAllTextures();
    }
    fclose(fp);   
}

void skipMenu(void)
{
    player1Atts.iShipNum=0/*7*/;    //change this for asteroids
    player2Atts.iShipNum=1;
    bHotSeat=true/*false*/;         //and change this
    in_choose_ship=false;
    in_lobby=false;
    
    strcpy(player1Atts.sName,"Player1");
    
   /* for(int n=0 ; n<3 ; n++)
    {
        client.runLobby(player1Atts,player2Atts);
        if(iIsHost==1)  //the player is the host too
            server.runLobby();
    }*/
    startGame(0,&menu);
}

void displaySplashScreen(void)
{
        BRect splash;
        splash.setPict(1,1,"images/title1.bmp");
        splash.setPos(makeVector2(0,0,true));


    allegro_gl_begin();    
                    glMatrixMode (GL_PROJECTION);
                    glLoadIdentity ();
                    gluPerspective(45.0f,(GLfloat)800/(GLfloat)600, 1.5f, 4000.0f);
                    glMatrixMode (GL_MODELVIEW);
                    glLoadIdentity();
    
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        glFlush();

        splash.draw();   
        
        
        
        allegro_gl_flip();  
        
         
          
            
    allegro_gl_end();

}

void initParticleSystems(Game *g)
{
    PartAtts smoke_atts;
    smoke_atts.wind = makeVector3(0,0,0);   //no wind
    smoke_atts.colour = makeColour(1 , 1 , 1 );
    smoke_atts.radius = .05;
    smoke_atts.start_density = 2;
    smoke_atts.density = 2;
    smoke_atts.particle_lifespan = 20;
    smoke_atts.particle_size= 2;
    smoke_atts.blendMode=BM_SMOKE;
    smoke_atts.sprayArc=M_PI/(6);
    smoke_atts.shape[0]=makeVector3(1,-1,0); smoke_atts.shape[1]=makeVector3(1,1,0); smoke_atts.shape[2]=makeVector3(-1,1,0); smoke_atts.shape[3]=makeVector3(-1,-1,0);
    smoke_atts.base_opacity=.33;
    
    PartAtts sparks_atts;
    sparks_atts.wind = makeVector3(0,0,0);   //no wind
    sparks_atts.colour = makeColour(1 , .7 , 0 );
    sparks_atts.radius = .05;
    sparks_atts.start_density = 6;
    sparks_atts.density = 1;
    sparks_atts.particle_lifespan = 22;
    sparks_atts.particle_size= 3;
    sparks_atts.blendMode=BM_FIRE;
    sparks_atts.sprayArc=2*M_PI;
    sparks_atts.shape[0]=makeVector3(1,-2,0); sparks_atts.shape[1]=makeVector3(1,2,0); sparks_atts.shape[2]=makeVector3(-1,2,0); sparks_atts.shape[3]=makeVector3(-1,-2,0);
    sparks_atts.base_opacity=.33;
    
    PartAtts shield_atts;
    shield_atts.wind = makeVector3(0,0,0);   //no wind
    shield_atts.colour = makeColour(.2 , .2 , 1 );
    shield_atts.radius = .03;
    shield_atts.start_density = 6;
    shield_atts.density = 1;
    shield_atts.particle_lifespan = 12;
    shield_atts.particle_size= 3;
    shield_atts.blendMode=BM_FIRE;
    shield_atts.sprayArc=2*M_PI;
    shield_atts.shape[0]=makeVector3(1,-2,0); shield_atts.shape[1]=makeVector3(1,2,0); shield_atts.shape[2]=makeVector3(-1,2,0); shield_atts.shape[3]=makeVector3(-1,-2,0);
    shield_atts.base_opacity=.33;
    
    GenAtts engine_atts,damage_atts,explosion_atts,shieldGen_atts,respawnGen_atts,shieldShatter_atts, alwaysOnGen_atts,asteroidGen_atts;
    
    engine_atts.thruster=true;
    engine_atts.collision=false;
    engine_atts.respawn=false;
    engine_atts.constant=true;
    engine_atts.shieldDie=false;
    engine_atts.damageThreshold=-1;
    engine_atts.vel=1;

    damage_atts.thruster=false;
    damage_atts.collision=false;
    damage_atts.respawn=false;
    damage_atts.constant=true;
    damage_atts.shieldDie=false;
    damage_atts.damageThreshold=.5;     //sparks when armor is below 50%
    damage_atts.vel=.15;
    
    explosion_atts.thruster=false;
    explosion_atts.collision=false;
    explosion_atts.respawn=false;
    explosion_atts.constant=false;
    explosion_atts.shieldDie=false;
    explosion_atts.damageThreshold=-1;
    explosion_atts.vel=1;
    
    shieldGen_atts.thruster=false;
    shieldGen_atts.collision=true;
    shieldGen_atts.respawn=false;
    shieldGen_atts.constant=false;
    shieldGen_atts.shieldDie=false;
    shieldGen_atts.damageThreshold=-1;
    shieldGen_atts.vel=1;
    
    respawnGen_atts.thruster=false;
    respawnGen_atts.collision=false;
    respawnGen_atts.respawn=true;
    respawnGen_atts.constant=false;
    respawnGen_atts.shieldDie=false;
    respawnGen_atts.damageThreshold=-1;
    respawnGen_atts.vel=1;
    
    shieldShatter_atts.thruster=false;
    shieldShatter_atts.collision=false;
    shieldShatter_atts.respawn=false;
    shieldShatter_atts.constant=false;
    shieldShatter_atts.shieldDie=true;
    shieldShatter_atts.damageThreshold=-1;
    shieldShatter_atts.vel=1;
    
    alwaysOnGen_atts.thruster=false;
    alwaysOnGen_atts.collision=false;
    alwaysOnGen_atts.respawn=false;
    alwaysOnGen_atts.constant=true;
    alwaysOnGen_atts.shieldDie=false;
    alwaysOnGen_atts.damageThreshold=-1;
    alwaysOnGen_atts.vel=1;
    
    asteroidGen_atts.thruster=false;
    asteroidGen_atts.collision=true;
    asteroidGen_atts.respawn=false;
    asteroidGen_atts.constant=false;
    asteroidGen_atts.shieldDie=false;
    asteroidGen_atts.damageThreshold=-1;
    asteroidGen_atts.vel=1;
    
    /************************SHIP EXAUST**********************************/
    partGen[0].setParticles(&partSys);
    partGen[0].create(smoke_atts,engine_atts);
    partGen[0].setTexture("images/t1.bmp");
    partGen[0].start();

    /***********************DAMAGE SPARKS********************************/
    partGen[1].setParticles(&partSys);
    partGen[1].create(sparks_atts,damage_atts);
    partGen[1].setTexture("images/t3.bmp");
    partGen[1].start();

    /***********************SHIP SHIELD PARTS*****************************/
    partGen[2].setParticles(&partSys);
    partGen[2].create(shield_atts,shieldGen_atts);
    partGen[2].setTexture("images/t3.bmp");
    partGen[2].start();
    
    /**********************ENERGY PROJ SPARKS******************************/
    partGen[3].setParticles(&partSys);
    shield_atts.start_density=2; shield_atts.particle_size=4; shield_atts.particle_lifespan=15;
    shield_atts.colour = makeColour(.6 , .6 , 1 );
    shield_atts.shape[0]=makeVector3(3,-1,0); shield_atts.shape[1]=makeVector3(3,1,0); shield_atts.shape[2]=makeVector3(-3,1,0); shield_atts.shape[3]=makeVector3(-3,-1,0);
    partGen[3].create(shield_atts,shieldGen_atts);
    partGen[3].setTexture("images/t3.bmp");
    partGen[3].start();
    
    /**********************MISSILE EXAUST**********************************/
    partGen[4].setParticles(&partSys);
    smoke_atts.particle_size= 1;
    smoke_atts.density=1; smoke_atts.start_density=1; smoke_atts.particle_lifespan=10;
    smoke_atts.shape[0]=makeVector3(1,-2,0); smoke_atts.shape[1]=makeVector3(1,2,0); smoke_atts.shape[2]=makeVector3(-1,2,0); smoke_atts.shape[3]=makeVector3(-1,-2,0);
    partGen[4].create(smoke_atts,engine_atts);
    partGen[4].setTexture("images/t1.bmp");
    partGen[4].start();
    
    /************************SMALL MISSLE EXPLOSIONS***************************/
    partGen[5].setParticles(&partSys);
    shield_atts.start_density=5; shield_atts.particle_size=5; shield_atts.particle_lifespan=27;
    shield_atts.colour = makeColour(1 , .75 , .1 );
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[5].create(shield_atts,shieldGen_atts);
    partGen[5].setTexture("images/t3.bmp");
    partGen[5].start();
    
    /************************SHIP EXPLOSION*******************************/
    sparks_atts.shape[0]=makeVector3(2,-1,0); sparks_atts.shape[1]=makeVector3(2,1,0); sparks_atts.shape[2]=makeVector3(-2,1,0); sparks_atts.shape[3]=makeVector3(-2,-1,0);
    partGen[6].setParticles(&partSys);
    partGen[6].create(sparks_atts,explosion_atts);
    partGen[6].setTexture("images/t3.bmp");
    partGen[6].start();

    
    /************************LARGE MISSLE EXPLOSIONS***************************/
    partGen[7].setParticles(&partSys);
    shield_atts.start_density=10; shield_atts.particle_size=7; shield_atts.particle_lifespan=35;
    shield_atts.colour = makeColour(1 , .75 , .1 );
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[7].create(shield_atts,shieldGen_atts);
    partGen[7].setTexture("images/t3.bmp");
    partGen[7].start();
    
    /**********************SHIELD SHATTER SPAKRS********************************/
    partGen[8].setParticles(&partSys);
    shield_atts.start_density=15; shield_atts.particle_size=4; shield_atts.particle_lifespan=27;
    shield_atts.colour = makeColour(0 , .4 , 1 );
    shield_atts.shape[0]=makeVector3(2,-1,0); shield_atts.shape[1]=makeVector3(2,1,0); shield_atts.shape[2]=makeVector3(-2,1,0); shield_atts.shape[3]=makeVector3(-2,-1,0);
    shield_atts.base_opacity=.45;
    partGen[8].create(shield_atts,shieldShatter_atts);
    partGen[8].setTexture("images/t3.bmp");
    partGen[8].start();
    
    /**************************RESPAWN SPARKS***********************************/
    partGen[9].setParticles(&partSys);
    shield_atts.start_density=25; shield_atts.particle_size=2; shield_atts.particle_lifespan=80;
    shield_atts.colour = makeColour(0 , 1 , .8 );
    shield_atts.base_opacity=.6;
    shield_atts.shape[0]=makeVector3(3,-1,0); shield_atts.shape[1]=makeVector3(3,1,0); shield_atts.shape[2]=makeVector3(-3,1,0); shield_atts.shape[3]=makeVector3(-3,-1,0);
    partGen[9].create(shield_atts,respawnGen_atts);
    partGen[9].setTexture("images/t4.bmp");
    partGen[9].start();
    //nPartGen++;
    
    /************************COMING FROM THE MINES******************************/
    partGen[10].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_size=2; shield_atts.particle_lifespan=15;
    shield_atts.colour = makeColour(1 , .2 , 1 );
    shield_atts.base_opacity=.8;
    alwaysOnGen_atts.vel=.25;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[10].create(shield_atts,alwaysOnGen_atts);
    partGen[10].setTexture("images/t3.bmp");
    partGen[10].start();
    
    /************************MINE EXPLOSIONS***************************/
    partGen[11].setParticles(&partSys);
    shield_atts.start_density=9; shield_atts.particle_size=6; shield_atts.particle_lifespan=32;
    shield_atts.colour = makeColour(1 , .3 , 1 );
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[11].create(shield_atts,shieldGen_atts);
    partGen[11].setTexture("images/t3.bmp");
    partGen[11].start();
    
    /************************ASTEROID EXPLOSIONS***************************/
    partGen[12].setParticles(&partSys);
    shield_atts.start_density=10; shield_atts.particle_size=7; shield_atts.particle_lifespan=35;
    shield_atts.colour = makeColour(.4 , .4 , .4 );
    shield_atts.base_opacity=.8;
    asteroidGen_atts.vel=.4;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[12].create(shield_atts,asteroidGen_atts);
    partGen[12].setTexture("images/t4.bmp");
    partGen[12].start();
    
    /************************SMALL SHOTGUN SPARKS***************************/
    partGen[13].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.particle_size=2; shield_atts.particle_lifespan=15;
    shield_atts.colour = makeColour(1 , .75 , .1 );
    alwaysOnGen_atts.vel=0.1;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[13].create(shield_atts,alwaysOnGen_atts);
    partGen[13].setTexture("images/t3.bmp");
    partGen[13].start();    
    
    /************************COMING FROM THE CONCUSSION BALLS******************************/
    partGen[14].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_size=2; shield_atts.particle_lifespan=9;
    shield_atts.colour = makeColour(1 , .2 , .2 );
    shield_atts.base_opacity=.6;
    shield_atts.particle_size= 4;
    alwaysOnGen_atts.vel=.1;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[14].create(shield_atts,alwaysOnGen_atts);
    partGen[14].setTexture("images/t3.bmp");
    partGen[14].start();

    /**********************CONCUSSION BALLS SHATTER SPAKRS********************************/
    partGen[15].setParticles(&partSys);
    shield_atts.start_density=10; shield_atts.particle_size=4; shield_atts.particle_lifespan=27;
    shield_atts.colour = makeColour(1 , .2 , 0 );
    shield_atts.shape[0]=makeVector3(2,-1,0); shield_atts.shape[1]=makeVector3(2,1,0); shield_atts.shape[2]=makeVector3(-2,1,0); shield_atts.shape[3]=makeVector3(-2,-1,0);
    shield_atts.base_opacity=.45;
    partGen[15].create(shield_atts,shieldShatter_atts);
    partGen[15].setTexture("images/t3.bmp");
    partGen[15].start();

    /**********************DEFENCE RING PARTS********************************/
    partGen[16].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_lifespan=3;
    shield_atts.colour = makeColour(.2 , .2 , 1 );
    shield_atts.base_opacity=.8;
    shield_atts.particle_size= 4;
    alwaysOnGen_atts.vel=.25;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[16].create(shield_atts,alwaysOnGen_atts);
    partGen[16].setTexture("images/t3.bmp");
    partGen[16].start();

    /**********************SHIELD BAR EFFECT********************************/
    partGen[17].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_lifespan=10;
    shield_atts.colour = makeColour(0 , 0 , 1 );
    shield_atts.base_opacity=1;
    shield_atts.particle_size= 3;
    alwaysOnGen_atts.vel=.15;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[17].create(shield_atts,alwaysOnGen_atts);
    partGen[17].setTexture("images/t3.bmp");
    partGen[17].start();

    /********************ARMOUR BAR EFFECT***********************************/
    partGen[18].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_lifespan=6;
    shield_atts.colour = makeColour(1 , 0 , 0 );
    shield_atts.base_opacity=1;
    shield_atts.particle_size= 4;
    alwaysOnGen_atts.vel=.1;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[18].create(shield_atts,alwaysOnGen_atts);
    partGen[18].setTexture("images/t3.bmp");
    partGen[18].start();
    
    /************************COMING FROM THE EMP WAVE******************************/
    partGen[19].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_size=2; shield_atts.particle_lifespan=9;
    shield_atts.colour = makeColour(.2 , .2 , 1 );
    shield_atts.base_opacity=.6;
    shield_atts.particle_size= 4;
    alwaysOnGen_atts.vel=.2;
    shield_atts.shape[0]=makeVector3(2,-1,0); shield_atts.shape[1]=makeVector3(2,1,0); shield_atts.shape[2]=makeVector3(-2,1,0); shield_atts.shape[3]=makeVector3(-2,-1,0);
    partGen[19].create(shield_atts,alwaysOnGen_atts);
    partGen[19].setTexture("images/t4.bmp");
    partGen[19].start();
    
    /************************EMP WAVE END******************************/
    partGen[20].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_size=2; shield_atts.particle_lifespan=35;
    shield_atts.colour = makeColour(.2 , .2 , 1 );
    shield_atts.base_opacity=.6;
    shield_atts.particle_size= 4;
    alwaysOnGen_atts.vel=.4;
    shield_atts.shape[0]=makeVector3(2,-1,0); shield_atts.shape[1]=makeVector3(2,1,0); shield_atts.shape[2]=makeVector3(-2,1,0); shield_atts.shape[3]=makeVector3(-2,-1,0);
    partGen[20].create(shield_atts,alwaysOnGen_atts);
    partGen[20].setTexture("images/t4.bmp");
    partGen[20].start();

    /************************COMING FROM THE BERSERKERS******************************/
    partGen[21].setParticles(&partSys);
    shield_atts.start_density=2; shield_atts.density=1; shield_atts.particle_size=3; shield_atts.particle_lifespan=15;
    shield_atts.colour = makeColour(1 , 0 , .2 );
    shield_atts.base_opacity=.8;
    alwaysOnGen_atts.vel=.25;
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[21].create(shield_atts,alwaysOnGen_atts);
    partGen[21].setTexture("images/t3.bmp");
    partGen[21].start();
    
    /************************BERSERKERS EXPLOSIONS***************************/
    partGen[22].setParticles(&partSys);
    shield_atts.start_density=9; shield_atts.particle_size=7; shield_atts.particle_lifespan=32;
    shield_atts.colour = makeColour(1 , 0 , .2 );
    shield_atts.shape[0]=makeVector3(1,-1,0); shield_atts.shape[1]=makeVector3(1,1,0); shield_atts.shape[2]=makeVector3(-1,1,0); shield_atts.shape[3]=makeVector3(-1,-1,0);
    partGen[22].create(shield_atts,shieldGen_atts);
    partGen[22].setTexture("images/t3.bmp");
    partGen[22].start();

    /************************COMING FROM THE EMP WAVE******************************/
    partGen[23].setParticles(&partSys);
    shield_atts.start_density=1; shield_atts.density=1; shield_atts.particle_size=2; shield_atts.particle_lifespan=9;
    shield_atts.colour = makeColour(.2 , 1 , .2 );
    shield_atts.base_opacity=.6;
    shield_atts.particle_size= 4;
    alwaysOnGen_atts.vel=.2;
    shield_atts.shape[0]=makeVector3(2,-1,0); shield_atts.shape[1]=makeVector3(2,1,0); shield_atts.shape[2]=makeVector3(-2,1,0); shield_atts.shape[3]=makeVector3(-2,-1,0);
    partGen[23].create(shield_atts,alwaysOnGen_atts);
    partGen[23].setTexture("images/t4.bmp");
    partGen[23].start();

    nPartGen=24;
            
    for(int n=0 ; n<g->retNumPlayers() ; n++)
    {

        /*partGen[nPartGen].setParticles(&partSys);
        partGen[nPartGen].create(smoke_atts,engine_atts);
        partGen[nPartGen].setTexture("images/t1.bmp");
        partGen[nPartGen].start();*/
        g->retPlayer(n)->retShip()->addPartsGen(&partGen[0]);
        //nPartGen++;
        
        /*partGen[nPartGen].setParticles(&partSys);
        partGen[nPartGen].create(sparks_atts,damage_atts);
        partGen[nPartGen].setTexture("images/t3.bmp");
        partGen[nPartGen].start();*/
        g->retPlayer(n)->retShip()->addPartsGen(&partGen[1]);
        //nPartGen++;
        
        /*partGen[nPartGen].setParticles(&partSys);
        partGen[nPartGen].create(shield_atts,shieldGen_atts);
        partGen[nPartGen].setTexture("images/t3.bmp");
        partGen[nPartGen].start();*/
        g->retPlayer(n)->retShip()->addPartsGen(&partGen[2]);
        
        g->retPlayer(n)->retShip()->addPartsGen(&partGen[8]);
        g->retPlayer(n)->retShip()->addPartsGen(&partGen[9]);
        //nPartGen++;
        
        g->retPlayer(n)->retShip()->setOnDeathPartGen(&partGen[6]);
        
        g->retPlayer(n)->setHudPartGens(&partGen[18],&partGen[17]);
    }
    
    g->setAsteroidsParts(&partGen[12]);
    
    /*sparks_atts.shape[0]=makeVector3(2,-1,0); sparks_atts.shape[1]=makeVector3(2,1,0); sparks_atts.shape[2]=makeVector3(-2,1,0); sparks_atts.shape[3]=makeVector3(-2,-1,0);
    partGen[nPartGen].setParticles(&partSys);
    partGen[nPartGen].create(sparks_atts,explosion_atts);
    partGen[nPartGen].setTexture("images/t3.bmp");
    partGen[nPartGen].start();
    nPartGen++;*/
}

void getKeys(void)
{
    static bool kp1=false,kp2=false;
    Ship *ship = game.retShip(iPlayer1Num);

    static int prevLeftorRight=0, prevAorD=0;
    static int curLeftorRight=0, curAorD=0;
    static int doubletapCounter1=0, doubletapCounter2=0;

    if(ship)
    {
        if(key[KEY_UP])
            ship->thrust();  
        else if(key[KEY_DOWN])
            ship->rev();
    
        ship->dampenVelocity();
        if(!key[KEY_UP])
            ship->thrusting=false;    //reset the thrusting var
    
        if(key[KEY_RCONTROL])
            ship->shoot(game.retProjArray());
    
        
        if(key[KEY_LEFT]){
            //if(key[KEY_ENTER])
            //    ship->leftSpecial();
            //else
                ship->turnLeft();
                
                if(curLeftorRight==0 && prevLeftorRight==KEY_LEFT){
                    ship->leftSpecial();
                } 
                curLeftorRight = KEY_LEFT;
                prevLeftorRight = KEY_LEFT;
                doubletapCounter1=5;
        }
        else if(key[KEY_RIGHT]){
            //if(key[KEY_ENTER])
            //    ship->rightSpecial();
            //else
                ship->turnRight();
                
                if(curLeftorRight==0 && prevLeftorRight==KEY_RIGHT){
                    ship->rightSpecial();
                }  
                curLeftorRight = KEY_RIGHT;
                prevLeftorRight = KEY_RIGHT;
                doubletapCounter1=5;
        }
        else{
            curLeftorRight=0;
            ship->dampenAngVelocity();
        }
        
        if(doubletapCounter1>0)
            doubletapCounter1--;
        else
            prevLeftorRight=0;
            
        if(key[KEY_RSHIFT] && kp1==false)
        {
            ship->nextWeapon();
            kp1=true;
        }
        if(!key[KEY_RSHIFT])
            kp1=false;    
    }
             
    if(bHotSeat==true)  //means it is a 2 player game
    {
        Ship *ship2 = game.retShip(iPlayer2Num);
        if(ship2)
        {
            if(key[KEY_W])
                ship2->thrust(); 
            else if(key[KEY_S])
                ship2->rev(); 
    
            ship2->dampenVelocity();
            if(!key[KEY_W] && !key[KEY_S])
                ship2->thrusting=false;    //reset the thrusting var
            
            if(key[KEY_LCONTROL])
                ship2->shoot(/*game->retNextProj()*/game.retProjArray());
            
            if(key[KEY_LSHIFT] && kp2==false)
            {
                ship2->nextWeapon();
                kp2=true;
            }
            if(!key[KEY_LSHIFT])
                kp2=false;
            
            if(key[KEY_A]){
                //if(key[KEY_CAPSLOCK])
                //    ship2->leftSpecial();
                //else
                ship2->turnLeft();
                
                if(curAorD==0 && prevAorD==KEY_A){
                    ship2->leftSpecial();
                }  
                curAorD = KEY_A;
                prevAorD = KEY_A;
                doubletapCounter2=5;
            }
            else if(key[KEY_D]){
                //if(key[KEY_CAPSLOCK])
                //    ship2->rightSpecial();
                //else
                ship2->turnRight();
                
                if(curAorD==0 && prevAorD==KEY_D){
                    ship2->rightSpecial();
                }  
                curAorD = KEY_D;
                prevAorD = KEY_D;
                doubletapCounter2=5;
            }
            else{
                curAorD=0;
                ship2->dampenAngVelocity();  
            }
            
            if(doubletapCounter2>0)
                doubletapCounter2--;
            else
                prevAorD=0;
            
        }
    } 
    
    static int prntScreenCounter=0;
    if(key[KEY_PRTSCR]){
        if(prntScreenCounter==0){
            allegro_gl_begin(); 
              /* int tex = allegro_gl_make_texture_ex(0,capture,GL_RGBA8);
               
               // Copy the viewport to the new texture
               glBindTexture(GL_TEXTURE_2D,tex);	
	           glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, 0, 0, 800, 600, 0);*/
	           	BITMAP *bmp = create_bitmap(800,600);
            	if(!bmp) return;
            	unsigned char *buff = new unsigned char[4*800*600];
            	if(!buff)
            	{
            		destroy_bitmap(bmp);
            		return;
            	}
            
            	glReadPixels(0,0,800,600,GL_RGBA,GL_UNSIGNED_BYTE,buff);
            
            	int y;
            	for(y=0;y<SCREEN_H;y++)
            		memcpy(bmp->line[y],buff+4*800*(600-1-y),4*800);
            
                char *filename_base="shot";
                for(int num=0 ; num<100 ; num++){
                    char *filename_final = new char[12+4+2+1+3+1];
                    sprintf(filename_final,"screenshots/%s%d.bmp",filename_base,num);
                    outtext(LOGFILE,filename_final);
                    if(!exists(filename_final)){
            	       save_bitmap(filename_final,bmp,NULL);
            	       break;
                    }
                }
            
            	destroy_bitmap(bmp);
            	delete buff;
	           
            allegro_gl_end(); 
            prntScreenCounter=10;
        }
    }
    if(prntScreenCounter>0)
        prntScreenCounter--;
}    


void play_song(char *filename)
{
    if(current_song)    //have to fade the current song out first
    {
        fading_out=true; 
        //outtext(LOG,"fading out current song");
        //current_volume=.6f; 

        target_volume=.3f;
                                al_stop_duh(mod_player);
                        unload_duh(current_song);
                                                    current_song= dumb_load_xm(filename);
                    outtext(LOGFILE,filename);
                    mod_player=al_start_duh(current_song, 2, 0,target_volume, 512, 10000);   
    }    
    else            //have to fade the new song in
    {
        fading_out=false;
        current_volume=0;
        target_volume=.3f;
        
                            current_song= dumb_load_xm(filename);
                    outtext(LOGFILE,filename);
                    mod_player=al_start_duh(current_song, 2, 0,target_volume, 512, 10000);   
    }    
    outtext(LOGFILE,"song loaded");
    strcpy(next_song,filename);
        
    song_on=true;
}

void stop_song(void)
{
    if(current_song)
    {
       /* fading_out=true; 
        target_volume=0; 
        strcpy(next_song,"none"); */
                                        al_stop_duh(mod_player);
                        unload_duh(current_song);
    }           
}    

void update_music_state(void)
{
    /*if(song_on==true)
    {
        if(fading_out==false)   //it is fading in
        {
            //if it hasn't started yet
            if(current_volume==0)
            {
                //if there  is a new song waiting
                if(next_song && strcmp(next_song,"none")!=0)
                {
                    if(current_song)
                    {
                        //unload the current song
                        al_stop_duh(mod_player);
                        unload_duh(current_song);
                        current_song=0;
                    }
                        
                    //start the next song
                    current_song= dumb_load_xm(next_song);
                    outtext(LOGFILE,next_song);
                    mod_player=al_start_duh(current_song, 2, 0,target_volume, 512, 10000);          
                    current_volume+=0.1f;
                    target_volume=0.3f;  
                } 
                else    //there is no song waiting
                {
                    al_stop_duh(mod_player);
                    unload_duh(current_song);
                    current_song=0;  
                    song_on=false;
                }                     
            }          
        }  
        else if(fading_out==true)   //it is fading out
        {
            if(current_volume==0)   //it is done fading
            {
                fading_out=false;    
            }        
        }         
    }  */  
}
    
void update_music_volume(void)
{
    if(song_on==true && current_song)
    {
        /*if(current_volume+.01f < target_volume)
        {
            current_volume+=.01f;
            al_duh_set_volume(mod_player,current_volume);
        }    
        else if(current_volume-.01f > target_volume)
        {
            current_volume-=.01f;
            al_duh_set_volume(mod_player,current_volume);
        }    
        else*/
      //      current_volume = target_volume;
    }    
}
