/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef ASTEROID_H
#define ASTEROID_H


#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"
#include "ScoreKeeper.h"
#include "CVector2.h"
#include "CVector3.h"
#include "Object.h"
#include "BRect.h"
#include "Weapon.h"
#include "SObject.h"
#include "PObject.h"
#include "Ship.h"


#define MAX_ASTEROIDS   30


class Asteroid : public PObject
{
private:
    float speed;
    int stage;
    bool broken;
    int health;
    
public:
    void init(void);
    void draw(bool wireframe=false);
    void update(void);
    void create(CVector2 _pos, CVector2 _vel, CVector2 _accel, float _scale, int _stage=1);
    
    void breakApart(void);
    bool retBroken(void) {return broken;}
    void setBroken(bool _broken) {broken=_broken;}
    
    float retScale(void) {return scale;}
    int retStage(void) {return stage;}
    bool targetable(void) {return true;}
    
    CollisionInfo reactToCollision(void);
    void reactToCollisionInfo(CollisionInfo &colInfo);
    
    Asteroid();
    ~Asteroid();
};



class AsteroidArray
{
private:
    Asteroid asteroid[MAX_ASTEROIDS];
    int nAsteroids;
    
    

    BRect bounds;
    ParticleGenerator *onDeathPartGen;
    
public:
    void setModels(Model *m, int n1, int n2);
    void startAsteroids(int n, BRect *_bounds);
    
    void update(void);
    void draw(void);

    void createNew(CVector2 _pos, CVector2 _vel, CVector2 _accel, float _scale, int _stage=1);
    
    void init(void);
    
    
    bool asteroidsAlive(void);
    Asteroid* retAsteroid(int n);
    
    void setPartGen(ParticleGenerator *pg);

    AsteroidArray();
    ~AsteroidArray();
};

#endif // ASTEROID_H

