/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "asteroid.h" // class's header file

extern ParticleSystem partSys;

void Asteroid::draw(bool wireframe)
{
    //glScalef(scale,scale,scale);
    //glRotatef(0,0,1,20);
    PObject::draw(wireframe);

}

void Asteroid::create(CVector2 _pos, CVector2 _vel, CVector2 _accel, float _scale, int _stage)
{
    scale = _scale;
    setBCirc(scale*.9, _pos,  _vel);
    setAccel(_accel);
    exist=true;
    bDoesAccel=false;
    projType=ASTEROID;
    
    setMass(scale*2);
    stage=_stage;
    broken=false;
    
    if(stage==1)
        health=10;
    else
        health=4;
        
    invincibleCounter=5;

    //speed = .2 + .1*stage;
    //vel.setMag(speed);
    speed=vel.retMag();

}

void Asteroid::update(void)
{
    //speed = .2 + .1*stage;
    vel.setMag(speed);

    
    //ax+=4;
    ay+=4;
    //az+=4;
    
    if(ax>360)
        ax-=360;
    if(ay>360)
        ay-=360;
    //if(az>360)
    //    az-=360;    
        
    PObject::update();

}   

CollisionInfo Asteroid::reactToCollision(void)
{
    CollisionInfo colInfo;
    if(exist==true)
    {
        colInfo.shieldDamage=100;
        colInfo.armorDamage=100;
        colInfo.projDamage=100;
        colInfo.owner_id=-1;
        colInfo.owner_team=-1;
        colInfo.genType=genType;
    }
    return colInfo;
}

void Asteroid::reactToCollisionInfo(CollisionInfo &colInfo)
{
    if(colInfo.genType==TYPE_PROJ)
    {
        if(invincibleCounter==0)
            health-=(int)colInfo.armorDamage;
        if(health<=0)
        {
            //the asteroid was shot by a ship's projectile
            ScoreKeeper::instance()->incScore(colInfo.owner_team);
            ScoreKeeper::instance()->incMultiplier(colInfo.owner_team);
            
            char buf[5];
            sprintf(buf,"%d",ScoreKeeper::instance()->getLastScoreInc(colInfo.owner_team));
            
            breakApart();
            partSys.addTextParticle(makeVector3(pos.retX(),pos.retY(),0), buf);
        }
        
        //for keeping track of stats for ships
        if(colInfo.ptrToOwner!=0)
        {
            ((Ship*)colInfo.ptrToOwner)->stats.shotsHit++;     
            if(health<=0)
                ((Ship*)colInfo.ptrToOwner)->stats.asteroidsKilled++;         
        }    
    }
    else if(colInfo.genType==TYPE_SHIP)
    {
        breakApart();
    }

}

void Asteroid::breakApart(void)
{

    broken=true;
    
    stage++;
    scale*=.6;
    radius = scale*.9;
//    vel = vel.findNormal();
    
    if(stage>3)
        BRect::die();
    
    //CVector2 t = makeVector2((pointOfCollision.retX()-pos.retX())*2,(pointOfCollision.retY()-pos.retY())*2,true);
    CVector2 t = pointOfCollision;
    t.isPosition(false);
    t.setMag(1);
    
    vel-=t*.4;
    speed=vel.retMag();
    //vel.setVector(t.retX(),t.retY(),false);
    
    invincibleCounter=5;
    
    if(onDeathPartGen)
    {
        onDeathPartGen->setPosition(makeVector3(pos.retX(),pos.retY(),0));
        //onDeathPartGen->makeSparks();
        onDeathPartGen->makePartRing();
    }
}

void Asteroid::init(void)
{
    PObject::init();
    scale=1;
    exist=false;
    speed=.3;
    ax=rand()%360;
    ay=rand()%360;
    az=rand()%360;
    genType=TYPE_ASTEROID;
    stage=1;
    health=7;

    broken=false;
}

// class constructor
Asteroid::Asteroid()
{
	init();
}

// class destructor
Asteroid::~Asteroid()
{
	// insert your code here
}









void AsteroidArray::setModels(Model *m, int n1, int n2)
{
    int r;
    for(int n=0 ; n<MAX_ASTEROIDS ; n++)
    {
        r = rand()%(n1-n2);
        asteroid[n].setModel(m);
    }
}

bool AsteroidArray::asteroidsAlive(void)
{
    for(int n=0 ; n<MAX_ASTEROIDS ; n++)
    {
        if(asteroid[n].retExist()==true)
            return true;
    }
    return false;
}

void AsteroidArray::startAsteroids(int n, BRect *_bounds)
{
    CVector2 pos,vel,accel;
    
    for(int i=0 ; i<nAsteroids ; i++)
        asteroid[i].die();
    
    if(n<0)
        n=0;
    if(n>=MAX_ASTEROIDS)
        n=MAX_ASTEROIDS-1;
        
    nAsteroids = n;
    bounds = *_bounds;
    
    for(int n=0 ; n<nAsteroids ; n++)
    {
        pos = makeVector2(rand()%20-10,rand()%20-10,true);
        vel = makeVector2(.2,0,false);
        vel = vel.rotate(((float)(rand()%100))/100 * 2 * M_PI);
        accel = makeVector2(1,0,false);
        accel = accel.rotate(((float)(rand()%100))/100 * 2 * M_PI);
        accel.setMag(0);
        
        asteroid[n].create(pos,vel,accel,4);
        
    }
}


void AsteroidArray::draw(void)
{
    for(int n=0 ; n<nAsteroids ; n++)
    {
        asteroid[n].draw();
    }
}

void AsteroidArray::createNew(CVector2 _pos, CVector2 _vel, CVector2 _accel, float _scale, int _stage)
{
    for(int n=0 ; n<MAX_ASTEROIDS ; n++)
    {
        if(asteroid[n].retExist()==false)
        {
            asteroid[n].create(_pos,_vel,_accel,_scale,_stage);
            if(n>=nAsteroids)
                nAsteroids=n+1;
            break;
        }
    }
}

void AsteroidArray::update(void)
{
    CVector2 pos,vel;
    float radius;
    for(int n=0 ; n<nAsteroids ; n++)
    {
        asteroid[n].update();
        
        if(asteroid[n].retBroken()==true)
        {
            asteroid[n].setBroken(false);
            if(asteroid[n].retExist()==true)
            {
                vel = asteroid[n].retVel();
                asteroid[n].setVel(vel.rotate(M_PI/10));
                createNew(asteroid[n].retPos(),asteroid[n].retVel().rotate(-M_PI/2),asteroid[n].retAccel(),asteroid[n].retScale(),asteroid[n].retStage());
                
            }
        }
        
        /*if(asteroid[n].checkColWithBRect(&bounds)==false)
        {   
            CVector2 pos = makeVector2(rand()%20-10,rand()%20-10,true);
            asteroid[n].setPos(pos);
            //CVector2 pos = asteroid[n].retPos();
            
        }*/
        pos = asteroid[n].retPos();
        radius= asteroid[n].retRadius()*1.1;
        if(pos.retX()+radius < bounds.retP1().retX() /*bounds.retPos().retX()+bounds.retTl_offset().retX()*/)
            pos.setX(bounds.retP2().retX()+radius);
        else if(pos.retX()-radius > bounds.retP2().retX() /*bounds.retPos().retX()+bounds.retBr_offset().retX()*/)
            pos.setX(bounds.retP1().retX()-radius);    
            
        if(pos.retY()+radius < bounds.retP1().retY() /*bounds.retPos().retY()+bounds.retTl_offset().retY()*/)
            pos.setY(bounds.retP2().retY()+radius);
        else if(pos.retY()-radius > bounds.retP2().retY() /*bounds.retPos().retY()+bounds.retBr_offset().retY()*/)
            pos.setY(bounds.retP1().retY()-radius);     
        asteroid[n].setPos(pos);
    }
}

void AsteroidArray::setPartGen(ParticleGenerator *pg)
{
    for(int n=0 ; n<MAX_ASTEROIDS ; n++)
    //    asteroid[n].addPartsGen(pg);
    asteroid[n].setOnDeathPartGen(pg);
}

Asteroid* AsteroidArray::retAsteroid(int n)
{
    if(n>=0 && n<MAX_ASTEROIDS)
        return &asteroid[n];
    else
        return 0;
}

void AsteroidArray::init(void)
{
    for(int n=0 ; n<MAX_ASTEROIDS ; n++)
        asteroid[n].init();
    nAsteroids=0;
}

AsteroidArray::AsteroidArray()
{
    init();
}

AsteroidArray::~AsteroidArray()
{

}
