/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef widget_def
#define widget_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "Object.h"
#include "BRect.h"

#define NA              -1
#define CB_NOT_SELECTED -1
#define CB_SELECTED     0


typedef struct
{
    float x,y;
    int b;   
}TMouse;
    
typedef struct
{
    int id;
    bool notify; 
    int value;  
}TWidgetStatus;

class Widget : public BRect
{
protected:
    int iWidgetType;
    bool bMouseOver;
    int id;             //id to identify the widget
    
public:
    virtual void draw(void);
    virtual void drawOutline(float *colour);
    virtual void update(TMouse &mouse);

    virtual void init(void);
    //void setButton(char *picture, CVector2 centre, float w, float h); 
    virtual bool checkColWithPoint(CVector2 point);

    virtual void setMouseOver(bool _bMouseOver) {bMouseOver = _bMouseOver;}
    virtual void setFont(FONT *_font) {font = _font;}
    
    virtual TWidgetStatus checkStatus(void);
    
    void notMouseOver(void) {bMouseOver=false;}
    Widget(int _id, CVector2 pos, float w, float h);
    Widget(const Widget &other);    //copy constructor
    ~Widget(void) {}

};

#endif
