/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "Widget.h"

extern FONT* agl_font;

void Widget::init(void)
{
    BRect::init();
    iWidgetType=0;
    bMouseOver=false;
}

Widget::Widget(int _id, CVector2 pos, float w, float h)
{
    init();
    id=_id;
    CVector2 tl(-w/2,h/2,true), br(w/2,-h/2,true);
    setBRect(tl,br,pos,makeVector2(0,0,false));
    iPict=-1;
}    

Widget::Widget(const Widget &other) : BRect(other)
{
    //copy the stuff from BRect
    /*tl_offset = other.tl_offset;
    br_offset = other.br_offset;
    pos = other.pos;
    vel = other.vel;
    p1 = other.p1;
    p2 = other.p2;
    slope = other.slope;
    norm = other.norm;
    angle = other.angle;
    fMass = other.fMass;
    iType = other.iType;
    iPict = other.iPict;
    projType = other.projType;
    genType = other.genType;  */
    
    //copy the stuff from Widget
    iWidgetType = other.iWidgetType;
    id = other.id;
}    

/*void Widget::setButton(char *filename,CVector2 centre, float w, float h)
{
    CVector2 tl(centre.retX()-w/2,centre.retY()-h/2,true),
             br(centre.retX()+w/2,centre.retY()+h/2,true);
             
    //setBRect(tl,br,centre,makeVector2(0,0,false));
    
    setPict(w,h,filename);
    pos = centre;
    
    iWidgetType = BUTTON;
}*/

bool Widget::checkColWithPoint(CVector2 point)
{
    CVector2 tl = pos + tl_offset,
             br = pos + br_offset;
    bool ret=false;
             
    if(point.retX() >= tl.retX() && point.retX() <= br.retX() &&
       point.retY() <= tl.retY() && point.retY() >= br.retY() )
    {
        ret=true;
    }
    
    return ret;
}

void Widget::draw(void)
{

    
    /*FONT *f;
    
    if(font!=(FONT*)NULL)
        f = font;
    else
        f = agl_font;

    glDisable(GL_LIGHTING);*/
    
    
    /*glDisable(GL_TEXTURE_2D);
    
    glBegin(GL_LINE_LOOP);

        float blue[4]={0,0,.3,1};
        glMaterialfv( GL_FRONT, GL_DIFFUSE, blue );
        glNormal3f(0,0,1);
            
        
        
        glVertex3f(pos.retX() + br_offset.retX(),pos.retY() + br_offset.retY(),0);  //bottom right
        glVertex3f(pos.retX() + br_offset.retX(),pos.retY() + tl_offset.retY(),0);  //top right
        glVertex3f(pos.retX() + tl_offset.retX(),pos.retY() + tl_offset.retY(),0);  //top left
        glVertex3f(pos.retX() + tl_offset.retX(),pos.retY() + br_offset.retY(),0);  //bottom left
        
        
        
        //glVertex3f(br_offset.retX(),br_offset.retY(),0);  //bottom right
    glEnd();*/
    float c[3]={0,0,1};
    drawOutline(c);
    

    /*glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        if(bMouseOver==true)
            allegro_gl_printf(f, tl_offset.retX()+.1, pos.retY(), 0, makeacol32(0,0,255,255), sCaption);
        else
            allegro_gl_printf(f, tl_offset.retX()+.1, pos.retY(), 0, makeacol32(0,0,155,255), "Hello");
    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);*/


//THIS BELOW IS STILL GOOD
    /*if(bMouseOver==true)
        glColor3f(1,1,1);
    else
        glColor3f(.4,.4,.4);
    
    //glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_COLOR);
    //glBlendFunc(GL_SRC_COLOR, GL_ONE);
    //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        drawPict(pos);
    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    
    glEnable(GL_LIGHTING);*/
}

void Widget::drawOutline(float *colour)
{
    glDisable(GL_TEXTURE_2D);
    
    /*if(bMouseOver)
        glBegin(GL_POLYGON);
    else*/
    glDisable(GL_LIGHTING);
    glBegin(GL_LINE_LOOP);

        /*float c[4]={colour[0],colour[1],colour[2],1};
        glMaterialfv( GL_FRONT, GL_DIFFUSE, c );
        glNormal3f(0,0,1);*/
        glColor3fv(colour);

        glVertex3f(pos.retX() + br_offset.retX(),pos.retY() + br_offset.retY(),0);  //bottom right
        glVertex3f(pos.retX() + br_offset.retX(),pos.retY() + tl_offset.retY(),0);  //top right
        glVertex3f(pos.retX() + tl_offset.retX(),pos.retY() + tl_offset.retY(),0);  //top left
        glVertex3f(pos.retX() + tl_offset.retX(),pos.retY() + br_offset.retY(),0);  //bottom left
        
        //glVertex3f(br_offset.retX(),br_offset.retY(),0);  //bottom right
    glEnd();    
    
    glEnable(GL_LIGHTING);
}    

void Widget::update(TMouse &mouse)
{
    bMouseOver = checkColWithPoint(makeVector2(mouse.x,mouse.y,true));
}

TWidgetStatus Widget::checkStatus(void)
{
    TWidgetStatus s;
    s.id=id;
    s.notify=false;
    
    return s;    
}    
   
