/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef weapon_def
#define weapon_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"
#include "Model.h"

#include "CVector2.h"
#include "Object.h"
#include "BRect.h"

#include "ParticleGenerator.h"

using namespace std;


/********DAMAGE CLASSES************/
#define ENERGY      0
#define EXPLOSIVE   1
#define PROJ_KILLER 2
#define BALLISTIC   3
#define EMP         4

#define INFINITE_LIFE   -1

typedef struct
{
    float fAccel,fMaxVel;
    float fAngAccel,fMaxAngVel;
    float fDampening,fAngDampening;
    float fMass;
    float fMusselVel;
    
    int iDamage;
    int iType;
    bool bHoming;   //does it home in on a target
    int iDamageClass;
    
    int startingLifetime;  
    //number between 0 and 1 representing how much the starting life can be modified 
    //0 means every proj's life should be equal to startLifetime 
    //1 means a proj's life could be anywhere from 0 to 2*startingLifetime
    float lifeRandomness;     
    
    int fireSound;      //sound effect for when the weapon is fired
    int deathSound;     //sound effect for when the the projectile dies
    
    Model *model;
    float fRadius;
    
    ParticleGenerator *partGen,*explosionGen;
    
    bool dieOnImpact;
    
    unsigned short int nProjectiles;
    float spread;   //number of radians between first projectile and last projectile (centred)
    
    int armor;
    
}TProjInfo;

class Weapon
{
private:

    int iCoolDown;
    char sName[30];
    TProjInfo projInfo;
    BRect hudLogo;
    
public:
    void init(void);
    void resetProjInfo(void);


    void createWeapon(char *name,int _iCoolDown, TProjInfo _projInfo, char *hudLogo_f); 

    TProjInfo retProjInfo(void) {return projInfo;}
    int retCoolDown(void) {return iCoolDown;}

    char* retName(void) {return sName;}
    void drawHudLogo(float x, float y); //assumes that the drawing mode is already set (to ortho)

    Weapon(void) {init();}
    ~Weapon(void) {}

};

#endif
