/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "Weapon.h"

void Weapon::resetProjInfo(void)
{
    projInfo.fAccel=0; projInfo.fMaxVel=0;
    projInfo.fAngAccel=0; projInfo.fMaxAngVel=0;
    projInfo.fDampening=0; projInfo.fAngDampening=0;
    projInfo.fMass=5;
    projInfo.fMusselVel=0;
    
    projInfo.iDamage=0;
    projInfo.iType=0;
    
    projInfo.bHoming=false;      //does it home
    projInfo.fRadius=1;
    projInfo.dieOnImpact=true;
    
    projInfo.nProjectiles=1;
    projInfo.spread=0;
    
    projInfo.partGen=0; projInfo.explosionGen=0;
}

void Weapon::drawHudLogo(float x, float y)
{
    hudLogo.drawPict(makeVector2(x,y,true));
}    

void Weapon::init(void)
{
    outtext(LOGFILE,"init weapon\n");
    resetProjInfo();
    iCoolDown=0;
    strcpy(sName,"");
    hudLogo.setExist(false);
}


void Weapon::createWeapon(char *name,int _iCoolDown, TProjInfo _projInfo, char *hudLogo_f)
{
    outtext(LOGFILE,"Creating Weapon: ");
    outtext(LOGFILE,name);
    outtext(LOGFILE,"\n");
    
    strcpy(sName,name);
    
    iCoolDown = _iCoolDown;
    projInfo = _projInfo;
    if(hudLogo.retExist()==false)
        hudLogo.setPict(59,59,hudLogo_f);
    
}
