/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "Turret.h" // class's header file

Turret::Turret()
{
}

Turret::Turret(TPlayerAtts _atts) : AIPlayer(_atts)
{
    
}

Turret::~Turret()
{
}

void Turret::init(void)
{
    AIPlayer::init();
    shootCounter=30;
}    

void Turret::update(int playerNum, BRect bounds)
{   
    ship.update(bounds);
    ship.turnRight();   
    
    shootCounter--;
    if(shootCounter==0)
    {
        shootCounter=30;   
    }     
}   

void Turret::findTarget(BRect **targets, int nTargets)
{
    BRect *targ=0;
    for(int n=0 ; n<nTargets ; n++)
    {
        if( targets[n]->retExist()==true && targets[n]->targetable()==true && targets[n]!=&ship && targets[n]->retGenType()==TYPE_SHIP && ship.retid()!=targets[n]->retid())
        {
            //CVector2 sp=ship.retPos() + ship.retAccel()*10;
            /*targ = fast_get_dist(ship.retPos() .retX() + ship.retAccel().retX()*10,
                            ship.retPos() .retY() + ship.retAccel().retY()*10,
                            targets[n]->retPos().retX(),
                            targets[n]->retPos().retY());*/
            targ=targets[n];
            /*if(temp < smallestDist)
            {
                smallestDist = temp;
                targ = targets[n];
            } */
            break;   
            //setTarget(targets[n]);   
        }          
    }
    //if(targ)
    setTarget(targ); 
}    

bool Turret::autoShoot(void)
{
    if(shootCounter==1)
    {
        return true;
    }    
    else
        return false;    
}    

