/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "Starfield.h"

void Starfield::init(void)
{
    for(int n=0 ; n<NUM_STARS ; n++)
    {
        star[n].setVector(rand()%400-200,rand()%400-200,-(rand()%1000));
    }
}

void Starfield::draw(void)
{
    glDisable(GL_LIGHTING);
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_BLEND);

    glBegin(GL_POINTS);
    for(int n=0 ; n<NUM_STARS ; n++)
    {
        glColor3f((star[n].z+1000)/1000,(star[n].z+1000)/1000,(star[n].z+1000)/1000);
        glVertex3f(star[n].x,star[n].y,star[n].z);
    }
    glEnd();
    
    glEnable(GL_LIGHTING);
}

void Starfield::update(float speed)
{
    for(int n=0 ; n<NUM_STARS ; n++)
    {
        star[n].z+=speed;
        //star[n].x+=speed/2;
        //star[n].y+=speed/2;
    
        if(star[n].z>=0)
        {
            star[n].z = -1000;
            //star[n].setVector(rand()%400-200,rand()%400-200,-1000);
        }
    }
}


