/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include <allegro.h>
#include <alleggl.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#ifndef standards_def
#define standards_def

#define max_parts	5000
#define MAX_PG  50  //max particle generators


#define RAD2DEG         57.295779513082320876798154814105
#define Rad2AllegroDeg  40.74366543153
#define Degree			0.0174532925199432957692369076848861	


#define LOGFILE "log.txt"

#define MAX_SHIP_ATTS 20
#define DONT_CARE   -1

int check_col_with_bitmap(BITMAP *b1, BITMAP *b2, float x1, float y1, float x2, float y2);
float get_dist(float x1,float y1,float x2,float y2);
float fast_get_dist(float x1, float y1, float x2, float y2);
void outtext(char *filename, char *info);
//int loadTexture(char *filename, bool tga=false);
int loadTexture(char *filename);

void ortho_begin(int w, int h);
void ortho_end(void);
void writeText_3D(float x, float y, float z, int colour, FONT *f,char *string);
void writeText_2D(float x, float y, float z, int colour, FONT *f,char *string);
void drawBar(float x, float y, float z, float width, float height, float percentFull, RGB c1, RGB c2);

RGB makeRGB(int r, int g, int b);
bool doText(char *buf);
float abval(float);

void setColour(float r, float g, float b, float a);

//returns the number of byes allocated for the bitmap
int size_of_bitmap(BITMAP *bmp);
#endif
