/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include <math.h>
#include <cstdio>
#include "allegro.h"
#include "Standards.h"

/*int loadTexture(char *filename, bool tga)
{
    BITMAP *temp;
    PALETTE pal;
    int iTexture;
    
    allegro_gl_begin();
		//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		
        glDisable (GL_DITHER);
        glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
        glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
    allegro_gl_end();

    if(tga==true)
        temp = load_tga(filename,NULL);
    else
        temp = load_bitmap(filename,NULL);
    
    if(temp)
    {
	   allegro_gl_begin(); 
	       iTexture = allegro_gl_make_texture_ex (AGL_TEXTURE_MASKED|AGL_TEXTURE_RESCALE  , temp, -1);
	       //iTexture = allegro_gl_make_masked_texture(temp);
	   allegro_gl_end();  
	
	   destroy_bitmap(temp);
    }
	
	return iTexture;
}*/

int loadTexture(char *filename)
{
    BITMAP *temp;
    PALETTE pal;
    int iTexture;
    
    allegro_gl_begin();
		//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
		
        glDisable (GL_DITHER);
        glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
        glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
    allegro_gl_end();

    temp = load_bitmap(filename,NULL);
    
    if(temp)
    {
    
	   allegro_gl_begin(); 
	       iTexture = allegro_gl_make_masked_texture (temp);
	   allegro_gl_end();  
	
	   destroy_bitmap(temp);
    }
	
	return iTexture;
}

float abval(float f)
{
    if(f<0)
        return -f;
    else
        return f;
}

int check_col_with_bitmap(BITMAP *b1, BITMAP *b2, float x1, float y1, float x2, float y2)
{
    int ret=0;
   /* if(x1 >= x2   &&   x1+b1->w <= x2+b2->w)
        if(y1>=y2   &&   y1+b1->h <= y2+b2->h)
            ret=1; */
    if(x1+b1->w>x2 && x1 < x2+b2->w
      && y1+b1->h>y2 && y1 < y2+b2->h)
            ret=1;

    return ret;
}

float get_dist(float x1,float y1,float x2,float y2)
{
     float tx,ty,td;
     tx=x1-x2;
     ty=y1-y2;
     tx*=tx;
     ty*=ty;
     tx+=ty;
     td=sqrt(tx);
     return(td);
}
 

float FastSqrt(float x)
{
    float xhalf = 0.5f*x;
    int i = *(int*)&x;
    i = 0x5f3759df - (i >> 1);
    x = *(float*)&i;
    x = x*(1.5f - xhalf*x*x);
    return 1/x;
}      
          
float fast_get_dist(float x1, float y1, float x2, float y2)
{
    return FastSqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
}        
    
void outtext(char *filename, char *info)
{
    FILE *fp=fopen(filename,"at");
    fprintf(fp,"%s",info);
    fclose(fp);
}

//returns the number of byes allocated for the bitmap
int size_of_bitmap(BITMAP *bmp)
{
    return (bmp->w  * bmp->h * (bitmap_color_depth(bmp)/8));
}


void ortho_begin(int w, int h)
{
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();
    glOrtho( 0, (w == 0 ? SCREEN_W : w), (h == 0 ? SCREEN_H : h), 0, -1, 1 );
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glLoadIdentity();
}


void ortho_end()
{
    glMatrixMode(GL_PROJECTION);
    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
}

void writeText_3D(float x, float y, float z, int colour, FONT *f, char *string)
{
    glDisable(GL_LIGHTING);
    
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        allegro_gl_printf(f, x, y , z, colour, string);
    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    
    glEnable(GL_LIGHTING);
}

void writeText_2D(float x, float y, float z, int colour, FONT *f, char *string)
{   
    /*glPushMatrix();
    glDisable(GL_LIGHTING);
    glScalef (16.0f, -16.0f, 16.0f);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        allegro_gl_printf(f, x, y , z, colour, string);
    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    
    glEnable(GL_LIGHTING);
    glPopMatrix();*/

    glPushMatrix();
    glDisable(GL_LIGHTING);
    glEnable(GL_TEXTURE_2D);
    glDepthMask(false);
    
    	glScalef (16.0f, -16.0f, 16.0f);
		glEnable(GL_BLEND);
    	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    	allegro_gl_printf(f, (float)x/16.0f, -(float)y/16.0f, 0, colour, string);
    	glBlendFunc(GL_ONE, GL_ZERO);
		glDisable(GL_BLEND);

		//glEnable(GL_ALPHA_TEST);
		//glAlphaFunc(GL_GREATER, 0.5f);
    	//allegro_gl_printf(f, (float)x/16.0f, -(float)y/16.0f, 0, colour, string);
		//glDisable(GL_ALPHA_TEST);
		
    glDepthMask(true);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_LIGHTING);
    glPopMatrix();
    
    
    
    //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    //glScalef(16.0f, -16.0f, 16.0f);    // to outweigh font generation
    // Pass it on, modifying x/y to fit.
    //allegro_gl_printf(f, (float)x/16.0f, -(float)y/16.0f, 0, colour, string);
    
    //glDisable(GL_DEPTH_TEST);  

    /*glDisable(GL_LIGHTING);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glDepthMask(false);
    glScalef(16.0f, -16.0f, 16.0f);    // to outweigh font generation

        glBlendFunc(GL_SRC_ALPHA, GL_ZERO); 
        allegro_gl_printf(f, (float)x/16.0f, -(float)y/16.0f, 0, colour, string);

        glBlendFunc(GL_ONE, GL_ONE); 
        allegro_gl_printf(f, (float)x/16.0f, -(float)y/16.0f, 0, colour, string);

    glDepthMask(true);
    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_LIGHTING);
    glPopMatrix();*/
    
    

}

void drawBar(float x, float y, float z, float width, float height, float percentFull, RGB c1, RGB c2)
{
    glDisable(GL_LIGHTING);    
    glDisable(GL_TEXTURE_2D);
    glDepthMask(false);
    
    glBegin(GL_QUADS);
        //glColor3f((float)c1.r/255,(float)c1.g/255,(float)c1.b/255);
        glVertex3f(x+width*percentFull,y,z);  
        glVertex3f(x+width*percentFull,y+height,z);
        glVertex3f(x,y+height,z);
        glVertex3f(x,y,z);
        
    glEnd();
   /* 
    glBegin(GL_LINE_LOOP);
        glColor3f((float)c2.r/255,(float)c2.g/255,(float)c2.b/255);
        glVertex3f(x,y,z);
        glVertex3f(x,y+height,z);
        glVertex3f(x+width,y+height,z);
        glVertex3f(x+width,y,z);
    glEnd();*/
    glDepthMask(true);
    glEnable(GL_LIGHTING);
}

RGB makeRGB(int r, int g, int b)
{
    RGB temp;
    temp.r=r; temp.g=g; temp.b=b;
    return temp;
}

bool doText(char *buf)
{
    bool ret=false;
    if(keypressed())
    {
        char key=readkey()& 0xff;
        static int cursor=0;
            
        /*if(buf[0]==0)
            cursor=0;   */
        cursor = strlen(buf); 
            
        if(key==13)     //enter
        {
            ret=true; 
        }
        else if(key==8) //backspace
        {
            cursor--;
            if(cursor<0)
                cursor=0;
            buf[cursor]=0;  
        }
        else
        {
            buf[cursor]=key;
            cursor++;
            buf[cursor]=0;
        }
    }
    return ret;
}

void setColour(float r, float g, float b, float a)
{
    float c[4]={r,g,b,a};
    glMaterialfv( GL_FRONT, GL_DIFFUSE, c );
    glMaterialfv( GL_FRONT, GL_AMBIENT, c );
    glMaterialfv( GL_FRONT, GL_SPECULAR, c );
    glMaterialfv( GL_FRONT, GL_EMISSION, c );
    
    glColor4f(r,g,b,a);
}    
