/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef SHIPSELECTOR_H
#define SHIPSELECTOR_H

#include "CVector2.h"
#include "ShipArray.h"
#include "Model.h"

#include "Widget.h" // inheriting class's header file
#include "Button.h"

#include "Game.h"

class Game;

class ShipSelector : public Widget
{
private:
    //used for displaying the demo ships
    Model *allModels;
    ShipArray *shipDefs;    
    Button *b1,*b2;       //the two buttons on the selector
    Game *game;
    
    Ship demoShip;
    float shipRot;
    int selectedShip;
    float barPercent[6];
    void setDemoShip(int n);
    
    FONT *f;
    
public:
    ShipSelector(int _id, CVector2 pos, Model *models, ShipArray *defs,Game *game, FONT *_f, TButtonAtts &ba);
    ShipSelector(const ShipSelector &other);    //copy constructor
    ~ShipSelector();
    
    void draw(void);
    void update(TMouse &mouse);
    TWidgetStatus checkStatus(void);
};

#endif // SHIPSELECTOR_H

