/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "ShipSelector.h" // class's header file

ShipSelector::ShipSelector(int _id, CVector2 pos, Model *models, ShipArray *defs, Game *game, FONT *_f, TButtonAtts &ba) : Widget(_id,pos,5,5)
{
    allModels = models;
    shipDefs = defs;  
    
    f=_f;
    
    this->game = game;
    
    b1 = new Button(1,pos+makeVector2(-2.5,-2,true),2,1,f,"<<<",ba);
    b2 = new Button(2,pos+makeVector2(2.5,-2,true),2,1,f,">>>",ba);
    

    
    selectedShip=0;
    setDemoShip(selectedShip);
    
    for(int n=0 ; n<6 ; n++)
        barPercent[n]=0;
} 
   
ShipSelector::ShipSelector(const ShipSelector &other) : Widget(other)    //copy constructor
{
    allModels = other.allModels;
    shipDefs = other.shipDefs;    
}    

ShipSelector::~ShipSelector()
{

}

void ShipSelector::setDemoShip(int n)
{
    CVector2 pos(0,0),vel(0,0);
    TShipDef def = shipDefs->retShipDef(n);
    
    demoShip.setBCirc(def.fCircRadius,pos,vel);
    //demoShip.setModel(def.sModelFilename);
    demoShip.setModel(&allModels[def.iModelNum]);
    demoShip.setAtts(def.atts);
    
    shipRot=0;
    /*pilotPic.setPict(7,10.5,def.sPilotFilename);

    
    if(iWhichPlayer==0)
        iP1Ship = n;
    else if(iWhichPlayer==1)
        iP2Ship = n;*/
}

void ShipSelector::draw(void)
{
    
    glPushMatrix();
        glTranslatef(pos.retX(),pos.retY()+1,0);
        glRotatef(shipRot,1,1,1);
        demoShip.draw();
    glPopMatrix();
    
    RGB c1={0,50,150},c2={0,100,255};
    
    writeText_3D(pos.retX()-4.5,pos.retY()-2.4  ,0,makeacol32(100,200,200,255),f,shipDefs->retShipName(selectedShip));
    
    writeText_3D(pos.retX()-5,pos.retY()-3.5   ,0,makeacol32(0,100,200,255),f,"Acceleration");
    drawBar(pos.retX(),    pos.retY()-4.5   ,0,3,.5,barPercent[0],c1,c2);
    
    writeText_3D(pos.retX()-5,pos.retY()-4.25 ,0,makeacol32(0,100,200,255),f,"Max Speed");
    drawBar(pos.retX(),    pos.retY()-5.25 ,0,3,.5,barPercent[1],c1,c2);
    
    writeText_3D(pos.retX()-5,pos.retY()-5   ,0,makeacol32(0,100,200,255),f,"Rot Thrust");
    drawBar(pos.retX(),    pos.retY()-6   ,0,3,.5,barPercent[2],c1,c2);
    
    writeText_3D(pos.retX()-5,pos.retY()-5.75 ,0,makeacol32(0,100,200,255),f,"Traction");
    drawBar(pos.retX(),    pos.retY()-6.75 ,0,3,.5,barPercent[3],c1,c2);
    
    writeText_3D(pos.retX()-5,pos.retY()-6.5  ,0,makeacol32(0,100,200,255),f,"Armor");
    drawBar(pos.retX()  ,  pos.retY()-7.5 ,0,3,.5,barPercent[4],c1,c2);
    
    writeText_3D(pos.retX()-5,pos.retY()-7.25 ,0,makeacol32(0,100,200,255),f,"Shield");
    drawBar(pos.retX() ,   pos.retY()-8.25 ,0,3,.5,barPercent[5],c1,c2);
    
    
    for(int n=0 ; n<game->getNumWeapons() ; n++){
        int col;
        if(shipDefs->retShipAtts(selectedShip).maxAmmo[n]>0)
            col = makeacol32(200,100,0,255);
        else
            col = makeacol32(75,75,0,255);
        writeText_3D(pos.retX()-5,pos.retY()-8.75 - n*.8 ,0 ,col ,f,game->getWeaponName(n));
        
    }
   // shipDefs->retShipAtts(selectedShip).maxAmmo
    
    b1->draw();
    b2->draw();
}
    
void ShipSelector::update(TMouse &mouse)
{
    Widget::update(mouse);
    b1->update(mouse);
    b2->update(mouse);
    shipRot+=1.5;
    
    if(b1->checkStatus().notify==true)
    {
        selectedShip--;
        if(selectedShip<0)
            selectedShip=/*shipDefs->retNumDefs()-1*/7; 
        setDemoShip(selectedShip);   
    }
    else if(b2->checkStatus().notify==true)
    {
        selectedShip++;
        if(selectedShip>/*shipDefs->retNumDefs()-1*/7)
            selectedShip=0;
        setDemoShip(selectedShip);
    }     
    
    TShipAtts atts = shipDefs->retShipAtts(selectedShip);  
    if(barPercent[0] < (atts.fAccel-.003)/.0074 - .02)
        barPercent[0]+=.02;
    else if(barPercent[0] > (atts.fAccel-.003)/.0074 + .02)
        barPercent[0]-=.02;
        
    if(barPercent[1] < (atts.fMaxVel-.3)/.4 - .02)
        barPercent[1]+=.02;
    else if(barPercent[1] > (atts.fMaxVel-.3)/.4 + .02)
        barPercent[1]-=.02;
        
    if(barPercent[2] < (atts.fAngAccel-.007)/.013 - .02)
        barPercent[2]+=.02;
    else if(barPercent[2] > (atts.fAngAccel-.007)/.013 + .02)
        barPercent[2]-=.02;

    if(barPercent[3] < (1-atts.fDampening )/.05 - .02)
        barPercent[3]+=.02;
    else if(barPercent[3] > (1-atts.fDampening )/.05 + .02)
        barPercent[3]-=.02;

    if(barPercent[4]*100 < atts.armor -2)
        barPercent[4]+=.02;
    else if(barPercent[4]*100 > atts.armor +2)
        barPercent[4]-=.02;
        
    if(barPercent[5]*100 < atts.shield -2)
        barPercent[5]+=.02;
    else if(barPercent[5]*100 > atts.shield +2)
        barPercent[5]-=.02;  
}   

TWidgetStatus ShipSelector::checkStatus(void)
{
    TWidgetStatus s;
    s.id=id;
    s.notify=false;
    s.value=selectedShip;
    
    return s;    
}    

