/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef shiparray_def
#define shiparray_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "Object.h"
#include "BRect.h"
#include "SObject.h"
#include "PObject.h"

#include "Weapon.h"
#include "Ship.h"

#define SHIP_ARRAY_SIZE 20


typedef struct
{
   TShipAtts atts;
   
   //char sModelFilename[30];
   int iModelNum;
   
   char sShipName[50];
   char sPilotFilename[30];
   float fCircRadius;
   char sPilotNation[50];
   char sPilotRank[50];
   char sPilotName[50];

}TShipDef;

class ShipArray
{
private:
    TShipDef shipDef[SHIP_ARRAY_SIZE];
    int iNumDefs;
    
public:
    void init(void);
    
    void addShipDef(TShipDef _def);
    TShipDef retShipDef(int n);
    
    int retNumDefs(void) {return iNumDefs;}
    char* retShipName(int n) {return shipDef[n].sShipName;}
    TShipAtts retShipAtts(int n) {return shipDef[n].atts;}
    char* retPilotRank(int n) {return shipDef[n].sPilotRank;}
    char* retPilotNation(int n) {return shipDef[n].sPilotNation;}
    char* retPilotName(int n) {return shipDef[n].sPilotName;}
    
    ShipArray(void) {init();}
    ~ShipArray(void) {}

};

#endif
