/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef ship_def
#define ship_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "CCamera.h"
#include "Object.h"
#include "BRect.h"
#include "SObject.h"
#include "PObject.h"


#include "Proj.h"
#include "Weapon.h"

#define SHIP_ARRAY_SIZE 20
#define MAX_WEAPONS 20
#define UNLIMITED_AMMO  -1

#include <vector>
using namespace std;

//#include "Game.h"
typedef struct
{
    int shotsFired;
    int shotsHit;
    int kills;   
    int shieldLostToWalls;
    int asteroidsKilled;
    int hitByAsteroid;
    int killedByAsteroid;
    int longestStreak;      //counts number of cycles since ship was last hit (divide by 32 to get seconds)
}TStats;    

typedef struct
{
    float fAccel,fMaxVel;
    float fRevAccel, fMaxRevVel;
    float fAngAccel,fMaxAngVel;
    
    float fDampening,fAngDampening;
    
    float fMass;

    int armor, shield;
    //int iWeapons[iNumWeapons];
    int weaponsSet;
    int maxAmmo[MAX_WEAPONS];   //the max ammo for each weapon
}TShipAtts;

typedef struct
{
    int maxAmmo[MAX_WEAPONS];      
}TWeaponsSet;

class Ship : public PObject
{
private:
    TShipAtts atts;
    Weapon *weapons;
    int iNumWeapons, iEquippedWeapons;
    int iCoolDownLeft;
    int armorHealth,shieldHealth;
    
    Model *shield;
    int shieldIntensity;
    
    int curWeapon;      //currently selected weapons
    char name[50];
    
    int ammoLeft[MAX_WEAPONS];      //array ammo left for each weapon
    
    int currentStreak;  //the number of cycles since the ship was last hit

public:
    TStats stats;    
    
    bool thrusting;
    void update(BRect bounds);
    void draw(bool wireframe=false);
    
    virtual CollisionInfo reactToCollision(void);
    
    void thrust(void);
    void rev(void);
    void turnRight(void);
    void turnLeft(void);
    void dampenVelocity(void);
    void dampenAngVelocity(void);
    
    void leftSpecial(void);
    void rightSpecial(void);
    
    //void shoot(Proj *proj);
    void shoot (ProjArray *pa);
    
    void reset(void);

    void setShieldModel(Model *_shield) {shield=_shield;}

    void setWeapons(Weapon *_weapons, int _iNumWeapons) { weapons = _weapons; iNumWeapons = _iNumWeapons;}
    void setAtts(TShipAtts _atts);
    void resetAtts();
    void init(void);
    void setupAmmo(vector<TWeaponsSet> *ws, int setToUse);
    
    float retArmorHealth(void) {return (float)armorHealth/(float)atts.armor*100;}
    float retSheildHealth(void) {return (float)shieldHealth/(float)atts.shield*100;}
    
    void nextWeapon(void);
    void prevWeapon(void);
    
    void drawWepHud(float x, float y);
    char *retWepName(void);
    bool retWepHoming(void);
    void setName(char *_name) {strcpy(name,_name);}
    int retAmmoLeft(void);
    bool targetable(void) {return true;}
    
    void reactToCollisionInfo(CollisionInfo &colInfo);
    void die(void);
    
    bool isDead(void) { return !exist;}
    void respawn(float x, float y);
    
    void makeInvincible(int amount);
    
    void endStreak(void);
    
    Ship(void);
    ~Ship(void);
};




#endif
