/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "Ship.h"

extern CCamera camera;

void Ship::draw(bool wireframe)
{
    PObject::draw(wireframe);
    
    if(shield && shieldHealth>0)
    {
        glPushMatrix();
        //glLoadIdentity();
        //glScalef(radius,radius,radius);
        glTranslatef(pos.retX(),pos.retY(),0);     //translate the model position
        glScalef(radius+.1,radius+.1,radius+.1);

        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA,GL_ONE);
        glDepthMask(false);
        glColor4f(.3,.3,1,((float)shieldIntensity)/100);
        
        glDisable(GL_LIGHTING);
        glDisable(GL_TEXTURE_2D);
        shield->draw();
        
        
        glEnable(GL_LIGHTING);
        glDisable(GL_BLEND);
        glDepthMask(true);
        glPopMatrix();  

    }
}

void Ship::dampenVelocity(void)
{
    if(thrusting==false)
        PObject::dampenVelocity(atts.fDampening);
}

void Ship::dampenAngVelocity(void)
{
    PObject::dampenAngVelocity(atts.fAngDampening);
}

void Ship::die(void)
{
    SfxSingleton::instance()->playSound(1);
    BRect::die();
    if(onDeathPartGen)
    {
        camera.shake(30);
        onDeathPartGen->setPosition(makeVector3(pos.retX(),pos.retY(),0));
        onDeathPartGen->makeExplosion();
    }
}

void Ship::makeInvincible(int amount)
{
    shieldIntensity=30;
    invincibleCounter=amount;
}
    

void Ship::respawn(float x, float y)
{
    //reset();
    armorHealth = atts.armor;
    shieldHealth = atts.shield;
    vel.setVector(0,1,false);
    vel.setMag(0.001);
    ang_vel=0;
    accel.setVector(0,1,false);
    accel.setMag(0);
    
    
    pos.setVector(x,y,true);
    exist=true;
    makeInvincible(50);
    
    SfxSingleton::instance()->playSound(8); //play the respawn sound
    for(int n=0 ; n<nPartGen ; n++)
    {
        if(partGen[n]->retGenAtts().respawn==true)  //triggered by respawn
        {
            partGen[n]->setPosition(makeVector3(pos.retX(),pos.retY(),0));
            partGen[n]->makePartRing();
        }
    }
}
 
void Ship::update(BRect bounds)
{
    if(exist==true)
    {
        for(int n=0 ; n<nPartGen ; n++)
        {
            if(partGen[n]->retGenAtts().damageThreshold!=-1) //its activation is based on the ships damage
            {
                if((float)armorHealth/(float)atts.armor<=partGen[n]->retGenAtts().damageThreshold)
                    partGen[n]->start();
                else
                    partGen[n]->pause();
            }
        }
        
        
        PObject::update();
        
        if(vel.retMag()>atts.fMaxVel)
            vel.setMag(atts.fMaxVel);
        if(vel.retMag()<atts.fMaxRevVel)
            vel.setMag(atts.fMaxRevVel);
            
        if(iCoolDownLeft>0)
            iCoolDownLeft--;
            
        if(shieldIntensity>0)
            shieldIntensity-=2;
            
        if(invincibleCounter>0)
            shieldIntensity=40;
     //   if((ang_vel<atts.fMaxAngVel && ang_accel>0) ||
     //  (ang_vel>-atts.fMaxAngVel && ang_accel<0))
            //ang_vel += ang_accel;
        
  //      dampenVelocity();
  //      dampenAngVelocity();
  
        //radius= asteroid[n].retRadius()*1.1;
        if(pos.retX()+radius < bounds.retP1().retX() /*bounds.retPos().retX()+bounds.retTl_offset().retX()*/)
            pos.setX(bounds.retP2().retX()+radius);
        else if(pos.retX()-radius > bounds.retP2().retX() /*bounds.retPos().retX()+bounds.retBr_offset().retX()*/)
            pos.setX(bounds.retP1().retX()-radius);    
            
        if(pos.retY()+radius < bounds.retP1().retY() /*bounds.retPos().retY()+bounds.retTl_offset().retY()*/)
            pos.setY(bounds.retP2().retY()+radius);
        else if(pos.retY()-radius > bounds.retP2().retY() /*bounds.retPos().retY()+bounds.retBr_offset().retY()*/)
            pos.setY(bounds.retP1().retY()-radius);     
        setPos(pos);
        
        currentStreak++;
        if(currentStreak>stats.longestStreak)
            stats.longestStreak=currentStreak;
    }
}

void Ship::turnRight(void)
{
    //if((ang_vel<atts.fMaxAngVel && ang_accel>=0) ||
    //    (ang_vel>-atts.fMaxAngVel && ang_accel<0))
    if(abval(ang_vel) <= atts.fMaxAngVel || ang_vel<0)
        PObject::turnRight(atts.fAngAccel);
    else
        PObject::turnRight(0);
}

void Ship::turnLeft(void)
{
    //if((ang_vel<atts.fMaxAngVel && ang_accel>=0) ||
    //    (ang_vel>-atts.fMaxAngVel && ang_accel<0))
    if(abval(ang_vel) <= atts.fMaxAngVel || ang_vel>0)
        PObject::turnLeft(atts.fAngAccel);
    else
        PObject::turnLeft(0);
}

void Ship::leftSpecial(void){
    if(atts.fDampening<=.97){
        strafeLeft(.7);
        PObject::turnLeft(0);
        dampenAngVelocity();
        turnLeft();
    }
    else
        turnLeft();

}

void Ship::rightSpecial(void){
    if(atts.fDampening<=.97){
        strafeRight(.7);
        PObject::turnRight(0);
        dampenAngVelocity();
        turnRight();
    }
    else
        turnRight();

}

/*
void Ship::shoot(Proj *proj)
{
    TProjInfo pinfo;
    if(iCoolDownLeft==0 && (ammoLeft[curWeapon]>0 || ammoLeft[curWeapon]==UNLIMITED_AMMO))
    {
        //if(weapons[0].retProjInfo().partGen!=0)
        //    weapons[0].retProjInfo().partGen->init();
        pinfo = weapons[curWeapon].retProjInfo();
        for(int n=0 ; n<pinfo.nProjectiles ; n++)
        {
            proj->create(pinfo,(PObject*)this);
            proj->setTarget(target);
        }
        iCoolDownLeft = weapons[curWeapon].retCoolDown();
        
        if(ammoLeft[curWeapon]!=UNLIMITED_AMMO)
            ammoLeft[curWeapon]--;
    }
    else if(iCoolDownLeft==0 && ammoLeft[curWeapon]==0)
    {
        curWeapon=0;
        while(ammoLeft[curWeapon]!=UNLIMITED_AMMO)
            curWeapon++;
    }
}
*/

void Ship::shoot(ProjArray *pa)
{
    TProjInfo pinfo;
    Proj *proj;
    float angle;
    float angleStepsize;

    if(curWeapon>=0 && curWeapon<MAX_WEAPONS)
    if(iCoolDownLeft==0 && (ammoLeft[curWeapon]>0 || ammoLeft[curWeapon]==UNLIMITED_AMMO))
    {
        //if(weapons[0].retProjInfo().partGen!=0)
        //    weapons[0].retProjInfo().partGen->init();
        pinfo = weapons[curWeapon].retProjInfo();
        
        angleStepsize = pinfo.spread / (float)pinfo.nProjectiles;
        angle = -pinfo.spread/2;
        
        for(int n=0 ; n<pinfo.nProjectiles ; n++)
        {
            proj=pa->retNextProj();

            proj->create(pinfo,(PObject*)this,angle);
            proj->addVel(vel);
            proj->setTarget(target);
            proj->setOwner(id,team_id,(int)this);
            
            if(n==0)    //only play the sound effect for the first proj that is fired
                proj->playFireSound();
            
            angle+=angleStepsize;
            
            stats.shotsFired++;
        }
        iCoolDownLeft = weapons[curWeapon].retCoolDown();

        
        if(ammoLeft[curWeapon]!=UNLIMITED_AMMO)
            ammoLeft[curWeapon]--;
    }
    else if(iCoolDownLeft==0 && ammoLeft[curWeapon]==0) //if this weapons is out of ammo
    {
        //find the next one with ammo left and automatically switch
        curWeapon=0;
        int c=0;
        while(ammoLeft[curWeapon]!=UNLIMITED_AMMO)
        {
            curWeapon++;
            c++;
            if(c>=MAX_WEAPONS)
                break;
        }    
    }
}

void Ship::thrust(void)
{
//.008;

    PObject::accelerate(atts.fAccel);
    thrusting=true;
}

void Ship::rev(void)
{
    PObject::accelerate(atts.fRevAccel); 
    if(atts.fRevAccel!=0)  
        thrusting=true;
}    



void Ship::reset(void)
{
    PObject::init();
    armorHealth = atts.armor;
    shieldHealth = atts.shield;
    vel.setVector(0,1,false);
    vel.setMag(0.001);
    accel.setVector(0,1,false);
    accel.setMag(0);
    
    for(int n=0 ; n<iNumWeapons ; n++)
        ammoLeft[n]=atts.maxAmmo[n];
        

    for(int n=0 ; n<iNumWeapons ; n++)
    {
        if(ammoLeft[n]>0 || ammoLeft[n]==UNLIMITED_AMMO)
        {
            curWeapon=n;
            break;
        }
    }
    
}

void Ship::setAtts(TShipAtts _atts)
{
    atts=_atts;
    setMass(atts.fMass);
    bDoesAccel=true;
    
    reset();
}

void Ship::resetAtts(void)
{
    atts.fAccel=0;
    atts.fMaxVel=0;
    
    atts.fAngAccel=0;
    atts.fMaxAngVel=0;
    
    atts.fDampening=1;
    atts.fAngDampening=1;
    
    atts.armor=1;
    atts.shield=1;
    bDoesAccel=true;
}   

void Ship::drawWepHud(float x, float y)
{
    if(iNumWeapons>0 && iEquippedWeapons>0)    
        weapons[curWeapon].drawHudLogo(x,y);
}    

char* Ship::retWepName(void)
{
    if(iNumWeapons>0 && iEquippedWeapons>0)        
        return weapons[curWeapon].retName();
    else
        return "";
}

bool Ship::retWepHoming(void)
{
    if(iNumWeapons>0 && iEquippedWeapons>0)    
        return weapons[curWeapon].retProjInfo().bHoming;
    else
        return false;    
}    

int Ship::retAmmoLeft(void)
{
    if(iNumWeapons>0 && iEquippedWeapons>0)    
        return ammoLeft[curWeapon];
    else
        return 0;
}

CollisionInfo Ship::reactToCollision(void)
{
    CollisionInfo colInfo = BRect::reactToCollision();
    colInfo.owner_id=id;
    colInfo.owner_team = team_id;
    colInfo.genType=genType;
    colInfo.projDamage=20;
    return colInfo;
}

void Ship::reactToCollisionInfo(CollisionInfo &colInfo)
{
    if(colInfo.owner_team!=team_id && invincibleCounter==0)    //only do damage if the proj is from a different team
    { 
        if(shieldHealth>0)  //if the ship still has sield left
        {
            SfxSingleton::instance()->playSound(2);     //play sound for hit on shield
            if(colInfo.shieldDamage>0)  //and the collision involves shield damage
            {
                shieldIntensity=25;
                shieldHealth-=(int)colInfo.shieldDamage;    //remove health from the shield
                endStreak();
                if(shieldHealth<=0) //now, if the shield is gone
                {
                    shieldHealth=0;
                    //play the shield-explosion sound
                    SfxSingleton::instance()->playSound(6);     //play sound for hit on shield
                    
                    //create the shield-death (shatter) particle effect
                    for(int n=0 ; n<nPartGen ; n++)
                    {
                        if(partGen[n]->retGenAtts().shieldDie==true)  
                        {
                            partGen[n]->setPosition(makeVector3(pos.retX(),pos.retY(),0));
                            partGen[n]->makePartRing();
                        }
                    }   
                    camera.shake(15);   //and skake the camera a bit
                    
                }
                
                if(colInfo.genType==TYPE_WALL)    //it is hitting a wall  
                    stats.shieldLostToWalls+=(int)colInfo.shieldDamage;  
            } 
        }
        else
        {
            if(colInfo.shieldDamage>colInfo.armorDamage && colInfo.shieldDamage>0)    //if it is an energy based weapon
                SfxSingleton::instance()->playSound(3); //play sound for energy hit on armour
            else
                SfxSingleton::instance()->playSound(4); //play sound for non-energy hit on armour
                
            if(colInfo.armorDamage>0)   //if damage was done to the armour
            {     
                armorHealth-=(int)colInfo.armorDamage;
                endStreak();
                if(armorHealth<=0)
                {
                    die();
                    armorHealth=0;
                }
            }
        } 
        
        if(colInfo.genType == TYPE_PROJ) //it was hit by an enemy projectile
        {
            if(colInfo.ptrToOwner!=0)
            {
                ((Ship*)colInfo.ptrToOwner)->stats.shotsHit++;
                
                if(armorHealth==0)
                    ((Ship*)colInfo.ptrToOwner)->stats.kills++;
            }    
        }     
        else if(colInfo.genType==TYPE_ASTEROID){
            stats.hitByAsteroid++;
            if(armorHealth==0)
                stats.killedByAsteroid++;
        } 
        
    } 
}

void Ship::setupAmmo(vector<TWeaponsSet> *ws, int setToUse)
{
    if(setToUse==DONT_CARE)
        setToUse = atts.weaponsSet;
    
    outtext(LOGFILE, "Ship::setupAmmo\n");
    iEquippedWeapons=0;    
    for(int n=0 ; n<MAX_WEAPONS ; n++)
    {
        //fscanf(fp,"%d ", &atts[n].maxAmmo[n2]);
        char buf[30];
        sprintf(buf,"  %d %d \n",(*ws)[setToUse].maxAmmo[n],setToUse);
        outtext(LOGFILE, buf);   
        atts.maxAmmo[n] = (*ws)[setToUse].maxAmmo[n];
        if(atts.maxAmmo[n]!=0)
            iEquippedWeapons++;
    }
}

void Ship::nextWeapon(void)
{
    int oldWep=curWeapon;
    if(iNumWeapons>0 && iEquippedWeapons>0)
    {
        int counter=0;
        do
        {
            curWeapon++;
            if(curWeapon>=iNumWeapons)
                curWeapon=0;
                
            counter++;
            if(counter>iNumWeapons)
                break;
            
        } while(ammoLeft[curWeapon]<=0 && ammoLeft[curWeapon]!=UNLIMITED_AMMO && oldWep!=curWeapon);
    }  
}

void Ship::prevWeapon(void)
{
    int oldWep=curWeapon;
    if(iNumWeapons>0 && iEquippedWeapons>0)
    {
        do
        {
            curWeapon--;
            if(curWeapon<0)
                curWeapon = iNumWeapons-1;
        } while(ammoLeft[curWeapon]<=0 && ammoLeft[curWeapon]!=UNLIMITED_AMMO && oldWep!=curWeapon);
    }    
}

void Ship::endStreak(void)
{
    if(currentStreak>stats.longestStreak)
        stats.longestStreak = currentStreak;
    currentStreak=0;
}    

void Ship::init(void)
{
    PObject::init();
    resetAtts();
    iNumWeapons=0;
    iCoolDownLeft=0;
    armorHealth=-1; shieldHealth=-1;
    shield=0;
    shieldIntensity=0;
    curWeapon=0;
    atts.weaponsSet=0;
    
    projType=NOT_PROJ;
    genType=TYPE_SHIP;
    
    
    for(int n=0 ; n<MAX_WEAPONS ; n++)
        ammoLeft[n]=0;
        
    currentStreak=0;
    
    stats.kills=0;
    stats.shotsFired=0;
    stats.shotsHit=0;
    stats.shieldLostToWalls=0;
    stats.asteroidsKilled=0;
    stats.hitByAsteroid=0;
    stats.killedByAsteroid=0;
    stats.longestStreak=0;
}

Ship::Ship(void)
{
    init();
    thrusting=false;
}
    
Ship::~Ship(void)
{

}
