/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef SFXSINGLETON_H
#define SFXSINGLETON_H

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#define MAX_VOICES     32

typedef struct
{
    bool inUse;
    int nVoice, nData;
}TVoice;    

class SfxSingleton
{
private:    
    DATAFILE *data;
    int nSfx;
    void countSfx(void);
    
    TVoice voice[MAX_VOICES];
    void stopVoice(int n);
    
protected:
    SfxSingleton();
    ~SfxSingleton();
    
public:
    void setData(DATAFILE *d);
    void setData(char *filename);
    void playSound(int n);
    void stopSound(int n);
    void stopAllSounds(void);
    
    static SfxSingleton* instance(void)
    {
        static SfxSingleton inst;
        return &inst;   
    }    
    
};

#endif // SFXSINGLETON_H

