/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "SfxSingleton.h" // class's header file

// class constructor
SfxSingleton::SfxSingleton()
{
    data=0;
    nSfx=0;
    
    for(int n=0 ; n<MAX_VOICES ; n++)
        voice[n].inUse=false;
}

// class destructor
SfxSingleton::~SfxSingleton()
{
    if(data)
        unload_datafile(data);
}

void SfxSingleton::setData(DATAFILE *d)
{
    /*if(data)
        unload_datafile(data);
    data = d;
    if(!data)
        outtext(LOGFILE,"Could not load sounds");
    else
        countSfx();*/
}    
void SfxSingleton::setData(char *filename)
{
    if(data)
        unload_datafile(data);
    data = load_datafile(filename);
    if(!data)
        outtext(LOGFILE,"Could not load sounds");
    else
        countSfx();
}    

void SfxSingleton::countSfx(void)
{
    nSfx=0;
    for(int n=0 ; data[n].type != DAT_END ; n++)
    {
        nSfx++;        
    }    
}   

void SfxSingleton::playSound(int n)
{
    if(n>=0 && n<nSfx)
    {
        play_sample((SAMPLE*)data[n].dat, 200, 127, 1000, false);
        /*for(int i=0 ; i<MAX_VOICES ; i++)
        {
            if(voice[n].inUse==false)
            {
                voice[n].nVoice = allocate_voice((SAMPLE*)data[n].dat);
                voice[n].inUse = true;
                voice[n].nData = n;
                
                voice_start(voice[n].nVoice);
                
                stopVoice(voice[n].nVoice);   
            }    
        } */ 
    }    
}
    
void SfxSingleton::stopSound(int n)
{
    for(int i=0 ; i<MAX_VOICES ; i++)
    {
            
    }       
}   

void SfxSingleton::stopAllSounds(void)
{
    for(int n=0 ; n<MAX_VOICES ; n++)
        stopVoice(n);
}     

void SfxSingleton::stopVoice(int n)
{
    if(n>=0 && n<MAX_VOICES)
    {
        if(voice[n].inUse==true)
        {
            release_voice(voice[n].nVoice);   
            voice[n].inUse=false;
            voice[n].nData=0;
        }     
    }    
}    

