#ifndef cserver_def
#define cserver_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <iostream>
#include <allegro.h>
#include <alleggl.h>
#include <gl\glu.h>	
#include <libnet.h>
#include "standards.h"

#include "CNetwork.h"
#include "CPacket.h"
#include "Player.h"
#include "Game.h"

#define MAX_CLIENTS 8

#ifndef QUEUE_SIZE
#define QUEUE_SIZE  100
#endif

class Client;

class Server
{
private:
    Player player[MAX_CLIENTS];
    int number_of_players;
    
    
    
    
    NET_CONN *listen_conn;
    NET_CONN *client_conn[MAX_CLIENTS];
    int number_of_clients;
    
    CNetworkConnection connection;
    CPacket packet;
    CPacket incoming;
    
    Client *local_client;
    
    Game *game;     //pointer to all of the game info
    int iNumClients;
    int iNumPlayers;
    int iPlayerNums[MAX_CLIENTS];   //a table relating client number to player number

    CPacket queue[QUEUE_SIZE];
    int iQueueSize;

public:
    void init(void);

    void closeServer(void);     //closes all open connections
    
    void sendPacket(CPacket _incoming, int from=0);
    
    Server(void) {init();}
    ~Server(void) {}
    
    
    void setGame(Game *_game) {game = _game; }
    
    void sendTo(CPacket pack, int client_num);   //sends a chunk of data to the given client
    void broadcast(CPacket pack, int notTo); //sends the chunk of data to all clients

    
    int recieve(void);   //recieves data and stores info in the given pointers
    int listen(void);          //listens for connecting clients
    
    void run(void);

    void addPlayer(char *name, int atts_num);
    
    void runText(int sender);
    
    
    void runLobby(void);
    void setLocalClient(Client *_local_client, bool _bHotSeat);
    void create(CNetworkConnection _connection);          //initializes the connections
    void update(void);
    
    //CPacket retNextPacket(void);
    void removeFromQueue(int n);
    
    void broadcastShipPositions(void);
};


#endif
