#include "Server.h"
#include "Client.h"

extern FONT* agl_font;





void Server::closeServer(void)
{
    //closes all of the clients connections
    for(int n=1 ; n<number_of_clients ; n++)
    {
        if(client_conn[n])
        {
            net_closeconn(client_conn[n]);
            client_conn[n]=(NET_CONN*)NULL;
        }
    }
    
    //closes the listening connection
    if(listen_conn)
    {
        net_closeconn(listen_conn);
        listen_conn=(NET_CONN*)NULL;
    }
}


void Server::run(void)
{
    if(listen()==1)     //there is a new connection
    {
        /*
        packet.create("join");  //create a 'join' packet to send to the client
        //adds the number assigned to the client to the packet
        packet.appendByte(number_of_clients-1);
        //sends the packet to the player
        send_to(packet.retData(),number_of_clients-1,packet.retSize());
        */
        
    }
    
    //clear the packet
    packet.init();
    int sender=0;  
    
    if(incoming.retSize()>0)    //there is a packet waiting from the local client
    {
    
        packet=incoming;
        sender=0;              //0 means it is the local client
        incoming.init();
    }
    else
    {
        //recieve new data, storing it in the packet, and recording the sender
       // packet.setSize(recieve(packet.retData(),&sender));
    } 
    
    if(packet.retSize()>0)  //if a packet was recieved
    {
        if(packet.checkPacket("ReJo")==1)  //check to see if a request to join has been recieved
        {
            char name[30];
            int length=packet.getNextByte();
            for(int n=0 ; n<length ; n++)
                name[n]=packet.getNextByte();
                
            int atts_num=packet.getNextByte();     //represents the ship the player has choosen
                
            addPlayer(name,atts_num);    
                
            //create a new packet holding the number assigned to the client
            packet.create("You");
            packet.appendByte(sender);
            //send it back to the client
            sendTo(packet,sender);
        }
        else if(packet.checkPacket("text")==1)
        {
            runText(sender);    //handels the recieving and broadcasting of any messages      
        }    
    }
}


void Server::runText(int sender)
{
    static char message[1024]="";

    int name_length=strlen(player[sender].retName());           //length of the name of the sender
    int message_length=packet.getNextByte() + name_length +2;   //length of the name of the sender plus the length of the actual message plus 2 extra for the colon and space
            
    char *name = player[sender].retName();  //get the name of the player that sent the message
    
    //clear the buffer for the outgoing message
    for(int n=0 ; n<1024 ; n++)
        message[n]=0;
    
    int n;
    //add the name of the sender to the message
    for(n=0 ; n<name_length ; n++)
        message[n]=name[n];
        
    //add the colon and the space
    message[n]=':';
    message[n+1]=' ';
    n+=2;

    //add the recieved message (from the packet) to the outgoing message
    for(; n<message_length ; n++)
        message[n]=packet.getNextByte();
    message[n+1]=0;
            
    //create a new packet with this new message in it, and broadcast that    
    packet.create("text");
    packet.appendByte(message_length+1);
    for(n=0 ; n<message_length+1 ; n++)
        packet.appendByte(message[n]);
                    
    //broadcast(packet);
}
/*
void Server::runLobby(void)
{
    static char message[1024]="";
    static int cursor=0;
    
    run();

    
    glEnable(GL_TEXTURE_2D);
        allegro_gl_printf(agl_font, 0, -3, 0, makecol(0, 255, 255), "%s",message);
    glDisable(GL_TEXTURE_2D);
}
*/


void Server::addPlayer(char *name, int atts_num)
{
    if(number_of_players<MAX_CLIENTS)
    {
//        player[number_of_players].create(name,atts_num);
        
        CVector2 pos;
        
        
        if(number_of_players==0)
            pos.setVector(-5,-5,true);
        else
            pos.setVector(5,5,true);
            
        CVector2 vel(0,0,false),accel(-1,0,false);
        
//        player[number_of_players].setPosition(pos,vel,accel);
        
        number_of_players++;
    
    }
}













void Server::sendTo(CPacket pack, int client_num)   //sends a chunk of data to the given client
{
    if(client_num==0 || client_num==1)    //the local client
    {
        pack.setSender(client_num);
        local_client->sendPacket(pack);   
    }
    else if(client_conn[client_num])
        net_send_rdm(client_conn[client_num],pack.retData(),pack.retSize());
}

void Server::broadcast(CPacket pack, int notTo) //sends the chunk of data to all clients
{
    for(int n=2 ; n<iNumClients ; n++)
    {
        if(client_conn[n] && n!=notTo)
            net_send_rdm(client_conn[n],pack.retData(),pack.retSize());
    }
 //   local_client->sendPacket(pack);
}


void Server::init(void)
{
    number_of_clients=0;
    number_of_players=0;
    
    
    
    
    listen_conn=(NET_CONN*)NULL;
    for(int n=2 ; n<MAX_CLIENTS ; n++)
        client_conn[n]=(NET_CONN*)NULL;
    
    for(int n=0 ; n<MAX_CLIENTS ; n++)
        iPlayerNums[n]=0;
        
    iNumPlayers=0;
    iNumClients=2;      //two clients for two possible players on the host computer
    
    for(int n=0 ; n<QUEUE_SIZE ; n++)
        queue[n].init();
   iQueueSize=0;
}

//recieve data
//returns the size of the recieved data
int Server::recieve(void)
{
    int data_length=0;
    char data[1024];

/*    
    if(local_client)
    {
        if(incoming.retSize()>0)    //there is an incoming packet waiting
        {

                if(iQueueSize<QUEUE_SIZE)
                {
                    queue[iQueueSize] = incoming;
                    queue[iQueueSize].setSender(0);
                    iQueueSize++;
                }
                
                incoming.init();
                
            }
        }
    }
*/    
    //start at 1 because client 0 is the local client
    for(int n=2 ; n<iNumClients ; n++)
    {
        //go through all of the clients and check of incoming data
        //if any is found, store it in the passed array
        if(client_conn[n])
        {

            data_length=net_receive_rdm(client_conn[n], data, 1024);
            if(data_length>0)
            {   
                if(iQueueSize<QUEUE_SIZE)
                {
                    queue[iQueueSize].setData(data,data_length);
                    queue[iQueueSize].setSender(n);
                    iQueueSize++;
                }
                
                //*sender = n;
                //return data_length;
            }
        }
    }
    return 0;
}

void Server::sendPacket(CPacket _incoming, int from)
{
    //incoming=_incoming;
    if(iQueueSize<QUEUE_SIZE)
    {
        _incoming.setSender(from);
        queue[iQueueSize] = _incoming;
        iQueueSize++;
    }
}

//returns 1 when a new connection is made
//        0 when no new connection
int Server::listen(void)
{
    NET_CONN* new_conn = (NET_CONN*)NULL;
 
    //listen on the listening connection, and, if a connection is being made
    //store the new connection in new_conn   
    new_conn = net_poll_listen(listen_conn);
    
    //if a new connection has been made
    if(new_conn)
    {
        //store it in the next client connection spot
        if(iNumClients>=0 && iNumClients<MAX_CLIENTS)
        {
            client_conn[iNumClients] = new_conn;
            iNumClients++;
        }
        return 1;
    }
    
    return 0;
}


void Server::runLobby(void)
{
    CPacket recieved;
    listen();   //listens for incoming connetions
    
    char d[1028];
    int size;
    
    packet.init();
    
    //recives any incoming packets and stores the data in the char array 'data'
    //and records the number of the sender
    //size = recieve(d,&sender);  
    recieve();
    //recieved = retNextPacket();
    
    for(int n=0 ; n<iQueueSize ; n++)
    {
        recieved = queue[n];
        if(recieved.retSize()>0)     //a packet was recieved
        {
        // packet.setData(d,size);
            if(recieved.checkPacket("ReJo")==1)   //a rejo packet has been recieved
            {
                outtext(LOGFILE,"A ReJo packet has been recieved by the server\n");
            
                packet.init();
                unsigned char iPlayerNum = (unsigned char)game->addPlayer();
                char text[30];
                sprintf(text,"Player added to server-side game, assigned number: %d\n",iPlayerNum);            
                            
            
                //set the sender's player num in the table
                iPlayerNums[recieved.retSender()] = iPlayerNum;
            
                //create the packet
                packet.create("You");
            
                //attach the player's number to the packet
                packet.appendByte(iPlayerNum);
            
                sprintf(text,"  sender: %d\n\n",recieved.retSender());
                outtext(LOGFILE,text);
            
                //send the packet with his player num back to the sender
                sendTo(packet,recieved.retSender());
            
                /*if(recieved.retSender()!=0)
                {
                    packet.create("add");
                    packet.appendByte(0);
                    sendTo(packet,recieved.retSender());
                
                    packet.create("atts");
                    TPlayerAtts atts = (game->retPlayer(0))->retPlayerAtts();
                    packet.appendByte(atts.iShipNum);
                    packet.appendByte(0);
                    sendTo(packet,recieved.retSender());
                }*/
                for(int i=0 ; i<recieved.retSender() ; i++)
                {
                    packet.create("add");
                    packet.appendByte(iPlayerNums[i]);
                    sendTo(packet,recieved.retSender());
                    
                    packet.create("atts");
                    TPlayerAtts atts = (game->retPlayer(iPlayerNums[i]))->retPlayerAtts();
                    packet.appendByte(atts.iShipNum);
                    packet.appendByte(iPlayerNums[i]);
                    sendTo(packet,recieved.retSender());
                }
            
                packet.create("add");   //an add player packet
                packet.appendByte(iPlayerNum);
                broadcast(packet,recieved.retSender());
            
                removeFromQueue(n);
            //  while(!key[KEY_ENTER]){}
            }
           /* else if(recieved.checkPacket("ReJ2")==1)
            {
                for(int n=0 ; n<2 ; n++)
                {
                    packet.init();
                    unsigned char iPlayerNum = (unsigned char)game->addPlayer();
            
                    //set the sender's player num in the table
                    iPlayerNums[recieved.retSender()] = iPlayerNum;
            
                    //create the packet
                    packet.create("You");
            
                    //attach the player's number to the packet
                    packet.appendByte(iPlayerNum);
            
                    char text[20];
                    sprintf(text,"Sender: %d\n\n",recieved.retSender());
                    outtext(LOGFILE,text);
            
                    //send the packet with his player num back to the sender
                    sendTo(packet,recieved.retSender());
                }
            }*/
            else if(recieved.checkPacket("atts")==1)  //a packet with player atts has been recieved
            {
                outtext(LOGFILE,"A packet with player atts has been revieved by the server\n");
                TPlayerAtts atts;
            
                strcpy(atts.sName,"");
                
                //get the pertinent atts from the packet
                atts.iColour=0;
                atts.iShipNum=recieved.getNextByte();
            
                packet=recieved;
            
                //set the player's atts in the game
                game->setPlayerAtts(iPlayerNums[recieved.retSender()],atts);
            
                //send the information out to all of the clients
                packet.appendByte(iPlayerNums[recieved.retSender()]);
                broadcast(packet,recieved.retSender());
            
                packet.init();
                
                removeFromQueue(n);
            }
        }
    }
}

void Server::setLocalClient(Client *_local_client, bool _bHotSeat) 
{
    outtext(LOGFILE,"Server::setLocalClient\n");
    local_client = _local_client;
    game->bHotSeat = _bHotSeat;
}

void Server::create(CNetworkConnection _connection)
{
    outtext(LOGFILE,"Creating Server\n");
    connection=_connection;
    
    //open an listening connection
    listen_conn = net_openconn(connection.retNetworkDriver(), "");
    
    net_listen(listen_conn);    //start listening on the listen connection
}


void Server::update(void)
{
    char d[1028];
    int size;
    CPacket recieved;
    bool thrustingForward=false;
    bool turning=false;
    
    packet.init();
    
    //recives any incoming packets and stores the data in the char array 'data'
    //and records the number of the sender
    
    //size = recieve(d,&sender);
    recieve();
    
    //recieved = retNextPacket();
    
    for(int n=0 ; n<iQueueSize ; n++)
    {
        recieved = queue[n];
        int sender = recieved.retSender();
    
        //if(size>-1) 
        //   packet.setData(d,size);
    
        if(recieved.checkPacket("keys")==1)   //a keypress packet has been recieved
        {
            //while(!key[KEY_ENTER]){}
    
            unsigned char k=0;
            int iPlayerNum = iPlayerNums[sender];
            Ship *ship = game->retShip(iPlayerNum);
    
           /* char info[200];
            sprintf(info,"Sender: %d \n\n",sender);
            outtext(LOGFILE,info);*/
    
            if(iPlayerNum!=0)
            {
                thrustingForward=false;
                turning=false;
            
                k = recieved.getNextByte();
                while(k!='X')
                {
                
                    /*char info[200];
                    sprintf(info,"Player Num: %d, %c \n\n",iPlayerNum,k);
                    outtext(LOGFILE,info);*/
                
                    if(k=='u')
                    {
                        ship->thrust();
                        thrustingForward=true;
                    }
                    
                
                    //k = recieved.getNextByte();
                    if(k=='l')
                    {
                        ship->turnLeft();
                        turning=true;
                    }
                    else if(k=='r')
                    {
                        ship->turnRight();
                        turning=true;
                    }

                    if(k=='s')     //shoot
                        ship->shoot(/*game->retNextProj()*/game->retProjArray()); 
                    
                    if(k=='n')
                        ship->nextWeapon();
                    
                    k = recieved.getNextByte();   
                }
                
                if(thrustingForward==false)
                    ship->dampenVelocity();
                if(turning==false)
                    ship->dampenAngVelocity();
            }
            removeFromQueue(n);
        }
    }
}

/*
CPacket Server::retNextPacket(void)
{
    CPacket ret;
    ret.init();
    if(iQueueSize>0)
    {
        ret = queue[0];
        for(int n=1 ; n<iQueueSize ; n++)
        {
            queue[n-1] = queue[n];
        }
        iQueueSize--;
    }
    
    return ret;
}*/

void Server::removeFromQueue(int n)
{
    for(int i=n+1 ; i<iQueueSize ; i++)
    {
        queue[i-1] = queue[i];
    }
    iQueueSize--;
}

void Server::broadcastShipPositions(void)
{
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        Player *player;
        player = game->retPlayer(n);
        if(player)
        {
        if(player->retExist()==true)
        {
            Ship *ship = game->retShip(n);
            
            packet.create("sPos");
            packet.appendByte((unsigned char)n);
            packet.appendFloat(ship->retPos().retX());
            packet.appendFloat(ship->retPos().retY());
            packet.appendFloat(ship->retVel().retX());
            packet.appendFloat(ship->retVel().retY());
            packet.appendFloat(ship->retVel().retMag());
            packet.appendFloat(ship->retAccel().retX());
            packet.appendFloat(ship->retAccel().retY());
            packet.appendFloat(ship->retAccel().retMag());
            
            broadcast(packet,0);
            packet.init();
        }
        }
    }
}
