/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef SCOREKEEPER_H
#define SCOREKEEPER_H

#define SCORE_BASED 0
#define INCREASING_TIME 1
#define DECREASING_TIME 2
#define NO_SCORE    3

#define MAX_SCORE_PAGES 20

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <allegro.h>
using namespace std;

typedef struct{
    char *name;
    int score;    
}TScoreEntry;

typedef struct{
    TScoreEntry scores[10];
    int sortType;
    char pageName[25];
}TScorePage;


class ScoreKeeper
{
private: 
    int score[2];   //score for player 1 and 2
    int score_inc;
    float multiplier[2];   
    float multiplier_decay, multiplier_inc;
    int timeLeft;
    int type;
    
    
    TScorePage scorePages[MAX_SCORE_PAGES];
    int nScorePages;
    
    int loadPagesCallback(const char *filename, int attrib, void *param);
protected:
    ScoreKeeper();
    ~ScoreKeeper();
    
public:
    static ScoreKeeper* instance(void)
    {
        static ScoreKeeper inst;
        return &inst;
    } 
    
    void init(void);
    void reset(int _type);
    
    void setType(int _type);
    int getType(void);
    
    void incScore(int player);
    int getScore(int player);
    void setScoreInc(int amount);
    
    void setTimeLeft(int amount);
    int getTimeLeft(void);
    
    int incMultiplier(int player);
    float getMultiplier(int player);
    void setMultiplierInc(float inc);
    void setMultiplierDecay(float decay);
    void addToMultiplier(float amount, int player);
    void setMultiplier(float amount, int player);
    int getLastScoreInc(int player);
    
    void update(void); 
    
    void loadAllScorePages();
    void saveScorePage(char *page);  
};

#endif

