/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "ScoreKeeper.h" // class's header file

ScoreKeeper::ScoreKeeper()
{
    init();
}

ScoreKeeper::~ScoreKeeper()
{
}

void ScoreKeeper::init(void)
{
    score[0]=0;
    score[1]=0;
    score_inc=1;
    multiplier[0]=1;
    multiplier[1]=1;
    multiplier_inc=.1;
    multiplier_decay=.1;
    timeLeft=0;
    nScorePages=0;
}    

void ScoreKeeper::setType(int _type)
{
    type = _type;    
}

int ScoreKeeper::getType(void)
{
    return type; 
}        

void ScoreKeeper::reset(int _type)
{
    init();
    setType(_type);    
}    

void ScoreKeeper::setScoreInc(int amount)
{
    score_inc = amount;
}    

void ScoreKeeper::incScore(int player)
{
    if(player==0 || player==1)
    {
        score[player]+=(int)((float)score_inc*multiplier[player]);
    }    
}    

int ScoreKeeper::getLastScoreInc(int player)
{
    return (int)((float)score_inc*multiplier[player]);
}    

int ScoreKeeper::getScore(int player)
{
    if(player==0 || player==1)
        return score[player];
    else
        return 0;
} 

int ScoreKeeper::incMultiplier(int player)
{
    if(player==0 || player==1)
        multiplier[player]+=multiplier_inc;
}
    
float ScoreKeeper::getMultiplier(int player)
{
    if(player==0 || player==1)
        return multiplier[player];
    else
        return 0;
}    

void ScoreKeeper::setMultiplierInc(float inc)
{
    multiplier_inc = inc;
}    
   
void ScoreKeeper::setMultiplierDecay(float decay)
{
    multiplier_decay = decay;
}    
   
void ScoreKeeper::addToMultiplier(float amount, int player)
{
    if(player==0 || player==1)
    {
        multiplier[player]+=amount;
        if(multiplier[player]<1)
            multiplier[player]=1;
    }    
} 

void ScoreKeeper::setMultiplier(float amount, int player)
{
    if(player==0 || player==1)
    {
        multiplier[player]=amount;
        if(multiplier[player]<1)
            multiplier[player]=1;
    }    
}    
   
void ScoreKeeper::setTimeLeft(int amount)
{
    if(amount>=0)
        timeLeft = amount;
}
    
int ScoreKeeper::getTimeLeft(void)
{   
    return timeLeft;
}    
    
void ScoreKeeper::update(void)
{
    if(type==DECREASING_TIME)
    {
        if(timeLeft>0)
            timeLeft--;   
    }
    else if(type==INCREASING_TIME)
    {
        timeLeft++;
    }     
    
    if(type==SCORE_BASED)
    {
        for(int i=0 ; i<2 ; i++)
        {
            if(multiplier[i]>1)
                multiplier[i]-=multiplier_decay;
            if(multiplier[i]<1)
                multiplier[i]=1;
        }    
    }          
}    

int ScoreKeeper::loadPagesCallback(const char *filename, int attrib, void *param){
    FILE *fp = fopen(filename,"rt");
    if(fp){
        strcpy(scorePages[nScorePages].pageName,filename);
        
        fscanf(fp,"%d",&scorePages[nScorePages].sortType);
        for(int n=0 ; n<10 ; n++){
            fscanf(fp,"%s",scorePages[nScorePages].scores[n].name);
            fscanf(fp,"%d",&scorePages[nScorePages].scores[n].score);
        }
        nScorePages++;
        nScorePages%=MAX_SCORE_PAGES;
    }
    return 0;
}

void ScoreKeeper::loadAllScorePages(){

//    int count = for_each_file_ex("scores/*", FA_DIREC,
//				  0, this->loadPagesCallback, 0);

}

void ScoreKeeper::saveScorePage(char *page){
}
