/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef sobject_def
#define sobject_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "Object.h"
#include "BRect.h"
#include "Model.h"

#include "Animation.h"

using namespace std;

typedef struct
{
    bool bCol;
}TColInfo;

class SObject : public BRect
{
protected:
    Model *model;    bool bHasModel;
    int invincibleCounter;
    
public:
    void draw(bool wireframe=false);
    void update(void);
    
    void setModel(Model *_model);

    TColInfo checkColWithSObject(SObject *ob);
    void reactToCollision(TColInfo colInfo) { /*a static object does nothing*/ } 

    SObject(void);
    //SObject(char *sModelFilename);
    ~SObject(void);

};


#endif
