/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef proj_def
#define proj_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"
#include "SfxSingleton.h"
#include "GameSettingsSingleton.h"

#include "CVector2.h"
#include "CCamera.h"
#include "Object.h"
#include "BRect.h"
#include "Weapon.h"
#include "SObject.h"
#include "PObject.h"

#define MAX_PROJS   200

using namespace std;

class Proj : public PObject
{
private:
    TProjInfo info;
    int owner_id, owner_team;
    
    int dieCounter; //counter for homing missiles to die when they have no target
    int armor;      //for non-energy projectiles
    int lifetime;   //some projectiles will cease to exist when their life runs out    

    int ptrToOwner;

public:
    void init(void);
    void create(TProjInfo _info, CVector2 _pos, CVector2 _vel, CVector2 _accel);
    void create(TProjInfo _info, PObject *shooter, float offsetAng=0);
    void destroy(void);
    
    void home(void);

    CollisionInfo reactToCollision(void);
    void reactToCollisionInfo(CollisionInfo &colInfo);

    void setOwner(int _owner_id, int _owner_team, int ptr) {owner_id=_owner_id; owner_team = _owner_team; ptrToOwner = ptr;}
    int retOwnerId(void) {return owner_id;}
    int retOwnerTeam(void) {return owner_team; }
    int retPtrToOwner(void) {return ptrToOwner; }
    
    void update(BRect bounds);
    void draw(bool wireframe=false);
    
    CVector3 setPartGenPos(void);

    void die(void);
    void addVel(CVector2 nv) {vel+=nv;}

    Proj(void) {init();}
    ~Proj(void) {}
    
    void playFireSound(void);

};


class ProjArray
{
private:
    Proj projs[MAX_PROJS];    
    int iNumProjs;
    
public:
    ProjArray();
    ~ProjArray();
    
    void init(void);
    Proj* retProj(int n);
    Proj* retNextProj(void);
};

#endif
