/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef POWERUP_H
#define POWERUP_H

#include "SfxSingleton.h"
#include "GameSettingsSingleton.h"

#include "CVector2.h"
#include "CCamera.h"
#include "Object.h"
#include "BRect.h"
#include "Arena.h"
#include "Weapon.h"
#include "SObject.h"
#include "PObject.h"

#define MAX_POWERUPS  20

#define POWERUP_TYPE_INVINCIBILITY 1

typedef struct TPowerupInfo{
    ParticleGenerator *partGen,*explosionGen;
    Model *model;
    float fRadius;
    float fMass, fDampening;
    
    int startingLifetime;  
    //number between 0 and 1 representing how much the starting life can be modified 
    //0 means every proj's life should be equal to startLifetime 
    //1 means a proj's life could be anywhere from 0 to 2*startingLifetime
    float lifeRandomness; 
    
    int createSound;      //sound effect for when the powerup is created
    int deathSound;     //sound effect for when the the powerup dies
    
    int iType;
    
    int spawnChance;       //likelyhood of this powerup being spawned, 0=none, 100=very high
    
}TPowerupInfo;

typedef struct TPowerupInfoArray{
    TPowerupInfo *infoArray;
    int size;    
}TPowerupInfoArray;

class Powerup : public PObject
{
private:
    TPowerupInfo info;
    int lifetime;
    int powerupType;
    
public:
    Powerup();
	~Powerup();
	void init();
	
	void create(TPowerupInfo _info, CVector2 _pos);
	void draw(bool wireframe=false);
	void update(void);
	CollisionInfo reactToCollision(void);
    void reactToCollisionInfo(CollisionInfo &colInfo);
    void die(void);
};


class PowerupArray
{
private:
    Powerup powerups[MAX_POWERUPS];    
    int iNumPowerups;
    int placeCounter, placeCounterMax;
    
public:
    PowerupArray();
    ~PowerupArray();
    
    void init(void);
    Powerup* retPowerup(int n);
    Powerup* retNextPowerup(void);
    void draw(void);
    void update(void);
    void placePowerup(Arena *arena, TPowerupInfoArray *infoArray);
    
};

#endif // POWERUP_H
