/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "Powerup.h" // class's header file

Powerup::Powerup()
{
    init();
}

// class destructor
Powerup::~Powerup()
{
}

void Powerup::init(void){
    PObject::init();
    exist=false;    
}

void Powerup::create(TPowerupInfo _info, CVector2 _pos)
{
    outtext(LOGFILE,"Creating\n");
    init();  
    exist=true;  
    info = _info;
    
    setBCirc(info.fRadius,_pos,makeVector2(0,0,true));
  
    setMass(info.fMass);
    accel.setVector(1,0,false);
    accel.setMag(0);
    vel = accel;
    bDoesAccel=true;

    if(info.partGen)
        addPartsGen(info.partGen);
    if(info.explosionGen)
        setOnDeathPartGen(info.explosionGen);
        
    lifetime = info.startingLifetime;
    if(info.lifeRandomness!=0)
        lifetime += (int)(info.startingLifetime/2) - (int)(((float)(rand()%info.startingLifetime)) * info.lifeRandomness); //modify it by the randomness factor
 
    setModel(_info.model);
    
    
    powerupType = info.iType;   
    outtext(LOGFILE,"Created\n");
}

void Powerup::draw(bool wireframe){
    PObject::draw(wireframe);
}

void Powerup::update(void){
    PObject::update();
    PObject::dampenVelocity(info.fDampening);
    
    if(lifetime>0){
        lifetime--;
        if(lifetime==0)
            die();
    }
}

CollisionInfo Powerup::reactToCollision(void)
{
    CollisionInfo colInfo;
    
    /*if(info.iDamageClass==ENERGY)
    {
        colInfo.armorDamage=(float)info.iDamage*.75;
        colInfo.shieldDamage=(float)info.iDamage;
        colInfo.projDamage=colInfo.armorDamage;
    }
    else if(info.iDamageClass==EXPLOSIVE)
    {
        colInfo.armorDamage=(float)info.iDamage;
        colInfo.shieldDamage=(float)info.iDamage*.75;
        colInfo.projDamage=colInfo.armorDamage;
    }
    else if(info.iDamageClass==PROJ_KILLER)
    {
        colInfo.armorDamage=(float)info.iDamage*.5;
        colInfo.shieldDamage=(float)info.iDamage*.5;
        colInfo.projDamage=(float)info.iDamage*10;
    }    
    else if(info.iDamageClass==BALLISTIC)
    {
        colInfo.armorDamage=(float)info.iDamage;
        colInfo.shieldDamage=(float)info.iDamage;
        colInfo.projDamage=colInfo.armorDamage*3;        
    }    
    else if(info.iDamageClass==EMP)
    {
        colInfo.armorDamage=0;
        colInfo.shieldDamage=(float)info.iDamage;
        colInfo.projDamage=(float)info.iDamage;  
    }    

    colInfo.owner_id = owner_id;
    colInfo.owner_team = owner_team;
    colInfo.genType=genType;
    colInfo.ptrToOwner = ptrToOwner;*/
    
    return colInfo;
}

void Powerup::reactToCollisionInfo(CollisionInfo &colInfo)
{
    if( colInfo.genType==TYPE_SHIP )
        die();
}

void Powerup::die(void)
{
    SfxSingleton::instance()->playSound(info.deathSound);
    BRect::die();
    if(onDeathPartGen)
    {
        onDeathPartGen->setPosition(makeVector3(pos.retX(),pos.retY(),0));
        onDeathPartGen->makeSparks();
    }
}















PowerupArray::PowerupArray(){
    init();
}

PowerupArray::~PowerupArray(){
}
    
void PowerupArray::init(void){
    iNumPowerups=0;
    for(int n=0 ; n<MAX_POWERUPS ; n++)
        powerups[n].init();
        
    placeCounterMax=600;
    placeCounter = placeCounterMax/3;
}

Powerup* PowerupArray::retPowerup(int n){
    if(n>=0 && n<MAX_POWERUPS)
        return &powerups[n];
    else
        return &powerups[0];
}

Powerup* PowerupArray::retNextPowerup(void){
    Powerup *ret=0;
    int n;
    for(n=0 ; n<MAX_POWERUPS ; n++)
    {
        if(powerups[n].retExist()==false)
        {
            ret = &powerups[n];
            break;
        }
    }
    if(n>=iNumPowerups)
        iNumPowerups = n;
        
    if(ret==0)
        ret = &powerups[0];
    return ret;
}

void PowerupArray::draw(void){
    for(int i=0 ; i<MAX_POWERUPS; i++){
        if(powerups[i].retExist()==true)
            powerups[i].draw();
    }
}

void PowerupArray::update(void){
    for(int n=0 ; n<MAX_POWERUPS ; n++)
    {
        if(retPowerup(n)!=0 && retPowerup(n)->retExist()==true)
            retPowerup(n)->update();
    }
}

void PowerupArray::placePowerup(Arena *arena, TPowerupInfoArray *infoArray){
    if(placeCounter>0){
        placeCounter--;
    }
    else{
        placeCounter = placeCounterMax;
        
        float x,y;
        float vr,hr;
        vr = rand()%100;
        hr = rand()%100;
        
        vr/=100;
        hr/=100;
        
        x = arena->retP1().retX()+3 + (arena->retP2().retX()-arena->retP1().retX())*hr-6;
        y = arena->retP1().retY()+3 + (arena->retP2().retY()-arena->retP1().retY())*vr-6;
        
        Powerup *p = retNextPowerup();
        if(p){
            int r = rand()%infoArray->size;
            p->create(infoArray->infoArray[r],makeVector2(x,y,true));
            /*for(int n=0 ; n<infoArray->size ; n++){
                
            }*/
        }
    }
}
