/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef player_def
#define player_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>

#include "Standards.h"
#include "ScoreKeeper.h"
#include "GameSettingsSingleton.h"
#include "BRect.h"
#include "Controller.h"
#include "Ship.h" 
#include "ParticleGenerator.h"


#define RED     0
#define GREEN   1
#define BLUE    2
#define YELLOW  3

typedef struct
{
    char sName[30];
    unsigned char iColour;
    unsigned char iShipNum;
    int starting_lives;
    float startX, startY;
}TPlayerAtts;

class Player
{
protected:
    TPlayerAtts atts;
    Ship ship;
    Controller controller;
    bool bExist;
    int respawnCounter;
    int id,team_id;             //player num
    
    float retAngle;
    int targTime;        //how long the target has been in place
    int lives;

    void drawTargetRet(int playerNum);
    
    BRect hudl,hudr;
    float p1s,p1a,p2s,p2a;
    ParticleGenerator *shieldParts, *armourParts;

public:
    void setPlayer(TPlayerAtts _atts) { atts = _atts; bExist=true; lives=atts.starting_lives; }
    void setShipAtts(TShipAtts _atts) { ship.setAtts(_atts); }
    void setShip(Ship _ship) { ship = _ship;     ship.setid(id,team_id); }
    void setWeapons(Weapon *weapons, int iNumWeapons) {ship.setWeapons(weapons,iNumWeapons);}
    
    virtual void draw(void);
    virtual void update(int playerNum, BRect bounds);
    virtual void drawHUD(void);
    virtual void drawHotSeatHUD(int playerNum);
    virtual bool autoShoot(void)    {return false;}
    void drawScore(bool hotseat);
    
    void create(void) {init(); bExist=true; lives=atts.starting_lives;}
    
    char* retName(void) {return atts.sName;}
    bool retExist(void) {return bExist;}
    Ship* retShip(void) {return &ship;}
    virtual Ship* retShipForObjectList(void) {return &ship;}
    TPlayerAtts retPlayerAtts(void) {return atts;}
    int retLives(void) {return lives;}
    
    virtual void init(void);
    
    virtual bool isDead(void) {return ship.isDead();}
    virtual void startRespawnCounter(void);
    virtual void respawn(int playerNum);
    
    void setid(int _id, int _team_id);
    int retid(void) {return id;}
    
    void adjustHudBars(float x, float y,float width, float height);
    void setHudPartGens(ParticleGenerator *a,ParticleGenerator *s);   
    
    virtual void setTarget(BRect* target) {ship.setTarget(target);}
    virtual void findTarget(BRect **targets, int nTargets);
    
    Player(void) { init(); hudl.setExist(false); hudr.setExist(false);}
    Player(TPlayerAtts _atts) { init(); setPlayer(_atts); }
    
    void drawBar2D(float x, float y, float z, float width, float height, float percentFull, RGB c1, RGB c2,ParticleGenerator* pg);
    
    ~Player(void) {}
};


#endif
