/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "Player.h"
#include "CCamera.h"


extern FONT* agl_font;
extern FONT* allFonts[20];
extern CCamera camera;


void Player::drawHUD(void)
{
    char ammo_left[5], shield_percent[5], armour_percent[5],lives_left[4];
    float xPos=0,yPos=0;
    RGB c1={200,0,0},c2={0,0,200};
    

    if(hudl.retExist()==false)
        hudl.setPict(400,70,"images/hudl_closed.bmp",false);
    if(hudr.retExist()==false)
        hudr.setPict(400,70,"images/hudr_3.bmp",false);

    
 
    ortho_begin(SCREEN_W, SCREEN_H);

    if(ship.retAmmoLeft()!=UNLIMITED_AMMO)
        sprintf(ammo_left,"%d",ship.retAmmoLeft());
    else
        sprintf(ammo_left,"",ship.retWepName()); 
    
    sprintf(shield_percent,"%d%%",(int)ship.retSheildHealth());  
    sprintf(armour_percent,"%d%%",(int)ship.retArmorHealth());

    if(lives>0) 
        sprintf(lives_left,"%d",lives); 
    else
        sprintf(lives_left,"");

    xPos=400;
    yPos=525;
    /*writeText_2D(xPos+335,yPos+50,0,makecol(0,0,0),allFonts[4],atts.sName);
    writeText_2D(xPos+178,yPos+50,40,makecol(0,0,0),allFonts[4],ship.retWepName());
    writeText_2D(xPos+62,yPos+55,40,makecol(0,0,0),allFonts[3],ammo_left);
    ship.drawWepHud(xPos+138,yPos+47);*/
    drawBar2D(xPos+221, yPos+38, 0, 165, 10, p1a, c1, c1,armourParts);
    drawBar2D(xPos+221, yPos+21, 0, 165, 10, p1s, c2, c2,shieldParts);
    
    hudl.drawPict(makeVector2(200,563,true));
    hudr.drawPict(makeVector2(600,563,true));

    writeText_2D(xPos+335,yPos+50,0,makecol(0,0,0),allFonts[4],atts.sName);
    writeText_2D(xPos+178,yPos+50,40,makecol(0,0,0),allFonts[4],ship.retWepName());
    writeText_2D(xPos+52,yPos+55,40,makecol(0,0,0),allFonts[3],ammo_left);
    ship.drawWepHud(xPos+138,yPos+47);
    writeText_2D(xPos+185,yPos+17,40,makecol(0,0,0),allFonts[4],shield_percent);
    writeText_2D(xPos+185,yPos+34,40,makecol(0,0,0),allFonts[4],armour_percent);    
    writeText_2D(xPos+75,yPos+5,40,makecol(200,200,200),allFonts[3],lives_left);
    
    drawScore(false);
    
    ortho_end();
    
    if(ship.retWepHoming()==true)   //only display the tageting reticle if a weapon with homing is selected
    {
        drawTargetRet(/*playerNum*/0);
    }
    else
        targTime=0;  
}


void Player::respawn(int playerNum)
{
    //if(playerNum==0)
        ship.respawn(atts.startX,atts.startY);
    //else if(playerNum==1)
    //    ship.respawn(15,0);
        
    if(GameSettingsSingleton::instance()->getCoOp()==false)
    {
         //reset the multiplier back to one for the current player
        ScoreKeeper::instance()->addToMultiplier(-1,playerNum);   
    }    
    else
    {
        //reset the multiplier back to one for both players
        ScoreKeeper::instance()->addToMultiplier(-1,0);
        ScoreKeeper::instance()->addToMultiplier(-1,1);
    }    
}

void Player::setid(int _id, int _team_id) 
{
    id=_id; 
    team_id = _team_id;
    ship.setid(id,team_id);
}

void Player::drawHotSeatHUD(int playerNum)
{

    if(hudl.retExist()==false)
        hudl.setPict(400,70,"images/hudl_3.bmp",false);
    if(hudr.retExist()==false)
        hudr.setPict(400,70,"images/hudr_3.bmp",false);

    //if(blue_bar.retExist()==false)
    //    blue_bar.setPict(161,10,"w_hud/blue_bar.bmp");

    char ammo_left[4], shield_percent[5], armour_percent[5], lives_left[4];
    int xPos,yPos;
    
    if(ship.retWepHoming()==true)   //only display the tageting reticle if a weapon with homing is selected
    {
        drawTargetRet(playerNum);
    }
    else
        targTime=0;   
           
    if(ship.retAmmoLeft()!=UNLIMITED_AMMO)
        sprintf(ammo_left,"%d",ship.retAmmoLeft());
    else
        sprintf(ammo_left,"",ship.retWepName());           
           
    sprintf(shield_percent,"%d%%",(int)ship.retSheildHealth());  
    sprintf(armour_percent,"%d%%",(int)ship.retArmorHealth());  
    if(lives>0) 
        sprintf(lives_left,"%d",lives); 
    else
        sprintf(lives_left,"");
   
    ortho_begin(SCREEN_W, SCREEN_H);
    RGB c1={200,0,0},c2={0,0,200};
        if(playerNum==0)
        {
            xPos=400;
            yPos=525;
            

            drawBar2D(xPos+221, yPos+38, 0, 165, 10, p1a, c1, c1,armourParts);
            drawBar2D(xPos+221, yPos+21, 0, 165, 10, p1s, c2, c2,shieldParts);
            
            hudr.drawPict(makeVector2(600,563,true));

            writeText_2D(xPos+335,yPos+50,0,makecol(0,0,0),allFonts[4],atts.sName);
            writeText_2D(xPos+178,yPos+50,40,makecol(0,0,0),allFonts[4],ship.retWepName());
            writeText_2D(xPos+52,yPos+55,40,makecol(0,0,0),allFonts[3],ammo_left);
            ship.drawWepHud(xPos+138,yPos+47);
            writeText_2D(xPos+185,yPos+17,40,makecol(0,0,0),allFonts[4],shield_percent);
            writeText_2D(xPos+185,yPos+34,40,makecol(0,0,0),allFonts[4],armour_percent);
            writeText_2D(xPos+75,yPos+5,40,makecol(200,200,200),allFonts[3],lives_left);
        }    
        else if(playerNum==1)
        {
            xPos=0;
            yPos=525;
            
            drawBar2D(xPos+16, yPos+38, 0, 165, 10, p1a, c1, c1,armourParts);
            drawBar2D(xPos+16, yPos+21, 0, 165, 10, p1s, c2, c2,shieldParts);
            
            hudl.drawPict(makeVector2(200,563,true));

            writeText_2D(xPos+3,yPos+50,0,makecol(0,0,0),allFonts[4],atts.sName);
            writeText_2D(xPos+100,yPos+50,40,makecol(0,0,0),allFonts[4],ship.retWepName());
            writeText_2D(xPos+300,yPos+55,40,makecol(0,0,0),allFonts[3],ammo_left);
            ship.drawWepHud(xPos+262,yPos+47);
            writeText_2D(xPos+185,yPos+17,40,makecol(0,0,0),allFonts[4],shield_percent);
            writeText_2D(xPos+185,yPos+34,40,makecol(0,0,0),allFonts[4],armour_percent);
            writeText_2D(xPos+305,yPos+5,40,makecol(200,200,200),allFonts[3],lives_left);
        }        


        drawScore(true);
        
        /*if(ship.retAmmoLeft()!=UNLIMITED_AMMO)
            sprintf(buf,"Weapon: %s  %d",ship.retWepName(),ship.retAmmoLeft());
        else
            sprintf(buf,"Weapon: %s  ",ship.retWepName());
        
        writeText_2D(xPos,520,40,makecol(255,255,255),allFonts[1],buf);
        sprintf(buf,"Shield: %0.0f %%  Armor: %0.0f %% L:%d",ship.retSheildHealth(),ship.retArmorHealth(),lives);
        writeText_2D(xPos,540,40,makecol(255,255,255),allFonts[1],buf);*/
    ortho_end(); 
    //RGB c1={255,0,0};
    //drawBar(0,0, 0, 163, 18,ship.retArmorHealth(), c1, c1);
}

void Player::drawScore(bool hotseat)
{
    if(ScoreKeeper::instance()->getType()==INCREASING_TIME || ScoreKeeper::instance()->getType()==DECREASING_TIME)
    {
        char timeLeft[5];
        sprintf(timeLeft,"%0.1f",((float)ScoreKeeper::instance()->getTimeLeft() / 32));
        writeText_2D(375,545,40,makecol(200,200,200),allFonts[3],timeLeft);
    } 
    else if(ScoreKeeper::instance()->getType()==SCORE_BASED)
    {
        char score[5];
        sprintf(score,"Score %d",ScoreKeeper::instance()->getScore(0));
        writeText_2D(340,547,40,makecol(200,200,200),allFonts[4],score);    
        sprintf(score,"x%0.2f",ScoreKeeper::instance()->getMultiplier(0));
        writeText_2D(370,567,40,makecol(150,50,50),allFonts[4],score);      
    }    
}

void Player::adjustHudBars(float x, float y, float width, float height)
{
    float a,s;
    a = ship.retArmorHealth()/100;
    s = ship.retSheildHealth()/100;
    
    if(p1a > a+.03)
        p1a-=.03;
    else if(p1a < a-.03)
        p1a+=.03;
    if(a<.005)
        p1a=0;
        
    if(p1s > s+.03)
        p1s-=.03;
    else if(p1s < s-.03)
        p1s+=.03;
    if(s<.005)
        p1s=0;
        
    
    //shieldParts->update();
    
    float ox,oy;
    
    ox = (x+width*p1a);
    oy = (y+height*.5);
    oy+=17;
    oy = 600-oy;
    ox = ox * .117;
    oy = oy * .117;
    ox -= 47;
    oy -= 35;

    armourParts->setPosition(makeVector3(ox,oy,0));
    
    if(p1a>0)
        armourParts->update();    
    
    ox = (x+width*p1s);
    oy = (y+height*.5);
    oy = 600-oy;
    ox = ox * .117;
    oy = oy * .117;
    ox -= 47;
    oy -= 35;
    shieldParts->setPosition(makeVector3(ox,oy,0));
    
    if(p1s>0)
        shieldParts->update();
    

}

void Player::setHudPartGens(ParticleGenerator *a,ParticleGenerator *s)
{
    armourParts = a;
    shieldParts = s;    
}    

void Player::draw(void)
{
    
    ship.draw(false);
}

void Player::update(int playerNum, BRect bounds)
{
    ship.update(bounds);
    
    if(respawnCounter>0)
        respawnCounter--;
    
    if(respawnCounter==1)
    {
        if(lives>0)
            lives--;

        if(lives>0 || lives==-1)    //-1 means infinite lives
            respawn(playerNum);   
    }        
        
    if(playerNum==0)
        adjustHudBars(400+221,525+22 , 165,10);     
    else if(playerNum==1)
        adjustHudBars(0+16,525+22 , 165,10); 
    //    adjustP2HudBars(); 
        
    retAngle+=3;
    targTime++;
}

void Player::startRespawnCounter(void)
{
    if(respawnCounter==0)
        respawnCounter=40;
}

void Player::init(void)
{

    bExist=false;
    ship.init();
    
    strcpy(atts.sName,"");
    atts.iColour=0;
    atts.iShipNum=0;
    respawnCounter=0;

    id=0;
    retAngle=0;
    targTime=0;
    
    p1s=0;
    p1a=0;
    p2s=0;
    p2a=0;
    
    armourParts=0;
    shieldParts=0;
    //blue_bar.setExist(false);
    //blue_bar.setPict(161,10,"w_hud/blue_bar.bmp");
        //hudl.setPict(400,75,"hudl_2.bmp");
        
}

void Player::findTarget(BRect **targets, int nTargets)
{
    float smallestDist=1000000;
    float temp;
    BRect *targ=0;
    for(int n=0 ; n<nTargets ; n++)
    {
        if( targets[n]->retExist()==true && targets[n]->targetable()==true && targets[n]!=&ship && ship.retid()!=targets[n]->retid())
        {
            //CVector2 sp=ship.retPos() + ship.retAccel()*10;
            temp = fast_get_dist(ship.retPos() .retX() + ship.retAccel().retX()*10,
                            ship.retPos() .retY() + ship.retAccel().retY()*10,
                            targets[n]->retPos().retX(),
                            targets[n]->retPos().retY());
            if(temp < smallestDist)
            {
                smallestDist = temp;
                targ = targets[n];
            }    
            //setTarget(targets[n]);   
        }          
    }
    if(targ != ship.retTarget() && targ)  //new target found
        targTime=0;
    //if(targ)
    setTarget(targ);        
}    

void Player::drawTargetRet(int playerNum)
{
    BRect *targ = ship.retTarget();
    if(targ && targTime>0)
    {
        glPushMatrix();
        glTranslatef(targ->retPos().retX(),targ->retPos().retY(),0);
        glRotatef(retAngle,0,0,1);
        
        if(targTime>15)
            targTime=15;
            
        glScalef( pow((float)1.15,(float)(15-targTime)) , pow((float)1.15,(float)(15-targTime)) , 0);
    
        glDisable(GL_LIGHTING);
        glBegin(GL_LINES);
    
    
            if(playerNum==0)
                glColor3f(.7,0.,0.);
            else
                glColor3f(0.,.6,0.);
            
            //glVertex3f(targ->retPos().retX(),targ->retPos().retY(),0);
            //glVertex3f(targ->retPos().retX(),targ->retPos().retY()-5,0);
            int points=40;
            float incr = (M_PI*2)/(float)points, curAng;
            
            if(playerNum==0)
                curAng=0;
            else if(playerNum==1)
                curAng=M_PI/8;
            
            for(int n=0 ; n<points ; n++)
            {
                if( curAng<=M_PI/4 || ( curAng>=M_PI/2 && curAng<=3*M_PI/4) || (curAng>=M_PI && curAng<=5*M_PI/4) || (curAng>=3*M_PI/2 && curAng<=7*M_PI/4) )
                {
                    glVertex3f(cos(curAng)*(targ->retRadius()*1.2),
                            sin(curAng)*(targ->retRadius()*1.2),
                            0); 
                    glVertex3f(cos(curAng+incr)*(targ->retRadius()*1.2),
                            sin(curAng+incr)*(targ->retRadius()*1.2),
                            0); 
                            
                    glVertex3f(cos(curAng)*(targ->retRadius()*1.2),sin(curAng)*(targ->retRadius()*1.2),0);
                    glVertex3f(cos(curAng)*(targ->retRadius()*1.4),sin(curAng)*(targ->retRadius()*1.4),0);    

                }     
                curAng+=incr;    
            }  
        
        glEnd();
        glPopMatrix();    
    }    

    glEnable(GL_LIGHTING);   
}    

void Player::drawBar2D(float x, float y, float z, float width, float height, float percentFull, RGB c1, RGB c2,ParticleGenerator* pg)
{
    glDisable(GL_LIGHTING);    
    glDisable(GL_TEXTURE_2D);
    glDepthMask(false);
    
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    glBegin(GL_QUADS);
        glColor4f((float)c1.r/255,(float)c1.g/255,(float)c1.b/255,.5);
        
        glVertex3f(x,y,z);
        glVertex3f(x,y+height,z);
        glVertex3f(x+width*percentFull,y+height,z);
        glVertex3f(x+width*percentFull,y,z);  
        
        
        
        
    glEnd();
    glDisable(GL_BLEND);

}









