/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef pobject_def
#define pobject_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "Object.h"
#include "ParticleSystem.h"
#include "ParticleGenerator.h"
#include "BRect.h"
#include "SObject.h"

#define MAX_GEN  20

using namespace std;

class PObject : public SObject
{
protected:
    CVector2 accel;
    float ang_vel, ang_accel;   //the angular acceleration and velocity
    int strafeCooldown;
    
    float bank;

//    ParticleSystem  *smokeSys;  //pointer to a partile system to use for smoke
//    ParticleSystem  *sparksSys; //pointer to a partile system to use for sparks
    //ParticleSystem *partSys[MAX_PS];
    ParticleGenerator *partGen[MAX_GEN];
    int nPartGen;
    ParticleGenerator *onDeathPartGen;

    
    bool bDoesAccel;
    
    BRect *target;        //pointer to target (used for homing)

    void init(void);
    float scale;
    
    int ax,ay,az;     //for rotation about the axis of the model
    
public:
    void update(void);
    void draw(bool wireframe=false);
    
    
    void accelerate(float amount);
    void dampenVelocity(float amount);
    void dampenAngVelocity(float amount);
    void turnRight(float amount);
    void turnLeft(float amount);
    void strafeLeft(float amount);
    void strafeRight(float amount);
    
    void setAccel(CVector2 _accel){accel = _accel;}
    
    CVector2 retAccel(void) {return accel;}
    float retAngVel(void) {return ang_vel;}
    
    void reactToCollision(TColInfo colInfo);
    
    //void setSmokeSys(ParticleSystem *ps) { smokeSys = ps;}
    //void setSparksSys(ParticleSystem *ps) { sparksSys = ps;}
    void addPartsGen(ParticleGenerator *pg);
    void setOnDeathPartGen(ParticleGenerator *pg) { onDeathPartGen=pg;}
    virtual CVector3 setPartGenPos(void);
    
    void setTarget(BRect *_target);
    BRect* retTarget(void) {return target;}
    
    void resetAtts(void);

    PObject(void);
    ~PObject(void);

};


#endif
