/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "PObject.h"

void PObject::reactToCollision(TColInfo colInfo)
{
    //CVector2 o(10,0);
    //pos+=o;
}

/*
void PObject::updateSmokeSys(void)
{
    if(accel.retMag()==0)
        smokeSys->pauseSystem();
    else
        smokeSys->unpauseSystem();
    updatePartSys(smokeSys);
}

void PObject::updateSparksSys(void)
{
    if(accel.retMag()==0)
        sparksSys->pauseSystem();
    else
        sparksSys->unpauseSystem();
    updatePartSys(sparksSys);
}*/

/*void PObject::updatePartSys(ParticleSystem *ps)
{
    CVector3 p,d;

    if(ps->isThruster()==true)
    {
        if(accel.retMag()==0)
            ps->pauseSystem();
        else
            ps->unpauseSystem();    
    }
   
    p.setVector(pos.retX(),pos.retY(),0);
    d.setVector(-accel.retX()/2,accel.retY()/2,0);  
        
    //ss.setDensity((int)( vel.retMag()*10 ));
//    ps->setPosition(p);  
//    ps->setDirection(d);    
    
    ps->move();
}
*/

CVector3 PObject::setPartGenPos(void)
{
    CVector3 p;
    p.setVector(pos.retX(),pos.retY(),0);
    return p;  
}    

void PObject::update(void)
{
    /*if(smokeSys)
        updateSmokeSys();  
    if(sparksSys!=0)
        updateSparksSys();*/
    CVector3 p,d;


    if(exist==true)
    {
    
        for(int n=0 ; n<nPartGen ; n++)
        {
            if(partGen[n]->retGenAtts().thruster==true)
            {
                if(accel.retMag()<=0)
                    partGen[n]->pause();
                else
                {
                    partGen[n]->start();   
                    
                    partGen[n]->setPosition(this->setPartGenPos());
                    d.setVector(-accel.retX()/2,accel.retY()/2,0); 
                    partGen[n]->setDirection(d); 
                    partGen[n]->update(); 
                }
            }
            else if(partGen[n]->retGenAtts().collision==true)
            {
                if(pointOfCollision.retX()!=0 && pointOfCollision.retY()!=0)
                {
                    p.setVector(pointOfCollision.retX()+pos.retX(),pointOfCollision.retY()+pos.retY(),0);
                    d.setVector(pointOfCollision.retX()/10,pointOfCollision.retY()/10,0);
                    //p.setVector(0,0,0);
                    
                    partGen[n]->setPosition(p);  
                    partGen[n]->setDirection(d);            
                
                    partGen[n]->makeSparks();
                }
            }
            else if(partGen[n]->retGenAtts().constant==true)
            {
                //partGen[n]->start();                            
                p.setVector(pos.retX(),pos.retY(),0);
                d.setVector(-accel.retX()*partGen[n]->retGenAtts().vel,accel.retY()*partGen[n]->retGenAtts().vel,0); 
                partGen[n]->setPosition(p);  
                partGen[n]->setDirection(d);   
            
                partGen[n]->update();
            } 
        }    
    

        pos+=vel;       //apply the velocity to the object's position
          
        vel+=accel;     //apply the accleration to the velocity
          
        ang_vel += ang_accel;   //apply the angular acceleration to the angular velocity
        accel=accel.rotate(ang_vel);    //rotate the object's acceleration vector by the angular velocity
        
        if(bank>0)
            bank--;
        else if(bank<0)
            bank++;
            
        if(invincibleCounter>0)
            invincibleCounter--;
            
        if(strafeCooldown>0)
            strafeCooldown--;
    }
}

void PObject::addPartsGen(ParticleGenerator *pg)
{
    partGen[nPartGen] = pg;
    nPartGen++;
}



void PObject::draw(bool wireframe)
{
         
    /*if(smokeSys)
        smokeSys->draw();
    if(sparksSys!=0)
        sparksSys->draw();*/


    if(exist==true)
    {
        if(bHasModel==true)
        {
            glPushMatrix();            
           
                CVector2 yAxis(0,1,false);          //a temp vector that represents the y-axis
                float angRad=0;
                
                if(bDoesAccel==true)
                {
                    angRad = acos(yAxis|accel);   //the angle between the y axis and the object's acceleration
                    if(accel.retX()<0)                  
                        angRad=-angRad; 
                    setAngle(angRad*RAD2DEG);
                }
                else if(projType!=ASTEROID)
                {
                    angRad = acos(yAxis|vel);
                    if(vel.retX()<0)                  
                        angRad=-angRad; 
                    setAngle(angRad*RAD2DEG);
                }
                
                glTranslatef(pos.retX(),pos.retY(),0);     //translate the model position
                
                if(angRad!=0)
                    glRotatef(-angRad*RAD2DEG,0,0,1);    //rotate it
                
                if(ax!=0)
                    glRotated(ax,1,0,0);
                if(ay!=0)
                    glRotated(ay,0,1,0);
                if(az!=0)
                    glRotated(az,0,0,1);                
                
                //BRect::draw();        //draw the bounding box
                
                if(scale!=1)
                    glScalef(scale,scale,scale);
                               
                glRotatef(bank,0,1,0);
                
                if(model) 
                    model->draw(wireframe);
            
            glPopMatrix();
        }
        else
            BRect::draw(wireframe);
    
        //glTranslatef(-pos.retX(),pos.retY(),0); 
    
    //glRotatef(angRad*RAD2DEG,0,0,1);  
    
    
    }
    
}
    
void PObject::setTarget(BRect *_target)
{
    target=_target;
}    
    
void PObject::accelerate(float amount)
{
    accel.setMag(amount);
    //vel+=accel;
} 
    
void PObject::turnLeft(float amount)
{
    ang_accel=-amount;
//    ang_vel += amount;    //duel 2 style
    
    if(bank>-45)
        bank-=5 * accel.retMag()*100;
}

void PObject::turnRight(float amount)
{
    ang_accel=amount;
//    ang_vel -= amount;    //duel 2 style
    
    if(bank<45)
        bank+=5 * accel.retMag()*100;
}    
    
void PObject::strafeLeft(float amount){
    if(strafeCooldown==0){
        float x,y;
        x=CVector2::normalize(accel).retX();
        y=CVector2::normalize(accel).retY();
        
        vel += makeVector2(-y,x,false)*amount;

        

        strafeCooldown=50;
    }
}

void PObject::strafeRight(float amount){
    if(strafeCooldown==0){
        float x,y;
        x=CVector2::normalize(accel).retX();
        y=CVector2::normalize(accel).retY();
        
        vel -= makeVector2(-y,x,false)*amount;
        
        
        
        strafeCooldown=50;
    }
}  

void PObject::dampenVelocity(float amount)
{
    accel.setMag(0);
    vel*=amount;
}

void PObject::dampenAngVelocity(float amount)
{
    ang_accel=0;
    ang_vel*=amount;
}
    
    

void PObject::init(void)
{
    accel.setVector(0,1,false,true);
    accel.setMag(0);
    ang_vel=0; ang_accel=0; 
    bank=0;
    //smokeSys=0;
    //sparksSys=0;
    nPartGen=0;
    bDoesAccel=true;
    scale=1;
    
    ax=0;
    ay=0;
    az=0;
    invincibleCounter=0;
    target=0;
    
    strafeCooldown=0;
}
    
PObject::PObject(void)
{
    init();
}

PObject::~PObject(void)
{

}
