/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef NEWMENU_H
#define NEWMENU_H

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"
#include "GameSettingsSingleton.h"
#include "Model.h"
#include "ShipArray.h"
#include "Widget.h"

#include <vector>
using namespace std;

#define NO_TRANSITION   -1
#define QUIT_MENU       -2
#define QUIT_GAME       -3



typedef struct
{
    int nWidgets;
    Widget** widgets; 
    
    int *widgetTransitions; 
    int gameModeResult;
          
}TMenuPage;    
      

class NewMenu
{
private:
    //used for displaying the demo ships
    Model *allModels;       //pointer to array of models
    ShipArray *shipDefs;    //pointer to array of shipDefs
    
    vector<TMenuPage> pages;
    int curPage,prevPage;
    
    //vector<Widget*> widgets;
    
    TMouse mouse;
    
    void drawBackground();
    void drawPage();
    void drawMouse();
    
    bool quitMenu,quitGame;
    
    vector<TWidgetStatus> pageResults;  //array of game mode properties to be set in the menu, and used to initalize the game mode
    int gameModeResult;

public:
    NewMenu();
    ~NewMenu();
    
    void setModels(Model *_allModels) {allModels = _allModels;}
    void setShipDefs(ShipArray *_shipDefs) {shipDefs = _shipDefs;}
    
    void addPage(TMenuPage newPage);
    
    void init(void);
    void create(void);
    void reset(void);
    
    void setupPage(void);   //sets up the current page to be displayed

    bool retQuitGame(void);
    int retCurPage(void) {return curPage;}
    
    void doTransition(TWidgetStatus s);
    void setResults(void);
    vector<TWidgetStatus>* getResults(void) {return &pageResults;}
    
    int getGameModeResult(void) {return gameModeResult;}
    
    void draw(void);
    bool update(void);

};

#endif // NEWMENU_H

